/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.TransformFilter;

public class TwirlFilter
extends TransformFilter {
    static final long serialVersionUID = 1550445062822803342L;
    private float angle = 0.0f;
    private float centreX = 0.0f;
    private float centreY = 0.0f;
    private float radius = 0.0f;
    private float radius2 = 0.0f;

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getAngle() {
        return this.angle;
    }

    @Override
    public void setDimensions(int width, int height) {
        super.setDimensions(width, height);
        this.centreX = width / 2;
        this.centreY = height / 2;
        this.radius = Math.min(this.centreX, this.centreY);
        this.radius2 = this.radius * this.radius;
    }

    @Override
    protected void transformInverse(int x, int y, float[] out) {
        float dx = (float)x - this.centreX;
        float dy = (float)y - this.centreY;
        float distance = dx * dx + dy * dy;
        if (distance > this.radius2) {
            out[0] = x;
            out[1] = y;
        } else {
            distance = (float)Math.sqrt(distance);
            float a = (float)Math.atan2(dy, dx) + this.angle * (this.radius - distance) / this.radius;
            out[0] = this.centreX + distance * (float)Math.cos(a);
            out[1] = this.centreY + distance * (float)Math.sin(a);
        }
    }

    public String toString() {
        return "Distort/Twirl...";
    }
}

