/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.ImageMath;
import com.alkacon.simapi.filter.WholeImageFilter;
import java.awt.Rectangle;

public abstract class TransformFilter
extends WholeImageFilter {
    public static final int ZERO = 0;
    public static final int CLAMP = 1;
    public static final int WRAP = 2;
    protected int edgeAction = 0;

    public void setEdgeAction(int edgeAction) {
        this.edgeAction = edgeAction;
    }

    public int getEdgeAction() {
        return this.edgeAction;
    }

    protected abstract void transformInverse(int var1, int var2, float[] var3);

    @Override
    protected void transformSpace(Rectangle rect) {
    }

    @Override
    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int srcWidth = this.originalSpace.width;
        int srcHeight = this.originalSpace.height;
        int outWidth = this.transformedSpace.width;
        int outHeight = this.transformedSpace.height;
        int index = 0;
        int[] outPixels = new int[outWidth * outHeight];
        int outX = this.transformedSpace.x;
        int outY = this.transformedSpace.y;
        int[] rgb = new int[4];
        float[] out = new float[2];
        for (int y = 0; y < outHeight; ++y) {
            for (int x = 0; x < outWidth; ++x) {
                this.transformInverse(outX + x, outY + y, out);
                int srcX = (int)out[0];
                int srcY = (int)out[1];
                if (out[0] < 0.0f || srcX >= srcWidth || out[1] < 0.0f || srcY >= srcHeight) {
                    int p;
                    switch (this.edgeAction) {
                        default: {
                            p = 0;
                            break;
                        }
                        case 2: {
                            p = this.inPixels[ImageMath.mod(srcY, srcHeight) * srcWidth + ImageMath.mod(srcX, srcWidth)];
                            break;
                        }
                        case 1: {
                            p = this.inPixels[ImageMath.clamp(srcY, 0, srcHeight - 1) * srcWidth + ImageMath.clamp(srcX, 0, srcWidth - 1)];
                        }
                    }
                    outPixels[index++] = p;
                    continue;
                }
                float xWeight = out[0] - (float)srcX;
                float yWeight = out[1] - (float)srcY;
                int i = srcWidth * srcY + srcX;
                int dx = srcX == srcWidth - 1 ? 0 : 1;
                int dy = srcY == srcHeight - 1 ? 0 : srcWidth;
                rgb[0] = this.inPixels[i];
                rgb[1] = this.inPixels[i + dx];
                rgb[2] = this.inPixels[i + dy];
                rgb[3] = this.inPixels[i + dx + dy];
                outPixels[index++] = ImageMath.bilinearInterpolate(xWeight, yWeight, rgb);
            }
        }
        this.consumer.setPixels(0, 0, outWidth, outHeight, this.defaultRGBModel, outPixels, 0, outWidth);
        this.consumer.imageComplete(status);
        this.inPixels = null;
        outPixels = null;
    }
}

