/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.TransformFilter;

public class SphereFilter
extends TransformFilter {
    static final long serialVersionUID = -8148404526162968279L;
    private float a = 0.0f;
    private float b = 0.0f;
    private float a2 = 0.0f;
    private float b2 = 0.0f;
    private float refractionIndex = 1.5f;

    public void setRefractionIndex(float refractionIndex) {
        this.refractionIndex = refractionIndex;
    }

    public float getRefractionIndex() {
        return this.refractionIndex;
    }

    @Override
    public void setDimensions(int width, int height) {
        super.setDimensions(width, height);
        this.a = width / 2;
        this.b = height / 2;
        this.a2 = this.a * this.a;
        this.b2 = this.b * this.b;
    }

    @Override
    protected void transformInverse(int x, int y, float[] out) {
        float dy = (float)y - this.b;
        float y2 = dy * dy;
        float dx = (float)x - this.a;
        float x2 = dx * dx;
        if (y2 >= this.b2 - this.b2 * x2 / this.a2) {
            out[0] = x;
            out[1] = y;
        } else {
            float rRefraction = 1.0f / this.refractionIndex;
            float z = (float)Math.sqrt((1.0f - x2 / this.a2 - y2 / this.b2) * (this.a * this.b));
            float z2 = z * z;
            float xAngle = (float)Math.acos((double)dx / Math.sqrt(x2 + z2));
            float angle1 = 1.5707964f - xAngle;
            float angle2 = (float)Math.asin(Math.sin(angle1) * (double)rRefraction);
            angle2 = 1.5707964f - xAngle - angle2;
            out[0] = (float)x - (float)Math.tan(angle2) * z;
            float yAngle = (float)Math.acos((double)dy / Math.sqrt(y2 + z2));
            angle1 = 1.5707964f - yAngle;
            angle2 = (float)Math.asin(Math.sin(angle1) * (double)rRefraction);
            angle2 = 1.5707964f - yAngle - angle2;
            out[1] = (float)y - (float)Math.tan(angle2) * z;
        }
    }

    public String toString() {
        return "Distort/Sphere...";
    }
}

