/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.WholeImageFilter;

public class OilFilter
extends WholeImageFilter {
    static final long serialVersionUID = 1722613531684653826L;
    public int range = 3;

    @Override
    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int width = this.originalSpace.width;
        int height = this.originalSpace.height;
        int index = 0;
        int[] rHistogram = new int[256];
        int[] gHistogram = new int[256];
        int[] bHistogram = new int[256];
        int[] outPixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                for (int i = 0; i < 256; ++i) {
                    bHistogram[i] = 0;
                    gHistogram[i] = 0;
                    rHistogram[i] = 0;
                }
                for (int row = -this.range; row <= this.range; ++row) {
                    int iy = y + row;
                    if (0 > iy || iy >= height) continue;
                    int ioffset = iy * width;
                    for (int col = -this.range; col <= this.range; ++col) {
                        int ix = x + col;
                        if (0 > ix || ix >= width) continue;
                        int rgb = this.inPixels[ioffset + ix];
                        int n = rgb >> 16 & 0xFF;
                        rHistogram[n] = rHistogram[n] + 1;
                        int n2 = rgb >> 8 & 0xFF;
                        gHistogram[n2] = gHistogram[n2] + 1;
                        int n3 = rgb & 0xFF;
                        bHistogram[n3] = bHistogram[n3] + 1;
                    }
                }
                int r = 0;
                int g = 0;
                int b = 0;
                for (int i = 1; i < 256; ++i) {
                    if (rHistogram[i] > rHistogram[r]) {
                        r = i;
                    }
                    if (gHistogram[i] > gHistogram[g]) {
                        g = i;
                    }
                    if (bHistogram[i] <= bHistogram[b]) continue;
                    b = i;
                }
                outPixels[index++] = 0xFF000000 | r << 16 | g << 8 | b;
            }
        }
        this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, outPixels, 0, width);
        this.consumer.imageComplete(status);
        this.inPixels = null;
    }

    public String toString() {
        return "Stylize/Oil...";
    }
}

