/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

public class Kernel {
    public static final float R2 = (float)Math.sqrt(2.0);
    public static final float[] ROBERTS_V = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public static final float[] ROBERTS_H = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public static final float[] PREWITT_V = new float[]{-1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f};
    public static final float[] PREWITT_H = new float[]{-1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    public static final float[] SOBEL_V = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f};
    public static float[] SOBEL_H = new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f};
    public static final float[] FREI_CHEN_V = new float[]{-1.0f, 0.0f, 1.0f, -R2, 0.0f, R2, -1.0f, 0.0f, 1.0f};
    public static float[] FREI_CHEN_H = new float[]{-1.0f, -R2, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, R2, 1.0f};
    public static float[] EDGE_LAPLACE1 = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    public static float[] EDGE_LAPLACE2 = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 8.0f, -1.0f, -1.0f, -1.0f, -1.0f};
    public float[] matrix = null;
    public int rows;
    public int cols;
    public int xCentre;
    public int yCentre;

    public Kernel() {
        this(new float[9]);
    }

    public Kernel(float[] matrix) {
        this.setMatrix(3, 3, 1, 1, matrix);
    }

    public Kernel(int rows, int cols, float[] matrix) {
        this.setMatrix(rows, cols, matrix);
    }

    public Kernel(int rows, int cols, int xCentre, int yCentre, float[] matrix) {
        this.setMatrix(rows, cols, xCentre, yCentre, matrix);
    }

    public float[] getMatrix() {
        return this.matrix;
    }

    public void normalize() {
        int i;
        float total = 0.0f;
        for (i = 0; i < this.matrix.length; ++i) {
            total += this.matrix[i];
        }
        if (total != 0.0f) {
            i = 0;
            while (i < this.matrix.length) {
                int n = i++;
                this.matrix[n] = this.matrix[n] / total;
            }
        }
    }

    public void setMatrix(float[] matrix) {
        this.setMatrix(3, 3, 1, 1, matrix);
    }

    public void setMatrix(int rows, int cols, float[] matrix) {
        this.setMatrix(rows, cols, rows / 2, cols / 2, matrix);
    }

    public void setMatrix(int rows, int cols, int xCentre, int yCentre, float[] matrix) {
        this.rows = rows;
        this.cols = cols;
        this.xCentre = xCentre;
        this.yCentre = yCentre;
        this.matrix = matrix;
    }
}

