/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class IdentIcon {
    public static final Color COLOR_TRANSPARENT = new Color(255, 255, 255, 0);
    private static final float DEFAULT_PATCH_SIZE = 16.0f;
    public static final String IDENTICON_SALT = "(\u00a7!$/%.&#?@-_)";
    private static final int PATCH_GRIDS = 5;
    private static final byte PATCH_INVERTED = 1;
    private static final int PATCH_MOVETO = -1;
    private static final int[] PATCH_TYPES_CENTER = new int[]{0, 4, 8, 15, 1, 5, 7, 21, 23, 24, 25, 31, 6, 12, 11, 30};
    private static final byte[] patch00 = new byte[]{0, 4, 24, 20};
    private static final byte[] patch01 = new byte[]{0, 4, 20};
    private static final byte[] patch02 = new byte[]{2, 24, 20};
    private static final byte[] patch03 = new byte[]{0, 2, 20, 22};
    private static final byte[] patch04 = new byte[]{2, 14, 22, 10};
    private static final byte[] patch05 = new byte[]{0, 14, 24, 22};
    private static final byte[] patch06 = new byte[]{2, 24, 22, 13, 11, 22, 20};
    private static final byte[] patch07 = new byte[]{0, 14, 22};
    private static final byte[] patch08 = new byte[]{6, 8, 18, 16};
    private static final byte[] patch09 = new byte[]{4, 20, 10, 12, 2};
    private static final byte[] patch10 = new byte[]{0, 2, 12, 10};
    private static final byte[] patch11 = new byte[]{10, 14, 22};
    private static final byte[] patch12 = new byte[]{20, 12, 24};
    private static final byte[] patch13 = new byte[]{10, 2, 12};
    private static final byte[] patch14 = new byte[]{0, 2, 10};
    private static final byte[] patch15 = new byte[]{0, 4, 10};
    private static final byte[] patch16 = new byte[]{20, 24, 10};
    private static final byte[] patch17 = new byte[]{0, 20, 3};
    private static final byte[] patch18 = new byte[]{1, 4, 24};
    private static final byte[] patch19 = new byte[]{0, 1, 14, 21, 20};
    private static final byte[] patch20 = new byte[]{10, 0, 2, 22, 24, 14};
    private static final byte[] patch21 = new byte[]{5, 9, 22};
    private static final byte[] patch22 = new byte[]{10, 2, 22, 14};
    private static final byte[] patch23 = new byte[]{0, 20, 4, 24};
    private static final byte[] patch24 = new byte[]{0, 7, 4, 13, 24, 17, 20, 11};
    private static final byte[] patch25 = new byte[]{0, 3, 24};
    private static final byte[] patch26 = new byte[]{0, 15, 24};
    private static final byte[] patch27 = new byte[]{0, 2, 19};
    private static final byte[] patch28 = new byte[]{0, 10, 23};
    private static final byte[] patch29 = new byte[]{0, 2, 18, 10};
    private static final byte[] patch30 = new byte[]{0, 8, 16};
    private static final byte[] PATCH_FLAGS = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[][] PATCH_TYPES = new byte[][]{patch00, patch01, patch02, patch03, patch04, patch05, patch06, patch07, patch08, patch09, patch10, patch11, patch12, patch13, patch14, patch00, patch15, patch16, patch17, patch18, patch19, patch20, patch21, patch22, patch23, patch24, patch25, patch26, patch27, patch28, patch29, patch30};
    private Color m_backgroundColor;
    private MessageDigest m_digest;
    private Color m_reservedColor;
    private float m_patchOffset;
    private GeneralPath[] m_patchShapes;
    private float m_patchSize;
    private int m_size;

    public IdentIcon() {
        this.setPatchSize(16.0f);
        this.setBackgroundColor(COLOR_TRANSPARENT);
        this.setSize(32);
        this.setReservedColor(null);
        try {
            this.m_digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public float getPatchSize() {
        return this.m_patchSize;
    }

    public Color getReservedColor() {
        return this.m_reservedColor;
    }

    public int getSize() {
        return this.m_size;
    }

    public BufferedImage render(String input) {
        return this.render(input, false, this.getSize());
    }

    public BufferedImage render(String input, boolean allowProtected) {
        return this.render(input, allowProtected, this.getSize());
    }

    public BufferedImage render(String input, boolean allowProtected, int size) {
        byte[] hash = this.hash(input);
        hash[6] = allowProtected ? (byte)1 : 0;
        return this.renderIcon(hash, size);
    }

    public BufferedImage render(String input, int size) {
        return this.render(input, false, size);
    }

    public BufferedImage render(String input, int red, int green, int blue) {
        byte[] hash = this.hash(input);
        hash[2] = (byte)blue;
        hash[3] = (byte)green;
        hash[4] = (byte)red;
        return this.renderIcon(hash, this.getSize());
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.m_backgroundColor = backgroundColor;
    }

    public void setPatchSize(float size) {
        this.m_patchSize = size;
        this.m_patchOffset = this.m_patchSize / 2.0f;
        float patchScale = this.m_patchSize / 4.0f;
        this.m_patchShapes = new GeneralPath[PATCH_TYPES.length];
        for (int i = 0; i < PATCH_TYPES.length; ++i) {
            GeneralPath patch = new GeneralPath(1);
            boolean moveTo = true;
            byte[] patchVertices = PATCH_TYPES[i];
            for (int j = 0; j < patchVertices.length; ++j) {
                byte v = patchVertices[j];
                if (v == -1) {
                    moveTo = true;
                }
                float vx = (float)(v % 5) * patchScale - this.m_patchOffset;
                float vy = (float)Math.floor((float)v / 5.0f) * patchScale - this.m_patchOffset;
                if (!moveTo) {
                    patch.lineTo(vx, vy);
                    continue;
                }
                moveTo = false;
                patch.moveTo(vx, vy);
            }
            patch.closePath();
            this.m_patchShapes[i] = patch;
        }
    }

    public void setReservedColor(Color reservedColor) {
        this.m_reservedColor = reservedColor;
    }

    public void setSize(int size) {
        this.m_size = size;
    }

    protected void drawPatch(Graphics2D g, float x, float y, float size, int patch, int turn, boolean invert, Color fillColor, Color strokeColor) {
        assert (patch >= 0);
        assert (turn >= 0);
        turn %= 4;
        if ((PATCH_FLAGS[patch %= PATCH_TYPES.length] & 1) != 0) {
            invert = !invert;
        }
        GeneralPath shape = this.m_patchShapes[patch];
        double scale = (double)size / (double)this.m_patchSize;
        float offset = size / 2.0f;
        g.setComposite(AlphaComposite.getInstance(2));
        g.setColor(invert ? fillColor : this.m_backgroundColor);
        g.fill(new Rectangle2D.Float(x, y, size, size));
        AffineTransform savet = g.getTransform();
        g.translate(x + offset, y + offset);
        g.scale(scale, scale);
        g.rotate(Math.toRadians(turn * 90));
        if (strokeColor != null) {
            g.setColor(strokeColor);
            g.draw(shape);
        }
        g.setColor(invert ? this.m_backgroundColor : fillColor);
        g.fill(shape);
        g.setTransform(savet);
    }

    protected BufferedImage drawShape(int shape) {
        int size = 60;
        Color fill = new Color(179, 27, 52);
        Color stroke = null;
        BufferedImage targetImage = new BufferedImage(size, size, 2);
        Graphics2D g = targetImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setBackground(this.getBackgroundColor());
        g.clearRect(0, 0, size, size);
        this.drawPatch(g, 0.0f, 0.0f, size, shape, 0, false, fill, stroke);
        g.dispose();
        return targetImage;
    }

    protected float getColorDistance(Color c1, Color c2) {
        float dx = c1.getRed() - c2.getRed();
        float dy = c1.getGreen() - c2.getGreen();
        float dz = c1.getBlue() - c2.getBlue();
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    protected Color getComplementaryColor(Color color) {
        return new Color(color.getRGB() ^ 0xFFFFFF);
    }

    protected byte[] hash(String input) {
        byte[] hash = null;
        try {
            hash = this.m_digest.digest((IDENTICON_SALT + input + IDENTICON_SALT).getBytes("UTF-8"));
            hash[6] = 0;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace(System.err);
        }
        return hash;
    }

    protected BufferedImage renderIcon(byte[] hash, int size) {
        float s;
        Color fill;
        int hash0 = 0xFF & hash[0];
        int hash1 = 0xFF & hash[1];
        int hash2 = 0xFF & hash[5];
        int blue = 0xFF & hash[2];
        int green = 0xFF & hash[3];
        int red = 0xFF & hash[4];
        boolean allowProtected = hash[6] > 0;
        int middleType = PATCH_TYPES_CENTER[hash0 & 0xF];
        boolean middleInvert = (hash0 >> 5 & 1) != 0;
        int middleTurn = 0;
        int cornerType = hash1 & 0x1F;
        boolean cornerInvert = (hash1 >> 5 & 1) != 0;
        int cornerTurn = hash1 >> 6 & 3;
        int sideType = hash2 & 0x1F;
        boolean sideInvert = (hash2 >> 5 & 1) != 0;
        int sideTurn = hash2 >> 6 & 3;
        Color middleColor = fill = new Color(red, green, blue);
        if (this.m_reservedColor != null) {
            if (!allowProtected) {
                float distance = this.getColorDistance(fill, this.m_reservedColor);
                if (distance < 96.0f) {
                    middleColor = fill = this.getComplementaryColor(fill);
                }
            } else {
                middleColor = this.m_reservedColor;
                fill = middleColor.brighter();
                sideInvert = false;
                cornerInvert = false;
            }
        }
        Color stroke = null;
        if (this.getColorDistance(fill, this.getBackgroundColor()) < 32.0f) {
            stroke = this.getComplementaryColor(fill);
        }
        BufferedImage targetImage = new BufferedImage(size, size, 2);
        Graphics2D g = targetImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setBackground(this.getBackgroundColor());
        g.clearRect(0, 0, size, size);
        float bs1 = s = (float)size / 4.0f;
        float bs2 = s * 2.0f;
        float bs3 = s * 3.0f;
        this.drawPatch(g, bs1, bs1, s, middleType, middleTurn++, middleInvert, middleColor, stroke);
        this.drawPatch(g, bs2, bs1, s, middleType, middleTurn++, middleInvert, middleColor, stroke);
        this.drawPatch(g, bs2, bs2, s, middleType, middleTurn++, middleInvert, middleColor, stroke);
        this.drawPatch(g, bs1, bs2, s, middleType, middleTurn++, middleInvert, middleColor, stroke);
        Color sideColor = sideInvert ? fill.darker() : fill;
        sideInvert = false;
        this.drawPatch(g, bs1, 0.0f, s, sideType, sideTurn++, sideInvert, sideColor, stroke);
        this.drawPatch(g, bs2, 0.0f, s, sideType, sideTurn, sideInvert, sideColor, stroke);
        this.drawPatch(g, bs3, bs1, s, sideType, sideTurn++, sideInvert, sideColor, stroke);
        this.drawPatch(g, bs3, bs2, s, sideType, sideTurn, sideInvert, sideColor, stroke);
        this.drawPatch(g, bs2, bs3, s, sideType, sideTurn++, sideInvert, sideColor, stroke);
        this.drawPatch(g, bs1, bs3, s, sideType, sideTurn, sideInvert, sideColor, stroke);
        this.drawPatch(g, 0.0f, bs2, s, sideType, sideTurn++, sideInvert, sideColor, stroke);
        this.drawPatch(g, 0.0f, bs1, s, sideType, sideTurn, sideInvert, sideColor, stroke);
        Color cornerColor = cornerInvert ? fill.brighter() : fill;
        cornerInvert = false;
        this.drawPatch(g, 0.0f, 0.0f, s, cornerType, cornerTurn++, cornerInvert, cornerColor, stroke);
        this.drawPatch(g, bs3, 0.0f, s, cornerType, cornerTurn++, cornerInvert, cornerColor, stroke);
        this.drawPatch(g, bs3, bs3, bs1, cornerType, cornerTurn++, cornerInvert, cornerColor, stroke);
        this.drawPatch(g, 0.0f, bs3, s, cornerType, cornerTurn++, cornerInvert, cornerColor, stroke);
        g.dispose();
        return targetImage;
    }
}

