/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.Win32Lnk;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;

final class Win32File
extends File {
    private static final boolean IS_WINDOWS = Win32File.isWindows();

    private static boolean isWindows() {
        try {
            String os = System.getProperty("os.name");
            return os.toLowerCase().indexOf("windows") >= 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private Win32File(File pPath) {
        super(pPath.getPath());
    }

    public static void main(String[] pArgs) {
        int argIdx = 0;
        boolean recursive = false;
        while (pArgs.length > argIdx + 1 && pArgs[argIdx].charAt(0) == '-' && pArgs[argIdx].length() > 1) {
            if (pArgs[argIdx].charAt(1) == 'R' || pArgs[argIdx].equals("--recursive")) {
                recursive = true;
            } else {
                System.err.println("Unknown option: " + pArgs[argIdx]);
            }
            ++argIdx;
        }
        File file = Win32File.wrap(new File(pArgs[argIdx]));
        System.out.println("file: " + file);
        System.out.println("file.getClass(): " + file.getClass());
        Win32File.listFiles(file, 0, recursive);
    }

    private static void listFiles(File pFile, int pLevel, boolean pRecursive) {
        if (pFile.isDirectory()) {
            File[] files = pFile.listFiles();
            for (int l = 0; l < pLevel; ++l) {
                System.out.print(" ");
            }
            System.out.println("Contents of " + pFile + ": ");
            for (File file : files) {
                for (int l = 0; l < pLevel; ++l) {
                    System.out.print(" ");
                }
                System.out.println("  " + file);
                if (!pRecursive) continue;
                Win32File.listFiles(file, pLevel + 1, pLevel < 4);
            }
        }
    }

    public static File wrap(File pPath) {
        if (pPath == null) {
            return null;
        }
        if (IS_WINDOWS) {
            if (pPath instanceof Win32File || pPath instanceof Win32Lnk) {
                return pPath;
            }
            if (pPath.exists() && pPath.getName().endsWith(".lnk")) {
                try {
                    return new Win32Lnk(pPath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return new Win32File(pPath);
        }
        return pPath;
    }

    public static File[] wrap(File[] pPaths) {
        if (IS_WINDOWS) {
            for (int i = 0; pPaths != null && i < pPaths.length; ++i) {
                pPaths[i] = Win32File.wrap(pPaths[i]);
            }
        }
        return pPaths;
    }

    @Override
    public File getAbsoluteFile() {
        return Win32File.wrap(super.getAbsoluteFile());
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return Win32File.wrap(super.getCanonicalFile());
    }

    @Override
    public File getParentFile() {
        return Win32File.wrap(super.getParentFile());
    }

    @Override
    public File[] listFiles() {
        return Win32File.wrap(super.listFiles());
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        return Win32File.wrap(super.listFiles(filter));
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        return Win32File.wrap(super.listFiles(filter));
    }
}

