/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.FileSystem;
import com.alkacon.simapi.CmykJpegReader.FileUtil;
import com.alkacon.simapi.CmykJpegReader.StringTokenIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;

final class UnixFileSystem
extends FileSystem {
    UnixFileSystem() {
    }

    @Override
    long getFreeSpace(File pPath) {
        try {
            return this.getNumber(pPath, 3);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    long getTotalSpace(File pPath) {
        try {
            return this.getNumber(pPath, 5);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNumber(File pPath, int pIndex) throws IOException {
        BufferedReader reader = UnixFileSystem.exec(new String[]{"df", "-k", pPath.getAbsolutePath()});
        String last = null;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                last = line;
            }
        }
        finally {
            FileUtil.close(reader);
        }
        if (last != null) {
            String blocks = null;
            StringTokenIterator tokens = new StringTokenIterator(last, " ", -1);
            for (int count = 0; count < pIndex && tokens.hasNext(); ++count) {
                blocks = tokens.nextToken();
            }
            if (blocks != null) {
                try {
                    return Long.parseLong(blocks) * 1024L;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return 0L;
    }

    @Override
    String getName() {
        return "Unix";
    }
}

