/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class SystemUtil {
    public static String XML_PROPERTIES = ".xml";
    public static String STD_PROPERTIES = ".properties";

    private SystemUtil() {
    }

    public static Object clone(Cloneable pObject) throws CloneNotSupportedException {
        if (pObject == null) {
            return null;
        }
        if (pObject instanceof Object[]) {
            return ((Object[])pObject).clone();
        }
        if (pObject.getClass().isArray()) {
            int lenght = Array.getLength(pObject);
            Object clone = Array.newInstance(pObject.getClass().getComponentType(), lenght);
            System.arraycopy(pObject, 0, clone, 0, lenght);
            return clone;
        }
        try {
            Method clone = null;
            Class<?> clazz = pObject.getClass();
            while (true) {
                try {
                    clone = clazz.getDeclaredMethod("clone", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if ((clazz = clazz.getSuperclass()) != null) continue;
                }
                break;
            }
            if (clone == null) {
                throw new CloneNotSupportedException(pObject.getClass().getName());
            }
            if (!clone.isAccessible()) {
                clone.setAccessible(true);
            }
            return clone.invoke((Object)pObject, new Object[0]);
        }
        catch (SecurityException e) {
            CloneNotSupportedException cns = new CloneNotSupportedException(pObject.getClass().getName());
            cns.initCause(e);
            throw cns;
        }
        catch (IllegalAccessException e) {
            throw new CloneNotSupportedException(pObject.getClass().getName());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CloneNotSupportedException) {
                throw (CloneNotSupportedException)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new CloneNotSupportedException(pObject.getClass().getName());
        }
    }

    public static boolean isClassAvailable(String pClassName) {
        return SystemUtil.isClassAvailable(pClassName, (ClassLoader)null);
    }

    public static boolean isClassAvailable(String pClassName, Class pFromClass) {
        ClassLoader loader = pFromClass != null ? pFromClass.getClassLoader() : null;
        return SystemUtil.isClassAvailable(pClassName, loader);
    }

    public static boolean isFieldAvailable(String pClassName, String pFieldName) {
        return SystemUtil.isFieldAvailable(pClassName, pFieldName, (ClassLoader)null);
    }

    public static boolean isFieldAvailable(String pClassName, String pFieldName, Class pFromClass) {
        ClassLoader loader = pFromClass != null ? pFromClass.getClassLoader() : null;
        return SystemUtil.isFieldAvailable(pClassName, pFieldName, loader);
    }

    public static boolean isMethodAvailable(String pClassName, String pMethodName) {
        return SystemUtil.isMethodAvailable(pClassName, pMethodName, null, (ClassLoader)null);
    }

    public static boolean isMethodAvailable(String pClassName, String pMethodName, Class[] pParams) {
        return SystemUtil.isMethodAvailable(pClassName, pMethodName, pParams, (ClassLoader)null);
    }

    public static boolean isMethodAvailable(String pClassName, String pMethodName, Class[] pParams, Class pFromClass) {
        ClassLoader loader = pFromClass != null ? pFromClass.getClassLoader() : null;
        return SystemUtil.isMethodAvailable(pClassName, pMethodName, pParams, loader);
    }

    public static Properties loadProperties(Class pClass) throws IOException {
        return SystemUtil.loadProperties(pClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(Class pClass, String pName) throws IOException {
        InputStream is;
        boolean guessSuffix;
        String name = !StringUtil.isEmpty(pName) ? pName : pClass.getName().replace('.', '/');
        boolean bl = guessSuffix = pName == null || pName.indexOf(46) < 0;
        if ((pClass == null || (is = SystemUtil.getResourceAsStream(pClass.getClassLoader(), name, guessSuffix)) == null) && (is = SystemUtil.getResourceAsStream(ClassLoader.getSystemClassLoader(), name, guessSuffix)) == null && (is = SystemUtil.getFileAsStream(name, guessSuffix)) == null) {
            if (guessSuffix) {
                throw new FileNotFoundException(name + ".properties or " + name + ".xml");
            }
            throw new FileNotFoundException(name);
        }
        try {
            Properties properties = SystemUtil.loadProperties(is);
            return properties;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Properties loadProperties(String pName) throws IOException {
        return SystemUtil.loadProperties(null, pName);
    }

    public static void main(String[] args) throws CloneNotSupportedException {
        System.out.println("clone: " + ((String[])args.clone()).length + " (" + args.length + ")");
        System.out.println("copy: " + ((String[])SystemUtil.clone((Cloneable)args)).length + " (" + args.length + ")");
        int[] ints = new int[]{1, 2, 3};
        int[] copies = (int[])SystemUtil.clone((Cloneable)ints);
        System.out.println("Copies: " + copies.length + " (" + ints.length + ")");
        int[][] intsToo = new int[][]{{1}, {2, 3}, {4, 5, 6}};
        int[][] copiesToo = (int[][])SystemUtil.clone((Cloneable)intsToo);
        System.out.println("Copies: " + copiesToo.length + " (" + intsToo.length + ")");
        System.out.println("Copies0: " + copiesToo[0].length + " (" + intsToo[0].length + ")");
        System.out.println("Copies1: " + copiesToo[1].length + " (" + intsToo[1].length + ")");
        System.out.println("Copies2: " + copiesToo[2].length + " (" + intsToo[2].length + ")");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String arg : args) {
            map.put(arg, arg);
        }
        Map copy = (Map)SystemUtil.clone(map);
        System.out.println("Map : " + map);
        System.out.println("Copy: " + copy);
        Cloneable cloneable = new Cloneable(){};
        Cloneable clone = (Cloneable)SystemUtil.clone(cloneable);
        System.out.println("cloneable: " + cloneable);
        System.out.println("clone: " + clone);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                return null;
            }
        }, AccessController.getContext());
    }

    private static Class getClass(String pClassName, boolean pInitialize, ClassLoader pLoader) throws ClassNotFoundException {
        ClassLoader loader = pLoader != null ? pLoader : Thread.currentThread().getContextClassLoader();
        return Class.forName(pClassName, pInitialize, loader);
    }

    private static InputStream getFileAsStream(String pName, boolean pGuessSuffix) {
        InputStream is = null;
        try {
            if (!pGuessSuffix) {
                File propertiesFile = new File(pName);
                if (propertiesFile.exists()) {
                    is = new FileInputStream(propertiesFile);
                    if (pName.endsWith(XML_PROPERTIES)) {
                        is = new XMLPropertiesInputStream(is);
                    }
                }
            } else {
                File propertiesFile = new File(pName + STD_PROPERTIES);
                if (propertiesFile.exists()) {
                    is = new FileInputStream(propertiesFile);
                } else {
                    propertiesFile = new File(pName + XML_PROPERTIES);
                    if (propertiesFile.exists()) {
                        is = new XMLPropertiesInputStream(new FileInputStream(propertiesFile));
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return is;
    }

    private static InputStream getResourceAsStream(ClassLoader pClassLoader, String pName, boolean pGuessSuffix) {
        InputStream is;
        if (!pGuessSuffix) {
            is = pClassLoader.getResourceAsStream(pName);
            if (is != null && pName.endsWith(XML_PROPERTIES)) {
                is = new XMLPropertiesInputStream(is);
            }
        } else {
            is = pClassLoader.getResourceAsStream(pName + STD_PROPERTIES);
            if (is == null && (is = pClassLoader.getResourceAsStream(pName + XML_PROPERTIES)) != null) {
                is = new XMLPropertiesInputStream(is);
            }
        }
        return is;
    }

    private static boolean isClassAvailable(String pClassName, ClassLoader pLoader) {
        try {
            SystemUtil.getClass(pClassName, true, pLoader);
            return true;
        }
        catch (SecurityException securityException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return false;
    }

    private static boolean isFieldAvailable(String pClassName, String pFieldName, ClassLoader pLoader) {
        try {
            Class cl = SystemUtil.getClass(pClassName, false, pLoader);
            Field field = cl.getField(pFieldName);
            if (field != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isMethodAvailable(String pClassName, String pMethodName, Class[] pParams, ClassLoader pLoader) {
        try {
            Class cl = SystemUtil.getClass(pClassName, false, pLoader);
            Method method = cl.getMethod(pMethodName, pParams);
            if (method != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private static Properties loadProperties(InputStream pInput) throws IOException {
        if (pInput == null) {
            throw new IllegalArgumentException("InputStream == null!");
        }
        Properties mapping = new Properties();
        mapping.load(pInput);
        return mapping;
    }

    private static class XMLPropertiesInputStream
    extends FilterInputStream {
        public XMLPropertiesInputStream(InputStream pIS) {
            super(pIS);
        }
    }
}

