/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.StringTokenIterator;
import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class StringUtil {
    public static final String DELIMITER_STRING = ", \t\n\r\f";

    private StringUtil() {
    }

    public static String camelToLisp(String pString) {
        if (pString == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (pString.length() == 0) {
            return pString;
        }
        StringBuilder buf = null;
        int lastPos = 0;
        boolean inCharSequence = false;
        boolean inNumberSequence = false;
        for (int i = 1; i < pString.length(); ++i) {
            char previous;
            char current = pString.charAt(i);
            if (Character.isUpperCase(current)) {
                if (buf == null) {
                    buf = new StringBuilder(pString.length() + 3);
                }
                if (inNumberSequence) {
                    inNumberSequence = false;
                    buf.append(pString.substring(lastPos, i));
                    if (current != '-') {
                        buf.append('-');
                    }
                    lastPos = i;
                    continue;
                }
                previous = pString.charAt(i - 1);
                if (i == lastPos || Character.isUpperCase(previous)) {
                    inCharSequence = true;
                    continue;
                }
                buf.append(pString.substring(lastPos, i).toLowerCase());
                if (previous != '-') {
                    buf.append('-');
                }
                buf.append(Character.toLowerCase(current));
                lastPos = i + 1;
                continue;
            }
            if (Character.isDigit(current)) {
                if (buf == null) {
                    buf = new StringBuilder(pString.length() + 3);
                }
                if (inCharSequence) {
                    inCharSequence = false;
                    buf.append(pString.substring(lastPos, i).toLowerCase());
                    if (current != '-') {
                        buf.append('-');
                    }
                    lastPos = i;
                    continue;
                }
                previous = pString.charAt(i - 1);
                if (i == lastPos || Character.isDigit(previous)) {
                    inNumberSequence = true;
                    continue;
                }
                buf.append(pString.substring(lastPos, i).toLowerCase());
                if (previous != '-') {
                    buf.append('-');
                }
                buf.append(Character.toLowerCase(current));
                lastPos = i + 1;
                continue;
            }
            if (inNumberSequence) {
                inNumberSequence = false;
                buf.append(pString.substring(lastPos, i));
                if (current != '-') {
                    buf.append('-');
                }
                lastPos = i;
                continue;
            }
            if (!inCharSequence) continue;
            inCharSequence = false;
            buf.append(pString.substring(lastPos, i - 1).toLowerCase());
            if (current != '-') {
                buf.append('-');
            }
            lastPos = i - 1;
        }
        if (buf != null) {
            buf.append(pString.substring(lastPos).toLowerCase());
            return buf.toString();
        }
        return Character.isUpperCase(pString.charAt(0)) ? pString.toLowerCase() : pString;
    }

    public static String capitalize(String pString) {
        return StringUtil.capitalize(pString, 0);
    }

    public static String capitalize(String pString, int pIndex) {
        if (pIndex < 0) {
            throw new IndexOutOfBoundsException("Negative index not allowed: " + pIndex);
        }
        if (pString == null || pString.length() <= pIndex) {
            return pString;
        }
        if (Character.isUpperCase(pString.charAt(pIndex))) {
            return pString;
        }
        char[] charArray = pString.toCharArray();
        charArray[pIndex] = Character.toUpperCase(charArray[pIndex]);
        return new String(charArray);
    }

    public static boolean contains(String pString, int pChar) {
        return pString != null && pString.indexOf(pChar) >= 0;
    }

    public static boolean contains(String pContainer, String pLookFor) {
        return pContainer != null && pLookFor != null && pContainer.indexOf(pLookFor) >= 0;
    }

    public static boolean containsIgnoreCase(String pString, int pChar) {
        return pString != null && (pString.indexOf(Character.toLowerCase((char)pChar)) >= 0 || pString.indexOf(Character.toUpperCase((char)pChar)) >= 0);
    }

    public static boolean containsIgnoreCase(String pContainer, String pLookFor) {
        return StringUtil.indexOfIgnoreCase(pContainer, pLookFor, 0) >= 0;
    }

    public static String cut(String pString, int pMaxLen, String pPad) {
        int len;
        if (pString == null) {
            return null;
        }
        if (pPad == null) {
            pPad = "";
        }
        if ((len = pString.length()) <= pMaxLen) {
            return pString;
        }
        len = pString.lastIndexOf(32, pMaxLen - pPad.length());
        return pString.substring(0, len) + pPad;
    }

    public static String decode(byte[] pData, int pOffset, int pLength, String pCharset) {
        try {
            return new String(pData, pOffset, pLength, pCharset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedCharsetException(pCharset);
        }
    }

    public static String deepToString(Object pObject) {
        return StringUtil.deepToString(pObject, false, 1);
    }

    public static String deepToString(Object pObject, boolean pForceDeep, int pDepth) {
        if (pObject == null) {
            return null;
        }
        if (!pForceDeep && !StringUtil.isIdentityToString(pObject)) {
            return pObject.toString();
        }
        StringBuilder buffer = new StringBuilder();
        if (pObject.getClass().isArray()) {
            Class<?> componentClass = pObject.getClass();
            while (componentClass.isArray()) {
                buffer.append('[');
                buffer.append(Array.getLength(pObject));
                buffer.append(']');
                componentClass = componentClass.getComponentType();
            }
            buffer.insert(0, componentClass);
            buffer.append(" {hashCode=");
            buffer.append(Integer.toHexString(pObject.hashCode()));
            buffer.append("}");
        } else {
            Method[] methods;
            if (StringUtil.isIdentityToString(pObject)) {
                buffer.append(" {");
            } else {
                buffer.append(" {toString=");
                buffer.append(pObject.toString());
                buffer.append(", ");
            }
            buffer.append("hashCode=");
            buffer.append(Integer.toHexString(pObject.hashCode()));
            for (Method method : methods = pObject.getClass().getMethods()) {
                Class<?>[] paramTypes;
                if (!Modifier.isPublic(method.getModifiers())) continue;
                String methodName = method.getName();
                String name = null;
                if (!methodName.equals("getClass") && methodName.length() > 3 && methodName.startsWith("get") && Character.isUpperCase(methodName.charAt(3))) {
                    name = methodName.substring(3);
                } else if (methodName.length() > 2 && methodName.startsWith("is") && Character.isUpperCase(methodName.charAt(2))) {
                    name = methodName.substring(2);
                }
                if (name == null) continue;
                if (name.length() > 1 && Character.isLowerCase(name.charAt(1))) {
                    name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                }
                boolean hasParams = (paramTypes = method.getParameterTypes()) != null && paramTypes.length > 0;
                boolean isVoid = Void.TYPE.equals(method.getReturnType());
                if (isVoid || hasParams) continue;
                try {
                    Object value = method.invoke(pObject, new Object[0]);
                    buffer.append(", ");
                    buffer.append(name);
                    buffer.append('=');
                    if (pDepth != 0 && value != null && StringUtil.isIdentityToString(value)) {
                        buffer.append(StringUtil.deepToString(value, pForceDeep, pDepth > 0 ? pDepth - 1 : -1));
                        continue;
                    }
                    buffer.append(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            buffer.append('}');
            buffer.insert(0, pObject.getClass().getName());
        }
        return buffer.toString();
    }

    public static String getFirstElement(String pSource, String pDelimiter) {
        if (pDelimiter == null) {
            throw new IllegalArgumentException("delimiter == null");
        }
        if (StringUtil.isEmpty(pSource)) {
            return pSource;
        }
        int idx = pSource.indexOf(pDelimiter);
        if (idx >= 0) {
            return pSource.substring(0, idx);
        }
        return pSource;
    }

    public static String getLastElement(String pSource, String pDelimiter) {
        if (pDelimiter == null) {
            throw new IllegalArgumentException("delimiter == null");
        }
        if (StringUtil.isEmpty(pSource)) {
            return pSource;
        }
        int idx = pSource.lastIndexOf(pDelimiter);
        if (idx >= 0) {
            return pSource.substring(idx + 1);
        }
        return pSource;
    }

    public static String identityToString(Object pObject) {
        if (pObject == null) {
            return null;
        }
        return pObject.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(pObject));
    }

    public static int indexOfIgnoreCase(String pString, int pChar) {
        return StringUtil.indexOfIgnoreCase(pString, pChar, 0);
    }

    public static int indexOfIgnoreCase(String pString, int pChar, int pPos) {
        if (pString == null) {
            return -1;
        }
        char lower = Character.toLowerCase((char)pChar);
        char upper = Character.toUpperCase((char)pChar);
        int indexLower = pString.indexOf(lower, pPos);
        int indexUpper = pString.indexOf(upper, pPos);
        if (indexLower < 0) {
            return indexUpper;
        }
        if (indexUpper < 0) {
            return indexLower;
        }
        return indexLower < indexUpper ? indexLower : indexUpper;
    }

    public static int indexOfIgnoreCase(String pString, String pLookFor) {
        return StringUtil.indexOfIgnoreCase(pString, pLookFor, 0);
    }

    public static int indexOfIgnoreCase(String pString, String pLookFor, int pPos) {
        if (pString == null || pLookFor == null) {
            return -1;
        }
        if (pLookFor.length() == 0) {
            return pPos;
        }
        if (pLookFor.length() > pString.length()) {
            return -1;
        }
        char firstL = Character.toLowerCase(pLookFor.charAt(0));
        char firstU = Character.toUpperCase(pLookFor.charAt(0));
        int indexLower = 0;
        int indexUpper = 0;
        for (int i = pPos; i <= pString.length() - pLookFor.length(); ++i) {
            indexLower = indexLower >= 0 && indexLower <= i ? pString.indexOf(firstL, i) : indexLower;
            int n = indexUpper = indexUpper >= 0 && indexUpper <= i ? pString.indexOf(firstU, i) : indexUpper;
            if (indexLower < 0) {
                if (indexUpper < 0) {
                    return -1;
                }
                i = indexUpper;
            } else if (indexUpper < 0) {
                i = indexLower;
            } else {
                int n2 = i = indexLower < indexUpper ? indexLower : indexUpper;
            }
            if (pLookFor.length() == 1) {
                return i;
            }
            if (i > pString.length() - pLookFor.length()) {
                return -1;
            }
            if (pString.charAt(i + pLookFor.length() - 1) != Character.toLowerCase(pLookFor.charAt(pLookFor.length() - 1)) && pString.charAt(i + pLookFor.length() - 1) != Character.toUpperCase(pLookFor.charAt(pLookFor.length() - 1)) || pLookFor.length() > 2 && !pString.regionMatches(true, i + 1, pLookFor, 1, pLookFor.length() - 2)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isEmpty(String pString) {
        return pString == null || pString.trim().length() == 0;
    }

    public static boolean isEmpty(String[] pStringArray) {
        if (pStringArray == null) {
            return true;
        }
        for (String string : pStringArray) {
            if (StringUtil.isEmpty(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String pString) {
        if (StringUtil.isEmpty(pString)) {
            return false;
        }
        char ch = pString.charAt(0);
        if (ch != '-' && !Character.isDigit(ch)) {
            return false;
        }
        for (int i = 1; i < pString.length(); ++i) {
            if (Character.isDigit(pString.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int lastIndexOfIgnoreCase(String pString, int pChar) {
        return StringUtil.lastIndexOfIgnoreCase(pString, pChar, pString != null ? pString.length() : -1);
    }

    public static int lastIndexOfIgnoreCase(String pString, int pChar, int pPos) {
        if (pString == null) {
            return -1;
        }
        char lower = Character.toLowerCase((char)pChar);
        char upper = Character.toUpperCase((char)pChar);
        int indexLower = pString.lastIndexOf(lower, pPos);
        int indexUpper = pString.lastIndexOf(upper, pPos);
        if (indexLower < 0) {
            return indexUpper;
        }
        if (indexUpper < 0) {
            return indexLower;
        }
        return indexLower > indexUpper ? indexLower : indexUpper;
    }

    public static int lastIndexOfIgnoreCase(String pString, String pLookFor) {
        return StringUtil.lastIndexOfIgnoreCase(pString, pLookFor, pString != null ? pString.length() - 1 : -1);
    }

    public static int lastIndexOfIgnoreCase(String pString, String pLookFor, int pPos) {
        if (pString == null || pLookFor == null) {
            return -1;
        }
        if (pLookFor.length() == 0) {
            return pPos;
        }
        if (pLookFor.length() > pString.length()) {
            return -1;
        }
        char firstL = Character.toLowerCase(pLookFor.charAt(0));
        char firstU = Character.toUpperCase(pLookFor.charAt(0));
        int indexLower = pPos;
        int indexUpper = pPos;
        for (int i = pPos; i >= 0; --i) {
            indexLower = indexLower >= 0 && indexLower >= i ? pString.lastIndexOf(firstL, i) : indexLower;
            int n = indexUpper = indexUpper >= 0 && indexUpper >= i ? pString.lastIndexOf(firstU, i) : indexUpper;
            if (indexLower < 0) {
                if (indexUpper < 0) {
                    return -1;
                }
                i = indexUpper;
            } else if (indexUpper < 0) {
                i = indexLower;
            } else {
                int n2 = i = indexLower > indexUpper ? indexLower : indexUpper;
            }
            if (pLookFor.length() == 1) {
                return i;
            }
            if (i > pString.length() - pLookFor.length() || pString.charAt(i + pLookFor.length() - 1) != Character.toLowerCase(pLookFor.charAt(pLookFor.length() - 1)) && pString.charAt(i + pLookFor.length() - 1) != Character.toUpperCase(pLookFor.charAt(pLookFor.length() - 1)) || pLookFor.length() > 2 && !pString.regionMatches(true, i + 1, pLookFor, 1, pLookFor.length() - 2)) continue;
            return i;
        }
        return -1;
    }

    public static String lispToCamel(String pString) {
        return StringUtil.lispToCamel(pString, false);
    }

    public static String lispToCamel(String pString, boolean pFirstUpperCase) {
        if (pString == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (pString.length() == 0) {
            return pString;
        }
        StringBuilder buf = null;
        int lastPos = 0;
        for (int i = 0; i < pString.length(); ++i) {
            char current = pString.charAt(i);
            if (current != '-') continue;
            if (buf == null) {
                buf = new StringBuilder(pString.length() - 1);
            }
            if (lastPos != 0 || pFirstUpperCase) {
                buf.append(Character.toUpperCase(pString.charAt(lastPos)));
                ++lastPos;
            }
            buf.append(pString.substring(lastPos, i).toLowerCase());
            lastPos = i + 1;
        }
        if (buf != null) {
            buf.append(Character.toUpperCase(pString.charAt(lastPos)));
            buf.append(pString.substring(lastPos + 1).toLowerCase());
            return buf.toString();
        }
        if (pFirstUpperCase && !Character.isUpperCase(pString.charAt(0))) {
            return StringUtil.capitalize(pString, 0);
        }
        if (!pFirstUpperCase && Character.isUpperCase(pString.charAt(0))) {
            return Character.toLowerCase(pString.charAt(0)) + pString.substring(1);
        }
        return pString;
    }

    public static String ltrim(String pString) {
        if (pString == null || pString.length() == 0) {
            return pString;
        }
        for (int i = 0; i < pString.length(); ++i) {
            if (Character.isWhitespace(pString.charAt(i))) continue;
            if (i == 0) {
                return pString;
            }
            return pString.substring(i);
        }
        return "";
    }

    public static String pad(String pSource, int pRequiredLength, String pPadString, boolean pPrepend) {
        if (pPadString == null || pPadString.length() == 0) {
            throw new IllegalArgumentException("Pad string: \"" + pPadString + "\"");
        }
        if (pSource.length() >= pRequiredLength) {
            return pSource;
        }
        int gap = pRequiredLength - pSource.length();
        StringBuilder result = new StringBuilder(pPadString);
        while (result.length() < gap) {
            result.append((CharSequence)result);
        }
        if (result.length() > gap) {
            result.delete(gap, result.length());
        }
        return pPrepend ? result.append(pSource).toString() : result.insert(0, pSource).toString();
    }

    public static String replace(String pSource, String pPattern, String pReplace) {
        int match;
        if (pPattern.length() == 0) {
            return pSource;
        }
        int offset = 0;
        StringBuilder result = new StringBuilder();
        while ((match = pSource.indexOf(pPattern, offset)) != -1) {
            result.append(pSource.substring(offset, match));
            result.append(pReplace);
            offset = match + pPattern.length();
        }
        result.append(pSource.substring(offset));
        return result.toString();
    }

    public static String replaceIgnoreCase(String pSource, String pPattern, String pReplace) {
        int match;
        if (pPattern.length() == 0) {
            return pSource;
        }
        int offset = 0;
        StringBuilder result = new StringBuilder();
        while ((match = StringUtil.indexOfIgnoreCase(pSource, pPattern, offset)) != -1) {
            result.append(pSource.substring(offset, match));
            result.append(pReplace);
            offset = match + pPattern.length();
        }
        result.append(pSource.substring(offset));
        return result.toString();
    }

    public static String reverse(String pString) {
        char[] chars = new char[pString.length()];
        pString.getChars(0, chars.length, chars, 0);
        for (int i = 0; i < chars.length / 2; ++i) {
            char temp = chars[i];
            chars[i] = chars[chars.length - 1 - i];
            chars[chars.length - 1 - i] = temp;
        }
        return new String(chars);
    }

    public static String rtrim(String pString) {
        if (pString == null || pString.length() == 0) {
            return pString;
        }
        for (int i = pString.length(); i > 0; --i) {
            if (Character.isWhitespace(pString.charAt(i - 1))) continue;
            if (i == pString.length()) {
                return pString;
            }
            return pString.substring(0, i);
        }
        return "";
    }

    public static String substring(String pSource, String pBeginBoundaryString, String pEndBoundaryString, int pOffset) {
        int offset = pOffset < 0 ? 0 : pOffset;
        int startIndex = pSource.indexOf(pBeginBoundaryString, offset) + pBeginBoundaryString.length();
        if (startIndex < 0) {
            return null;
        }
        int endIndex = pSource.indexOf(pEndBoundaryString, startIndex);
        if (endIndex < 0) {
            return null;
        }
        return pSource.substring(startIndex, endIndex);
    }

    public static Color toColor(String pString) {
        if (pString == null) {
            return null;
        }
        if (pString.charAt(0) == '#') {
            int r = 0;
            int g = 0;
            int b = 0;
            int a = -1;
            if (pString.length() >= 7) {
                int idx = 1;
                if (pString.length() >= 9) {
                    a = Integer.parseInt(pString.substring(idx, idx + 2), 16);
                    idx += 2;
                }
                r = Integer.parseInt(pString.substring(idx, idx + 2), 16);
                g = Integer.parseInt(pString.substring(idx + 2, idx + 4), 16);
                b = Integer.parseInt(pString.substring(idx + 4, idx + 6), 16);
            } else if (pString.length() >= 4) {
                int idx = 1;
                if (pString.length() >= 5) {
                    a = Integer.parseInt(pString.substring(idx++, idx), 16) * 16;
                }
                r = Integer.parseInt(pString.substring(idx++, idx), 16) * 16;
                g = Integer.parseInt(pString.substring(idx++, idx), 16) * 16;
                b = Integer.parseInt(pString.substring(idx++, idx), 16) * 16;
            }
            if (a != -1) {
                return new Color(r, g, b, a);
            }
            return new Color(r, g, b);
        }
        try {
            int mod;
            Class<Color> colorClass = Color.class;
            Field field = null;
            try {
                field = colorClass.getField(pString);
            }
            catch (Exception b) {
                // empty catch block
            }
            if (field == null) {
                field = colorClass.getField(pString.toLowerCase());
            }
            if (Modifier.isPublic(mod = field.getModifiers()) && Modifier.isStatic(mod)) {
                return (Color)field.get(null);
            }
        }
        catch (NoSuchFieldException nsfe) {
            throw new IllegalArgumentException("No such color: " + pString);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static String toColorString(Color pColor) {
        if (pColor == null) {
            return null;
        }
        StringBuilder str = new StringBuilder(Integer.toHexString(pColor.getRGB()));
        for (int i = str.length(); i < 8; ++i) {
            str.insert(0, '0');
        }
        if (str.charAt(0) == 'f' && str.charAt(1) == 'f') {
            str.delete(0, 2);
        }
        return str.insert(0, '#').toString();
    }

    public static String toCSVString(Object[] pStringArray) {
        return StringUtil.toCSVString(pStringArray, ", ");
    }

    public static String toCSVString(Object[] pStringArray, String pDelimiterString) {
        if (pStringArray == null) {
            return "";
        }
        if (pDelimiterString == null) {
            throw new IllegalArgumentException("delimiter == null");
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < pStringArray.length; ++i) {
            if (i > 0) {
                buffer.append(pDelimiterString);
            }
            buffer.append(pStringArray[i]);
        }
        return buffer.toString();
    }

    public static Date toDate(String pString) {
        return StringUtil.toDate(pString, DateFormat.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date toDate(String pString, DateFormat pFormat) {
        try {
            DateFormat dateFormat = pFormat;
            synchronized (dateFormat) {
                return pFormat.parse(pString);
            }
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public static Date toDate(String pString, String pFormat) {
        return StringUtil.toDate(pString, new SimpleDateFormat(pFormat));
    }

    public static double[] toDoubleArray(String pString) {
        return StringUtil.toDoubleArray(pString, DELIMITER_STRING);
    }

    public static double[] toDoubleArray(String pString, String pDelimiters) {
        if (StringUtil.isEmpty(pString)) {
            return new double[0];
        }
        String[] temp = StringUtil.toStringArray(pString, pDelimiters);
        double[] array = new double[temp.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Double.valueOf(temp[i]);
        }
        return array;
    }

    public static int[] toIntArray(String pString) {
        return StringUtil.toIntArray(pString, DELIMITER_STRING, 10);
    }

    public static int[] toIntArray(String pString, String pDelimiters) {
        return StringUtil.toIntArray(pString, pDelimiters, 10);
    }

    public static int[] toIntArray(String pString, String pDelimiters, int pBase) {
        if (StringUtil.isEmpty(pString)) {
            return new int[0];
        }
        String[] temp = StringUtil.toStringArray(pString, pDelimiters);
        int[] array = new int[temp.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Integer.parseInt(temp[i], pBase);
        }
        return array;
    }

    public static long[] toLongArray(String pString) {
        return StringUtil.toLongArray(pString, DELIMITER_STRING);
    }

    public static long[] toLongArray(String pString, String pDelimiters) {
        if (StringUtil.isEmpty(pString)) {
            return new long[0];
        }
        String[] temp = StringUtil.toStringArray(pString, pDelimiters);
        long[] array = new long[temp.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Long.parseLong(temp[i]);
        }
        return array;
    }

    public static String toLowerCase(String pString) {
        if (pString != null) {
            return pString.toLowerCase();
        }
        return null;
    }

    public static String[] toStringArray(String pString) {
        return StringUtil.toStringArray(pString, DELIMITER_STRING);
    }

    public static String[] toStringArray(String pString, String pDelimiters) {
        if (StringUtil.isEmpty(pString)) {
            return new String[0];
        }
        StringTokenIterator st = new StringTokenIterator(pString, pDelimiters);
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreElements()) {
            v.add(st.nextToken());
        }
        return v.toArray(new String[v.size()]);
    }

    public static Timestamp toTimestamp(String pValue) {
        return Timestamp.valueOf(pValue);
    }

    public static String toUpperCase(String pString) {
        if (pString != null) {
            return pString.toUpperCase();
        }
        return null;
    }

    public static String valueOf(Object pObj) {
        return pObj != null ? pObj.toString() : null;
    }

    static String ensureExcludesAt(String pSource, String pSubstring, int pPosition) {
        StringBuilder newString = new StringBuilder(pSource);
        try {
            String existingString = pSource.substring(pPosition + 1, pPosition + pSubstring.length() + 1);
            if (!existingString.equalsIgnoreCase(pSubstring)) {
                newString.delete(pPosition, pPosition + pSubstring.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newString.toString();
    }

    static String ensureIncludesAt(String pSource, String pSubstring, int pPosition) {
        StringBuilder newString = new StringBuilder(pSource);
        try {
            String existingSubstring = pSource.substring(pPosition, pPosition + pSubstring.length());
            if (!existingSubstring.equalsIgnoreCase(pSubstring)) {
                newString.insert(pPosition, pSubstring);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newString.toString();
    }

    @Deprecated
    static String formatNumber(long pNum, int pLen) throws IllegalArgumentException {
        StringBuilder result = new StringBuilder();
        if ((double)pNum >= Math.pow(10.0, pLen)) {
            throw new IllegalArgumentException("The number to format cannot contain more digits than the length argument specifies!");
        }
        for (int i = pLen; i > 1 && (double)pNum < Math.pow(10.0, i - 1); --i) {
            result.append('0');
        }
        result.append(pNum);
        return result.toString();
    }

    @Deprecated
    static String removeSubstring(String pSource, char pBeginBoundaryChar, char pEndBoundaryChar, int pOffset) {
        char[] charArray;
        StringBuilder filteredString = new StringBuilder();
        boolean insideDemarcatedArea = false;
        for (char c : charArray = pSource.toCharArray()) {
            if (!insideDemarcatedArea) {
                if (c == pBeginBoundaryChar) {
                    insideDemarcatedArea = true;
                    continue;
                }
                filteredString.append(c);
                continue;
            }
            if (c != pEndBoundaryChar) continue;
            insideDemarcatedArea = false;
        }
        return filteredString.toString();
    }

    static String removeSubstrings(String pSource, char pBeginBoundaryChar, char pEndBoundaryChar) {
        char[] charArray;
        StringBuilder filteredString = new StringBuilder();
        boolean insideDemarcatedArea = false;
        for (char c : charArray = pSource.toCharArray()) {
            if (!insideDemarcatedArea) {
                if (c == pBeginBoundaryChar) {
                    insideDemarcatedArea = true;
                    continue;
                }
                filteredString.append(c);
                continue;
            }
            if (c != pEndBoundaryChar) continue;
            insideDemarcatedArea = false;
        }
        return filteredString.toString();
    }

    private static boolean isIdentityToString(Object pObject) {
        try {
            Method toString = pObject.getClass().getMethod("toString", new Class[0]);
            if (toString.getDeclaringClass() == Object.class) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean matches(String pString, String pRegex) throws PatternSyntaxException {
        return Pattern.matches(pRegex, pString);
    }

    public String replaceAll(String pString, String pRegex, String pReplacement) {
        return Pattern.compile(pRegex).matcher(pString).replaceAll(pReplacement);
    }

    public String replaceFirst(String pString, String pRegex, String pReplacement) {
        return Pattern.compile(pRegex).matcher(pString).replaceFirst(pReplacement);
    }

    public String[] split(String pString, String pRegex) {
        return this.split(pString, pRegex, 0);
    }

    public String[] split(String pString, String pRegex, int pLimit) {
        return Pattern.compile(pRegex).split(pString, pLimit);
    }
}

