/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.Validate;

public class ProviderInfo {
    private final String title;
    private final String vendorName;
    private final String version;

    public ProviderInfo(Package pPackage) {
        Validate.notNull(pPackage, "package");
        String title = pPackage.getImplementationTitle();
        this.title = title != null ? title : pPackage.getName();
        String vendor = pPackage.getImplementationVendor();
        this.vendorName = vendor != null ? vendor : ProviderInfo.fakeVendor(pPackage);
        String version = pPackage.getImplementationVersion();
        this.version = version != null ? version : this.fakeVersion(pPackage);
    }

    private static String fakeVendor(Package pPackage) {
        String name = pPackage.getName();
        return name.startsWith("com.twelvemonkeys") ? "TwelveMonkeys" : name;
    }

    private String fakeVersion(Package pPackage) {
        String name = pPackage.getName();
        return name.startsWith("com.twelvemonkeys") ? "DEV" : "Unspecified";
    }

    final String getImplementationTitle() {
        return this.title;
    }

    public final String getVendorName() {
        return this.vendorName;
    }

    public final String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.title + ", " + this.version + " by " + this.vendorName;
    }
}

