/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import java.util.Properties;

public final class Platform {
    final OperatingSystem os;
    final String version;
    final Architecture architecture;
    private static final Platform INSTANCE = new Platform();

    private Platform() {
        this(System.getProperties());
    }

    Platform(Properties properties) {
        this.os = Platform.normalizeOperatingSystem(properties.getProperty("os.name"));
        this.version = properties.getProperty("os.version");
        this.architecture = Platform.normalizeArchitecture(this.os, properties.getProperty("os.arch"));
    }

    static OperatingSystem normalizeOperatingSystem(String osName) {
        String os = osName;
        if (os == null) {
            throw new IllegalStateException("System property \"os.name\" == null");
        }
        if ((os = os.toLowerCase()).startsWith("windows")) {
            return OperatingSystem.Windows;
        }
        if (os.startsWith("linux")) {
            return OperatingSystem.Linux;
        }
        if (os.startsWith("mac os") || os.startsWith("darwin")) {
            return OperatingSystem.MacOS;
        }
        if (os.startsWith("solaris") || os.startsWith("sunos")) {
            return OperatingSystem.Solaris;
        }
        return OperatingSystem.Unknown;
    }

    static Architecture normalizeArchitecture(OperatingSystem pOsName, String osArch) {
        String arch = osArch;
        if (arch == null) {
            throw new IllegalStateException("System property \"os.arch\" == null");
        }
        arch = arch.toLowerCase();
        if (pOsName == OperatingSystem.Windows && (arch.startsWith("x86") || arch.startsWith("i386"))) {
            return Architecture.X86;
        }
        if (pOsName == OperatingSystem.Linux) {
            if (arch.startsWith("x86") || arch.startsWith("i386")) {
                return Architecture.I386;
            }
            if (arch.startsWith("i686")) {
                return Architecture.I686;
            }
            if (arch.startsWith("power") || arch.startsWith("ppc")) {
                return Architecture.PPC;
            }
        } else if (pOsName == OperatingSystem.MacOS) {
            if (arch.startsWith("power") || arch.startsWith("ppc")) {
                return Architecture.PPC;
            }
            if (arch.startsWith("x86")) {
                return Architecture.X86;
            }
            if (arch.startsWith("i386")) {
                return Architecture.X86;
            }
        } else if (pOsName == OperatingSystem.Solaris) {
            if (arch.startsWith("sparc")) {
                return Architecture.SPARC;
            }
            if (arch.startsWith("x86")) {
                return Architecture.X86;
            }
        }
        return Architecture.Unknown;
    }

    public static Platform get() {
        return INSTANCE;
    }

    public OperatingSystem getOS() {
        return this.os;
    }

    public String getVersion() {
        return this.version;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public static OperatingSystem os() {
        return Platform.INSTANCE.os;
    }

    public static String version() {
        return Platform.INSTANCE.version;
    }

    public static Architecture arch() {
        return Platform.INSTANCE.architecture;
    }

    public static enum OperatingSystem {
        Windows("Windows", "win"),
        Linux("Linux", "lnx"),
        Solaris("Solaris", "sun"),
        MacOS("Mac OS", "osx"),
        Unknown(System.getProperty("os.name"), null);

        final String id;
        final String name;

        private OperatingSystem(String pName, String pId) {
            this.name = pName;
            this.id = pId != null ? pId : pName.toLowerCase();
        }

        public String getName() {
            return this.name;
        }

        public String id() {
            return this.id;
        }

        public String toString() {
            return String.format("%s (%s)", this.id, this.name);
        }
    }

    public static enum Architecture {
        X86("x86"),
        I386("i386"),
        I686("i686"),
        PPC("ppc"),
        SPARC("sparc"),
        Unknown(System.getProperty("os.arch"));

        final String name;

        private Architecture(String pName) {
            this.name = pName;
        }

        public String toString() {
            return this.name;
        }
    }
}

