/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.ByteArrayImageInputStream;
import com.alkacon.simapi.CmykJpegReader.Directory;
import com.alkacon.simapi.CmykJpegReader.EXIFReader;
import com.alkacon.simapi.CmykJpegReader.JPEGSegment;
import com.alkacon.simapi.CmykJpegReader.PSDReader;
import com.alkacon.simapi.CmykJpegReader.Validate;
import com.alkacon.simapi.CmykJpegReader.XMPReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

public final class JPEGSegmentUtil {
    public static final List<String> ALL_IDS = Collections.unmodifiableList(new AllIdsList());
    public static final Map<Integer, List<String>> ALL_SEGMENTS = Collections.unmodifiableMap(new AllSegmentsMap());
    public static final Map<Integer, List<String>> APP_SEGMENTS = Collections.unmodifiableMap(new AllAppSegmentsMap());

    private JPEGSegmentUtil() {
    }

    public static List<JPEGSegment> readSegments(ImageInputStream stream, int marker, String identifier) throws IOException {
        return JPEGSegmentUtil.readSegments(stream, Collections.singletonMap(marker, identifier != null ? Collections.singletonList(identifier) : ALL_IDS));
    }

    public static List<JPEGSegment> readSegments(ImageInputStream stream, Map<Integer, List<String>> segmentIdentifiers) throws IOException {
        JPEGSegmentUtil.readSOI(Validate.notNull(stream, "stream"));
        List<JPEGSegment> segments = Collections.emptyList();
        try {
            JPEGSegment segment;
            do {
                if (!JPEGSegmentUtil.isRequested(segment = JPEGSegmentUtil.readSegment(stream, segmentIdentifiers), segmentIdentifiers)) continue;
                if (segments == Collections.EMPTY_LIST) {
                    segments = new ArrayList<JPEGSegment>();
                }
                segments.add(segment);
            } while (!JPEGSegmentUtil.isImageDone(segment));
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return segments;
    }

    private static boolean isRequested(JPEGSegment segment, Map<Integer, List<String>> segmentIdentifiers) {
        return segmentIdentifiers.containsKey(segment.marker) && (segment.identifier() == null && segmentIdentifiers.get(segment.marker) == null || JPEGSegmentUtil.containsSafe(segment, segmentIdentifiers));
    }

    private static boolean containsSafe(JPEGSegment segment, Map<Integer, List<String>> segmentIdentifiers) {
        List<String> identifiers = segmentIdentifiers.get(segment.marker);
        return identifiers != null && identifiers.contains(segment.identifier());
    }

    private static boolean isImageDone(JPEGSegment segment) {
        return segment.marker == 65498 || segment.marker == 65497 || segment.marker == 65496;
    }

    static String asNullTerminatedAsciiString(byte[] data, int offset) {
        for (int i = 0; i < data.length - offset; ++i) {
            if (data[offset + i] != 0 && i <= 255) continue;
            return JPEGSegmentUtil.asAsciiString(data, offset, offset + i);
        }
        return null;
    }

    static String asAsciiString(byte[] data, int offset, int length) {
        return new String(data, offset, length, Charset.forName("ascii"));
    }

    static void readSOI(ImageInputStream stream) throws IOException {
        if (stream.readUnsignedShort() != 65496) {
            throw new IIOException("Not a JPEG stream");
        }
    }

    static JPEGSegment readSegment(ImageInputStream stream, Map<Integer, List<String>> segmentIdentifiers) throws IOException {
        byte[] data;
        int marker = stream.readUnsignedShort();
        int bad = 0;
        while (marker == 0) {
            marker = stream.readUnsignedShort();
            bad += 2;
        }
        if (marker == 255) {
            ++bad;
            marker = 0xFF00 | stream.readUnsignedByte();
        }
        if (bad != 0) {
            // empty if block
        }
        while (marker == 65535) {
            marker = 0xFF00 | stream.readUnsignedByte();
        }
        if ((marker >> 8 & 0xFF) != 255) {
            throw new IIOException(String.format("Bad marker: %04x", marker));
        }
        int length = stream.readUnsignedShort();
        if (segmentIdentifiers.containsKey(marker)) {
            data = new byte[length - 2];
            stream.readFully(data);
        } else if (JPEGSegment.isAppSegmentMarker(marker)) {
            int read;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(32);
            while ((read = stream.read()) > 0) {
                buffer.write(read);
            }
            data = buffer.toByteArray();
            stream.skipBytes(length - 3 - data.length);
        } else {
            data = null;
            stream.skipBytes(length - 2);
        }
        return new JPEGSegment(marker, data, length);
    }

    public static void main(String[] args) throws IOException {
        for (String arg : args) {
            if (args.length > 1) {
                System.out.println("File: " + arg);
                System.out.println("------");
            }
            List<JPEGSegment> segments = JPEGSegmentUtil.readSegments(ImageIO.createImageInputStream(new File(arg)), ALL_SEGMENTS);
            for (JPEGSegment segment : segments) {
                ByteArrayImageInputStream stream;
                System.err.println("segment: " + segment);
                if ("Exif".equals(segment.identifier())) {
                    stream = new ByteArrayImageInputStream(segment.data, segment.offset() + 1, segment.length() - 1);
                    Directory tiff = new EXIFReader().read(stream);
                    System.err.println("EXIF: " + tiff);
                    continue;
                }
                if ("http://ns.adobe.com/xap/1.0/".equals(segment.identifier())) {
                    Directory xmp = new XMPReader().read(new ByteArrayImageInputStream(segment.data, segment.offset(), segment.length()));
                    System.err.println("XMP: " + xmp);
                    System.err.println(EXIFReader.HexDump.dump(segment.data));
                    continue;
                }
                if ("Photoshop 3.0".equals(segment.identifier())) {
                    stream = new ByteArrayImageInputStream(segment.data, segment.offset(), segment.length());
                    Directory psd = new PSDReader().read(stream);
                    System.err.println("PSD: " + psd);
                    System.err.println(EXIFReader.HexDump.dump(segment.data));
                    continue;
                }
                if ("ICC_PROFILE".equals(segment.identifier())) continue;
                System.err.println(EXIFReader.HexDump.dump(segment.data));
            }
            if (args.length <= 1) continue;
            System.out.println("------");
            System.out.println();
        }
    }

    private static class AllAppSegmentsMap
    extends HashMap<Integer, List<String>> {
        private AllAppSegmentsMap() {
        }

        @Override
        public String toString() {
            return "{All APPn segments}";
        }

        @Override
        public List<String> get(Object key) {
            return this.containsKey(key) ? ALL_IDS : null;
        }

        @Override
        public boolean containsKey(Object key) {
            return key instanceof Integer && JPEGSegment.isAppSegmentMarker((Integer)key);
        }
    }

    private static class AllSegmentsMap
    extends HashMap<Integer, List<String>> {
        private AllSegmentsMap() {
        }

        @Override
        public String toString() {
            return "{All segments}";
        }

        @Override
        public List<String> get(Object key) {
            return key instanceof Integer && JPEGSegment.isAppSegmentMarker((Integer)key) ? ALL_IDS : null;
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }
    }

    private static class AllIdsList
    extends ArrayList<String> {
        private AllIdsList() {
        }

        @Override
        public String toString() {
            return "[All ids]";
        }

        @Override
        public boolean contains(Object o) {
            return true;
        }
    }
}

