/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.Validate;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

final class JPEGSegmentImageInputStream
extends ImageInputStreamImpl {
    private final ImageInputStream stream;
    private final List<Segment> segments = new ArrayList<Segment>(64);
    private int currentSegment = -1;
    private Segment segment;

    JPEGSegmentImageInputStream(ImageInputStream stream) {
        this.stream = Validate.notNull(stream, "stream");
    }

    private Segment fetchSegment() throws IOException {
        block15: {
            if (this.currentSegment == -1) {
                this.streamInit();
            } else {
                this.segment = this.segments.get(this.currentSegment);
            }
            if (this.streamPos >= this.segment.end()) {
                while (++this.currentSegment < this.segments.size()) {
                    this.segment = this.segments.get(this.currentSegment);
                    if (this.streamPos < this.segment.start || this.streamPos >= this.segment.end()) continue;
                    this.stream.seek(this.segment.realStart + this.streamPos - this.segment.start);
                    return this.segment;
                }
                this.stream.seek(this.segment.realEnd());
                while (true) {
                    long realPosition = this.stream.getStreamPosition();
                    int marker = this.stream.readUnsignedShort();
                    int trash = 0;
                    while (marker == 0) {
                        marker = this.stream.readUnsignedShort();
                        trash += 2;
                    }
                    if (marker == 255) {
                        ++trash;
                        marker = 0xFF00 | this.stream.readUnsignedByte();
                    }
                    while (marker == 65535) {
                        ++realPosition;
                        marker = 0xFF00 | this.stream.readUnsignedByte();
                    }
                    if (JPEGSegmentImageInputStream.isAppSegmentMarker(marker) && (marker != 65505 || !JPEGSegmentImageInputStream.isAppSegmentWithId("Exif", this.stream)) && marker != 65518) {
                        int length = this.stream.readUnsignedShort();
                        this.stream.seek(realPosition + (long)trash + 2L + (long)length);
                        continue;
                    }
                    if (marker == 65497) {
                        this.segment = new Segment(marker, realPosition, this.segment.end(), 2L);
                        this.segments.add(this.segment);
                    } else {
                        long length = marker == 65498 ? Long.MAX_VALUE - realPosition : (long)(trash + this.stream.readUnsignedShort() + 2);
                        this.segment = new Segment(marker, realPosition, this.segment.end(), length);
                        this.segments.add(this.segment);
                    }
                    this.currentSegment = this.segments.size() - 1;
                    if (this.streamPos >= this.segment.start && this.streamPos < this.segment.end()) {
                        this.stream.seek(this.segment.realStart + this.streamPos - this.segment.start);
                        break block15;
                    }
                    this.stream.seek(this.segment.realEnd());
                }
            }
            if (this.streamPos < this.segment.start) {
                while (--this.currentSegment >= 0) {
                    this.segment = this.segments.get(this.currentSegment);
                    if (this.streamPos < this.segment.start || this.streamPos >= this.segment.end()) continue;
                    this.stream.seek(this.segment.realStart + this.streamPos - this.segment.start);
                    break;
                }
            } else {
                this.stream.seek(this.segment.realStart + this.streamPos - this.segment.start);
            }
        }
        return this.segment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isAppSegmentWithId(String segmentId, ImageInputStream stream) throws IOException {
        Validate.notNull(segmentId, "segmentId");
        stream.mark();
        try {
            int length = stream.readUnsignedShort();
            byte[] data = new byte[Math.max(20, length - 2)];
            stream.readFully(data);
            boolean bl = segmentId.equals(JPEGSegmentImageInputStream.asNullTerminatedAsciiString(data, 0));
            return bl;
        }
        finally {
            stream.reset();
        }
    }

    static String asNullTerminatedAsciiString(byte[] data, int offset) {
        for (int i = 0; i < data.length - offset; ++i) {
            if (data[offset + i] != 0 && i <= 255) continue;
            return JPEGSegmentImageInputStream.asAsciiString(data, offset, offset + i);
        }
        return null;
    }

    static String asAsciiString(byte[] data, int offset, int length) {
        return new String(data, offset, length, Charset.forName("ascii"));
    }

    private void streamInit() throws IOException {
        this.stream.seek(0L);
        int soi = this.stream.readUnsignedShort();
        if (soi != 65496) {
            throw new IIOException(String.format("Not a JPEG stream (starts with: 0x%04x, expected SOI: 0x%04x)", soi, 65496));
        }
        this.segment = new Segment(soi, 0L, 0L, 2L);
        this.segments.add(this.segment);
        this.currentSegment = this.segments.size() - 1;
    }

    static boolean isAppSegmentMarker(int marker) {
        return marker >= 65504 && marker <= 65519;
    }

    private void repositionAsNecessary() throws IOException {
        if (this.segment == null || this.streamPos < this.segment.start || this.streamPos >= this.segment.end()) {
            this.fetchSegment();
        }
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        this.repositionAsNecessary();
        int read = this.stream.read();
        if (read != -1) {
            ++this.streamPos;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int total;
        int count;
        this.bitOffset = 0;
        for (total = 0; total < len; total += count) {
            this.repositionAsNecessary();
            count = this.stream.read(b, off + total, (int)Math.min((long)(len - total), this.segment.end() - this.streamPos));
            if (count == -1) {
                if (total != 0) break;
                return -1;
            }
            this.streamPos += (long)count;
        }
        return total;
    }

    @Override
    protected void finalize() throws Throwable {
    }

    static class Segment {
        private final int marker;
        final long realStart;
        final long start;
        final long length;

        Segment(int marker, long realStart, long start, long length) {
            this.marker = marker;
            this.realStart = realStart;
            this.start = start;
            this.length = length;
        }

        long realEnd() {
            return this.realStart + this.length;
        }

        long end() {
            return this.start + this.length;
        }

        public String toString() {
            return String.format("0x%04x[%d-%d]", this.marker, this.realStart, this.realEnd());
        }
    }
}

