/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.JPEGSegmentUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;

public final class JPEGSegment
implements Serializable {
    final int marker;
    final byte[] data;
    final int length;
    private transient String id;

    JPEGSegment(int marker, byte[] data, int length) {
        this.marker = marker;
        this.data = data;
        this.length = length;
    }

    int segmentLength() {
        return this.length;
    }

    public int marker() {
        return this.marker;
    }

    public String identifier() {
        if (this.id == null && JPEGSegment.isAppSegmentMarker(this.marker)) {
            this.id = JPEGSegmentUtil.asNullTerminatedAsciiString(this.data, 0);
        }
        return this.id;
    }

    static boolean isAppSegmentMarker(int marker) {
        return marker >= 65504 && marker <= 65519;
    }

    public InputStream data() {
        return this.data != null ? new ByteArrayInputStream(this.data, this.offset(), this.length()) : null;
    }

    public int length() {
        return this.data != null ? this.data.length - this.offset() : 0;
    }

    int offset() {
        String identifier = this.identifier();
        return identifier == null ? 0 : identifier.length() + 1;
    }

    public String toString() {
        String identifier = this.identifier();
        if (identifier != null) {
            return String.format("JPEGSegment[%04x/%s size: %d]", this.marker, identifier, this.segmentLength());
        }
        return String.format("JPEGSegment[%04x size: %d]", this.marker, this.segmentLength());
    }

    public int hashCode() {
        String identifier = this.identifier();
        return this.marker() << 16 | (identifier != null ? identifier.hashCode() : 0) & 0xFFFF;
    }

    public boolean equals(Object other) {
        return other instanceof JPEGSegment && ((JPEGSegment)other).marker == this.marker && Arrays.equals(((JPEGSegment)other).data, this.data);
    }
}

