/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.AdobeDCTSegment;
import com.alkacon.simapi.CmykJpegReader.ColorSpaces;
import com.alkacon.simapi.CmykJpegReader.CompoundDirectory;
import com.alkacon.simapi.CmykJpegReader.Directory;
import com.alkacon.simapi.CmykJpegReader.EXIFReader;
import com.alkacon.simapi.CmykJpegReader.EXIFThumbnailReader;
import com.alkacon.simapi.CmykJpegReader.Entry;
import com.alkacon.simapi.CmykJpegReader.FastCMYKToRGB;
import com.alkacon.simapi.CmykJpegReader.ImageReaderBase;
import com.alkacon.simapi.CmykJpegReader.ImageUtil;
import com.alkacon.simapi.CmykJpegReader.JFIFSegment;
import com.alkacon.simapi.CmykJpegReader.JFIFThumbnailReader;
import com.alkacon.simapi.CmykJpegReader.JFXXSegment;
import com.alkacon.simapi.CmykJpegReader.JFXXThumbnailReader;
import com.alkacon.simapi.CmykJpegReader.JPEGColorSpace;
import com.alkacon.simapi.CmykJpegReader.JPEGImage10MetadataCleaner;
import com.alkacon.simapi.CmykJpegReader.JPEGSegment;
import com.alkacon.simapi.CmykJpegReader.JPEGSegmentImageInputStream;
import com.alkacon.simapi.CmykJpegReader.JPEGSegmentUtil;
import com.alkacon.simapi.CmykJpegReader.ProgressListenerBase;
import com.alkacon.simapi.CmykJpegReader.SOFComponent;
import com.alkacon.simapi.CmykJpegReader.SOFSegment;
import com.alkacon.simapi.CmykJpegReader.ThumbnailReadProgressListener;
import com.alkacon.simapi.CmykJpegReader.ThumbnailReader;
import com.alkacon.simapi.CmykJpegReader.Validate;
import com.alkacon.simapi.CmykJpegReader.XMLSerializer;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class JPEGImageReader
extends ImageReaderBase {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.plugins.jpeg.debug"));
    static final int ALL_APP_MARKERS = -1;
    private static final Map<Integer, List<String>> SEGMENT_IDENTIFIERS = JPEGImageReader.createSegmentIds();
    private final ImageReader delegate;
    private final ProgressDelegator progressDelegator;
    private ImageReader thumbnailReader;
    private List<ThumbnailReader> thumbnails;
    private JPEGImage10MetadataCleaner metadataCleaner;
    private List<JPEGSegment> segments;

    private static Map<Integer, List<String>> createSegmentIds() {
        LinkedHashMap<Integer, List<String>> map = new LinkedHashMap<Integer, List<String>>();
        for (int appMarker = 65504; appMarker <= 65519; ++appMarker) {
            map.put(appMarker, JPEGSegmentUtil.ALL_IDS);
        }
        map.put(65472, null);
        map.put(65473, null);
        map.put(65474, null);
        map.put(65475, null);
        map.put(65477, null);
        map.put(65478, null);
        map.put(65479, null);
        map.put(65481, null);
        map.put(65482, null);
        map.put(65483, null);
        map.put(65485, null);
        map.put(65486, null);
        map.put(65487, null);
        return Collections.unmodifiableMap(map);
    }

    JPEGImageReader(ImageReaderSpi provider, ImageReader delegate) {
        super(provider);
        this.delegate = Validate.notNull(delegate);
        this.progressDelegator = new ProgressDelegator();
    }

    private void installListeners() {
        this.delegate.addIIOReadProgressListener(this.progressDelegator);
        this.delegate.addIIOReadUpdateListener(this.progressDelegator);
        this.delegate.addIIOReadWarningListener(this.progressDelegator);
    }

    @Override
    protected void resetMembers() {
        this.delegate.reset();
        this.segments = null;
        this.thumbnails = null;
        if (this.thumbnailReader != null) {
            this.thumbnailReader.reset();
        }
        this.metadataCleaner = null;
        this.installListeners();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.thumbnailReader != null) {
            this.thumbnailReader.dispose();
            this.thumbnailReader = null;
        }
        this.delegate.dispose();
    }

    @Override
    public String getFormatName() throws IOException {
        return this.delegate.getFormatName();
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return this.delegate.getNumImages(allowSearch);
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        return this.delegate.getWidth(imageIndex);
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        return this.delegate.getHeight(imageIndex);
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        Iterator<ImageTypeSpecifier> types = this.delegate.getImageTypes(imageIndex);
        JPEGColorSpace csType = JPEGImageReader.getSourceCSType(this.getJFIF(), this.getAdobeDCT(), this.getSOF());
        if (types == null || !types.hasNext() || csType == JPEGColorSpace.CMYK || csType == JPEGColorSpace.YCCK) {
            ArrayList<ImageTypeSpecifier> typeList = new ArrayList<ImageTypeSpecifier>();
            typeList.add(ImageTypeSpecifier.createFromBufferedImageType(5));
            typeList.add(ImageTypeSpecifier.createFromBufferedImageType(1));
            typeList.add(ImageTypeSpecifier.createFromBufferedImageType(4));
            ICC_Profile profile = this.getEmbeddedICCProfile(false);
            if (csType == JPEGColorSpace.CMYK || csType == JPEGColorSpace.YCCK) {
                if (profile != null) {
                    typeList.add(ImageTypeSpecifier.createInterleaved(ColorSpaces.createColorSpace(profile), new int[]{3, 2, 1, 0}, 0, false, false));
                }
                typeList.add(ImageTypeSpecifier.createInterleaved(ColorSpaces.getColorSpace(5001), new int[]{3, 2, 1, 0}, 0, false, false));
            } else if (csType == JPEGColorSpace.YCbCr || csType == JPEGColorSpace.RGB) {
                if (profile != null) {
                    typeList.add(ImageTypeSpecifier.createInterleaved(ColorSpaces.createColorSpace(profile), new int[]{0, 1, 2}, 0, false, false));
                }
            } else if (csType == JPEGColorSpace.YCbCrA || csType == JPEGColorSpace.RGBA) {
                typeList.addAll(0, Arrays.asList(ImageTypeSpecifier.createFromBufferedImageType(2), ImageTypeSpecifier.createFromBufferedImageType(6), ImageTypeSpecifier.createFromBufferedImageType(3), ImageTypeSpecifier.createFromBufferedImageType(7)));
                if (profile != null) {
                    typeList.add(ImageTypeSpecifier.createInterleaved(ColorSpaces.createColorSpace(profile), new int[]{0, 1, 2, 3}, 0, false, false));
                }
            }
            return typeList.iterator();
        }
        return types;
    }

    @Override
    public ImageTypeSpecifier getRawImageType(int imageIndex) throws IOException {
        ImageTypeSpecifier rawType = this.delegate.getRawImageType(imageIndex);
        if (rawType != null) {
            return rawType;
        }
        JPEGColorSpace csType = JPEGImageReader.getSourceCSType(this.getJFIF(), this.getAdobeDCT(), this.getSOF());
        switch (csType) {
            case CMYK: {
                ICC_Profile profile = this.getEmbeddedICCProfile(false);
                if (profile != null) {
                    return ImageTypeSpecifier.createInterleaved(ColorSpaces.createColorSpace(profile), new int[]{3, 2, 1, 0}, 0, false, false);
                }
                return ImageTypeSpecifier.createInterleaved(ColorSpaces.getColorSpace(5001), new int[]{3, 2, 1, 0}, 0, false, false);
            }
        }
        return null;
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.delegate.setInput(this.imageInput != null ? new JPEGSegmentImageInputStream(this.imageInput) : null, seekForwardOnly, ignoreMetadata);
    }

    @Override
    public boolean isRandomAccessEasy(int imageIndex) throws IOException {
        return this.delegate.isRandomAccessEasy(imageIndex);
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.assertInput();
        this.checkBounds(imageIndex);
        ICC_Profile profile = this.getEmbeddedICCProfile(false);
        AdobeDCTSegment adobeDCT = this.getAdobeDCT();
        SOFSegment sof = this.getSOF();
        JPEGColorSpace sourceCSType = JPEGImageReader.getSourceCSType(this.getJFIF(), adobeDCT, sof);
        if (this.delegate.canReadRaster() && (sourceCSType == JPEGColorSpace.CMYK || sourceCSType == JPEGColorSpace.YCCK || adobeDCT != null && adobeDCT.getTransform() == 2 || profile != null && !ColorSpaces.isCS_sRGB(profile)) || sourceCSType == JPEGColorSpace.YCbCr && this.getRawImageType(imageIndex) != null) {
            if (DEBUG) {
                System.out.println("Reading using raster and extra conversion");
                System.out.println("ICC color profile: " + profile);
            }
            return this.readImageAsRasterAndReplaceColorProfile(imageIndex, param, sof, sourceCSType, adobeDCT, this.ensureDisplayProfile(profile));
        }
        if (DEBUG) {
            System.out.println("Reading using delegate");
        }
        return this.delegate.read(imageIndex, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readImageAsRasterAndReplaceColorProfile(int imageIndex, ImageReadParam param, SOFSegment startOfFrame, JPEGColorSpace csType, AdobeDCTSegment adobeDCT, ICC_Profile profile) throws IOException {
        Rectangle origSourceRegion;
        ICC_ColorSpace intendedCS;
        int origWidth = this.getWidth(imageIndex);
        int origHeight = this.getHeight(imageIndex);
        Iterator<ImageTypeSpecifier> imageTypes = this.getImageTypes(imageIndex);
        BufferedImage image = JPEGImageReader.getDestination(param, imageTypes, origWidth, origHeight);
        WritableRaster destination = image.getRaster();
        RasterOp convert = null;
        ICC_ColorSpace iCC_ColorSpace = intendedCS = profile != null ? ColorSpaces.createColorSpace(profile) : null;
        if (profile == null || csType != JPEGColorSpace.Gray && csType != JPEGColorSpace.GrayA) {
            if (intendedCS != null) {
                if (startOfFrame.componentsInFrame() != intendedCS.getNumComponents()) {
                    if (startOfFrame.componentsInFrame() < 4 && (csType == JPEGColorSpace.CMYK || csType == JPEGColorSpace.YCCK)) {
                        this.processWarningOccurred(String.format("Invalid Adobe App14 marker. Indicates YCCK/CMYK data, but SOF%d has %d color components. Ignoring Adobe App14 marker, assuming YCbCr/RGB data.", startOfFrame.marker & 0xF, startOfFrame.componentsInFrame()));
                        csType = JPEGColorSpace.YCbCr;
                    } else {
                        this.processWarningOccurred(String.format("Embedded ICC color profile is incompatible with image data. Profile indicates %d components, but SOF%d has %d color components. Ignoring ICC profile, assuming source color space %s.", new Object[]{intendedCS.getNumComponents(), startOfFrame.marker & 0xF, startOfFrame.componentsInFrame(), csType}));
                    }
                } else if (intendedCS != image.getColorModel().getColorSpace()) {
                    if (DEBUG) {
                        System.err.println("Converting from " + intendedCS + " to " + (image.getColorModel().getColorSpace().isCS_sRGB() ? "sRGB" : image.getColorModel().getColorSpace()));
                    }
                    convert = new ColorConvertOp(intendedCS, image.getColorModel().getColorSpace(), null);
                }
            } else if (csType == JPEGColorSpace.YCCK || csType == JPEGColorSpace.CMYK) {
                ColorSpace cmykCS = ColorSpaces.getColorSpace(5001);
                if (cmykCS instanceof ICC_ColorSpace) {
                    this.processWarningOccurred("No embedded ICC color profile, defaulting to \"generic\" CMYK ICC profile. Colors may look incorrect.");
                    convert = new ColorConvertOp(cmykCS, image.getColorModel().getColorSpace(), null);
                } else {
                    this.processWarningOccurred("No embedded ICC color profile, will convert using inaccurate CMYK to RGB conversion. Colors may look incorrect.");
                    convert = new FastCMYKToRGB();
                }
            } else if (profile != null) {
                this.processWarningOccurred("Embedded ICC color profile is incompatible with Java 2D, color profile will be ignored.");
            }
        }
        if (param == null) {
            param = this.delegate.getDefaultReadParam();
            origSourceRegion = null;
        } else {
            origSourceRegion = param.getSourceRegion();
        }
        Rectangle srcRegion = new Rectangle();
        Rectangle dstRegion = new Rectangle();
        JPEGImageReader.computeRegions(param, origWidth, origHeight, image, srcRegion, dstRegion);
        this.processImageStarted(imageIndex);
        try {
            int step = Math.max(1024, srcRegion.height / 10);
            int srcMaxY = srcRegion.y + srcRegion.height;
            int destY = dstRegion.y;
            for (int y = srcRegion.y; y < srcMaxY; y += step) {
                int scan = Math.min(step, srcMaxY - y);
                this.progressDelegator.updateProgressRange(100.0f * (float)(y + scan) / (float)srcRegion.height);
                if (scan <= param.getSubsamplingYOffset()) {
                    param.setSourceSubsampling(param.getSourceXSubsampling(), param.getSourceYSubsampling(), param.getSubsamplingXOffset(), scan - 1);
                }
                Rectangle subRegion = new Rectangle(srcRegion.x, y, srcRegion.width, scan);
                param.setSourceRegion(subRegion);
                Raster raster = this.delegate.readRaster(imageIndex, param);
                if (csType == JPEGColorSpace.YCbCr || csType == JPEGColorSpace.YCbCrA) {
                    YCbCrConverter.convertYCbCr2RGB(raster);
                } else if (csType == JPEGColorSpace.YCCK) {
                    YCbCrConverter.convertYCCK2CMYK(raster);
                } else if (csType == JPEGColorSpace.CMYK) {
                    JPEGImageReader.invertCMYK(raster);
                }
                int destHeight = Math.min(raster.getHeight(), dstRegion.height - destY);
                Raster src = raster.createChild(0, 0, raster.getWidth(), destHeight, 0, 0, param.getSourceBands());
                WritableRaster dest = destination.createWritableChild(dstRegion.x, destY, raster.getWidth(), destHeight, 0, 0, param.getDestinationBands());
                if (convert != null) {
                    convert.filter(src, dest);
                } else {
                    dest.setRect(0, 0, src);
                }
                destY += raster.getHeight();
                if (!this.abortRequested()) continue;
                this.processReadAborted();
                break;
            }
        }
        finally {
            this.progressDelegator.resetProgressRange();
            param.setSourceRegion(origSourceRegion);
        }
        this.processImageComplete();
        return image;
    }

    static JPEGColorSpace getSourceCSType(JFIFSegment jfif, AdobeDCTSegment adobeDCT, SOFSegment startOfFrame) throws IIOException {
        if (adobeDCT != null) {
            switch (adobeDCT.getTransform()) {
                case 1: {
                    return JPEGColorSpace.YCbCr;
                }
                case 2: {
                    return JPEGColorSpace.YCCK;
                }
                case 0: {
                    if (startOfFrame.components.length == 1) {
                        return JPEGColorSpace.Gray;
                    }
                    if (startOfFrame.components.length == 3) {
                        return JPEGColorSpace.RGB;
                    }
                    if (startOfFrame.components.length != 4) break;
                    return JPEGColorSpace.CMYK;
                }
            }
        }
        switch (startOfFrame.components.length) {
            case 1: {
                return JPEGColorSpace.Gray;
            }
            case 2: {
                return JPEGColorSpace.GrayA;
            }
            case 3: {
                if (startOfFrame.components[0].id == 1 && startOfFrame.components[1].id == 2 && startOfFrame.components[2].id == 3) {
                    return JPEGColorSpace.YCbCr;
                }
                if (startOfFrame.components[0].id == 82 && startOfFrame.components[1].id == 71 && startOfFrame.components[2].id == 66) {
                    return JPEGColorSpace.RGB;
                }
                if (startOfFrame.components[0].id == 89 && startOfFrame.components[1].id == 67 && startOfFrame.components[2].id == 99) {
                    return JPEGColorSpace.PhotoYCC;
                }
                for (SOFComponent component : startOfFrame.components) {
                    if (component.hSub == 1 && component.vSub == 1) continue;
                    return JPEGColorSpace.YCbCr;
                }
                return jfif != null ? JPEGColorSpace.YCbCr : JPEGColorSpace.RGB;
            }
            case 4: {
                if (startOfFrame.components[0].id == 1 && startOfFrame.components[1].id == 2 && startOfFrame.components[2].id == 3 && startOfFrame.components[3].id == 4) {
                    return JPEGColorSpace.YCbCrA;
                }
                if (startOfFrame.components[0].id == 82 && startOfFrame.components[1].id == 71 && startOfFrame.components[2].id == 66 && startOfFrame.components[3].id == 65) {
                    return JPEGColorSpace.RGBA;
                }
                if (startOfFrame.components[0].id == 89 && startOfFrame.components[1].id == 67 && startOfFrame.components[2].id == 99 && startOfFrame.components[3].id == 65) {
                    return JPEGColorSpace.PhotoYCCA;
                }
                if (startOfFrame.components[0].id == 67 && startOfFrame.components[1].id == 77 && startOfFrame.components[2].id == 89 && startOfFrame.components[3].id == 75) {
                    return JPEGColorSpace.CMYK;
                }
                if (startOfFrame.components[0].id == 89 && startOfFrame.components[1].id == 67 && startOfFrame.components[2].id == 99 && startOfFrame.components[3].id == 75) {
                    return JPEGColorSpace.YCCK;
                }
                for (SOFComponent component : startOfFrame.components) {
                    if (component.hSub == 1 && component.vSub == 1) continue;
                    return JPEGColorSpace.YCCK;
                }
                return JPEGColorSpace.CMYK;
            }
        }
        throw new IIOException("Cannot determine source color space");
    }

    private ICC_Profile ensureDisplayProfile(ICC_Profile profile) {
        byte[] profileData;
        if (profile != null && profile.getProfileClass() != 1 && (profileData = profile.getData())[64] == 0) {
            this.processWarningOccurred("ICC profile is Perceptual, ignoring, treating as Display class");
            JPEGImageReader.intToBigEndian(1835955314, profileData, 12);
            return ICC_Profile.getInstance(profileData);
        }
        return profile;
    }

    static void intToBigEndian(int value, byte[] array, int index) {
        array[index] = (byte)(value >> 24);
        array[index + 1] = (byte)(value >> 16);
        array[index + 2] = (byte)(value >> 8);
        array[index + 3] = (byte)value;
    }

    private void initHeader() throws IOException {
        if (this.segments == null) {
            long start = DEBUG ? System.currentTimeMillis() : 0L;
            this.readSegments();
            if (DEBUG) {
                System.out.println("Read metadata in " + (System.currentTimeMillis() - start) + " ms");
            }
        }
    }

    private void readSegments() throws IOException {
        this.imageInput.mark();
        try {
            this.imageInput.seek(0L);
            this.segments = JPEGSegmentUtil.readSegments(this.imageInput, SEGMENT_IDENTIFIERS);
        }
        catch (IIOException ignore) {
            if (DEBUG) {
                ignore.printStackTrace();
            }
        }
        catch (IllegalArgumentException foo) {
            if (DEBUG) {
                foo.printStackTrace();
            }
        }
        finally {
            this.imageInput.reset();
        }
        if (this.segments == null) {
            this.segments = Collections.emptyList();
        }
    }

    List<JPEGSegment> getAppSegments(int marker, String identifier) throws IOException {
        this.initHeader();
        List<JPEGSegment> appSegments = Collections.emptyList();
        for (JPEGSegment segment : this.segments) {
            if ((marker != -1 || segment.marker() < 65504 || segment.marker() > 65519) && segment.marker() != marker || identifier != null && !identifier.equals(segment.identifier())) continue;
            if (appSegments == Collections.EMPTY_LIST) {
                appSegments = new ArrayList<JPEGSegment>(this.segments.size());
            }
            appSegments.add(segment);
        }
        return appSegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SOFSegment getSOF() throws IOException {
        for (JPEGSegment segment : this.segments) {
            if (!(65472 >= segment.marker() && segment.marker() <= 65475 || 65477 >= segment.marker() && segment.marker() <= 65479 || 65481 >= segment.marker() && segment.marker() <= 65483) && (65485 < segment.marker() || segment.marker() > 65487)) continue;
            try (DataInputStream data = new DataInputStream(segment.data());){
                int samplePrecision = data.readUnsignedByte();
                int lines = data.readUnsignedShort();
                int samplesPerLine = data.readUnsignedShort();
                int componentsInFrame = data.readUnsignedByte();
                SOFComponent[] components = new SOFComponent[componentsInFrame];
                for (int i = 0; i < componentsInFrame; ++i) {
                    int id = data.readUnsignedByte();
                    int sub = data.readUnsignedByte();
                    int qtSel = data.readUnsignedByte();
                    components[i] = new SOFComponent(id, (sub & 0xF0) >> 4, sub & 0xF, qtSel);
                }
                SOFSegment sOFSegment = new SOFSegment(segment.marker(), samplePrecision, lines, samplesPerLine, components);
                return sOFSegment;
            }
        }
        return null;
    }

    AdobeDCTSegment getAdobeDCT() throws IOException {
        List<JPEGSegment> adobe = this.getAppSegments(65518, "Adobe");
        if (!adobe.isEmpty()) {
            DataInputStream stream = new DataInputStream(adobe.get(0).data());
            return new AdobeDCTSegment(stream.readUnsignedByte(), stream.readUnsignedShort(), stream.readUnsignedShort(), stream.readUnsignedByte());
        }
        return null;
    }

    JFIFSegment getJFIF() throws IOException {
        List<JPEGSegment> jfif = this.getAppSegments(65504, "JFIF");
        if (!jfif.isEmpty()) {
            JPEGSegment segment = jfif.get(0);
            return JFIFSegment.read(segment.data());
        }
        return null;
    }

    JFXXSegment getJFXX() throws IOException {
        List<JPEGSegment> jfxx = this.getAppSegments(65504, "JFXX");
        if (!jfxx.isEmpty()) {
            JPEGSegment segment = jfxx.get(0);
            return JFXXSegment.read(segment.data(), segment.length());
        }
        return null;
    }

    private CompoundDirectory getExif() throws IOException {
        List<JPEGSegment> exifSegments = this.getAppSegments(65505, "Exif");
        if (!exifSegments.isEmpty()) {
            JPEGSegment exif = exifSegments.get(0);
            InputStream data = exif.data();
            if (data.read() == -1) {
                this.processWarningOccurred("Exif chunk has no data.");
            } else {
                ImageInputStream stream = ImageIO.createImageInputStream(data);
                return (CompoundDirectory)new EXIFReader().read(stream);
            }
        }
        return null;
    }

    static byte[] readFully(DataInput stream, int len) throws IOException {
        if (len == 0) {
            return null;
        }
        byte[] data = new byte[len];
        stream.readFully(data);
        return data;
    }

    ICC_Profile getEmbeddedICCProfile(boolean allowBadIndexes) throws IOException {
        List<JPEGSegment> segments = this.getAppSegments(65506, "ICC_PROFILE");
        if (segments.size() == 1) {
            JPEGSegment segment = segments.get(0);
            DataInputStream stream = new DataInputStream(segment.data());
            int chunkNumber = stream.readUnsignedByte();
            int chunkCount = stream.readUnsignedByte();
            if (chunkNumber != 1 && chunkCount != 1) {
                this.processWarningOccurred(String.format("Unexpected number of 'ICC_PROFILE' chunks: %d of %d. Ignoring ICC profile.", chunkNumber, chunkCount));
                return null;
            }
            return this.readICCProfileSafe(stream);
        }
        if (!segments.isEmpty()) {
            DataInputStream stream = new DataInputStream(segments.get(0).data());
            int chunkNumber = stream.readUnsignedByte();
            int chunkCount = stream.readUnsignedByte();
            boolean badICC = false;
            if (chunkCount != segments.size()) {
                this.processWarningOccurred(String.format("Bad 'ICC_PROFILE' chunk count: %d. Ignoring ICC profile.", chunkCount));
                badICC = true;
                if (!allowBadIndexes) {
                    return null;
                }
            }
            if (!badICC && chunkNumber < 1) {
                this.processWarningOccurred(String.format("Invalid 'ICC_PROFILE' chunk index: %d. Ignoring ICC profile.", chunkNumber));
                if (!allowBadIndexes) {
                    return null;
                }
            }
            int count = badICC ? segments.size() : chunkCount;
            InputStream[] streams = new InputStream[count];
            streams[badICC ? 0 : chunkNumber - 1] = stream;
            for (int i = 1; i < count; ++i) {
                stream = new DataInputStream(segments.get(i).data());
                chunkNumber = stream.readUnsignedByte();
                if (!badICC && stream.readUnsignedByte() != chunkCount) {
                    throw new IIOException(String.format("Bad number of 'ICC_PROFILE' chunks: %d of %d.", chunkNumber, chunkCount));
                }
                streams[badICC ? i : chunkNumber - 1] = stream;
            }
            return this.readICCProfileSafe(new SequenceInputStream(Collections.enumeration(Arrays.asList(streams))));
        }
        return null;
    }

    private ICC_Profile readICCProfileSafe(InputStream stream) throws IOException {
        try {
            return ICC_Profile.getInstance(stream);
        }
        catch (RuntimeException e) {
            this.processWarningOccurred(String.format("Bad 'ICC_PROFILE' chunk(s): %s. Ignoring ICC profile.", e.getMessage()));
            return null;
        }
    }

    @Override
    public boolean canReadRaster() {
        return this.delegate.canReadRaster();
    }

    @Override
    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        return this.delegate.readRaster(imageIndex, param);
    }

    @Override
    public RenderedImage readAsRenderedImage(int imageIndex, ImageReadParam param) throws IOException {
        return this.read(imageIndex, param);
    }

    @Override
    public void abort() {
        super.abort();
        this.delegate.abort();
    }

    @Override
    public boolean readerSupportsThumbnails() {
        return true;
    }

    private void readThumbnailMetadata(int imageIndex) throws IOException {
        this.checkBounds(imageIndex);
        if (this.thumbnails == null) {
            List<JPEGSegment> exifSegments;
            JFXXSegment jfxx;
            this.thumbnails = new ArrayList<ThumbnailReader>();
            ThumbnailProgressDelegate thumbnailProgressDelegator = new ThumbnailProgressDelegate();
            JFIFSegment jfif = this.getJFIF();
            if (jfif != null && jfif.thumbnail != null) {
                this.thumbnails.add(new JFIFThumbnailReader(thumbnailProgressDelegator, imageIndex, this.thumbnails.size(), jfif));
            }
            if ((jfxx = this.getJFXX()) != null && jfxx.thumbnail != null) {
                switch (jfxx.extensionCode) {
                    case 16: 
                    case 17: 
                    case 19: {
                        this.thumbnails.add(new JFXXThumbnailReader(thumbnailProgressDelegator, this.getThumbnailReader(), imageIndex, this.thumbnails.size(), jfxx));
                        break;
                    }
                    default: {
                        this.processWarningOccurred("Unknown JFXX extension code: " + jfxx.extensionCode);
                    }
                }
            }
            if (!(exifSegments = this.getAppSegments(65505, "Exif")).isEmpty()) {
                JPEGSegment exif = exifSegments.get(0);
                InputStream data = exif.data();
                if (data.read() == -1) {
                    this.processWarningOccurred("Exif chunk has no data.");
                } else {
                    MemoryCacheImageInputStream stream = new MemoryCacheImageInputStream(data);
                    CompoundDirectory exifMetadata = (CompoundDirectory)new EXIFReader().read(stream);
                    if (exifMetadata.directoryCount() == 2) {
                        Directory ifd1 = exifMetadata.getDirectory(1);
                        Entry compression = ifd1.getEntryById(259);
                        if (compression == null || compression.getValue().equals(1) || compression.getValue().equals(6)) {
                            Entry jpegLength = ifd1.getEntryById(514);
                            if (jpegLength == null || ((Number)jpegLength.getValue()).longValue() > 0L) {
                                this.thumbnails.add(new EXIFThumbnailReader(thumbnailProgressDelegator, this.getThumbnailReader(), 0, this.thumbnails.size(), ifd1, stream));
                            } else {
                                this.processWarningOccurred("EXIF IFD with empty (zero-length) thumbnail");
                            }
                        } else {
                            this.processWarningOccurred("EXIF IFD with unknown compression (expected 1 or 6): " + compression.getValue());
                        }
                    }
                }
            }
        }
    }

    ImageReader getThumbnailReader() throws IOException {
        if (this.thumbnailReader == null) {
            this.thumbnailReader = this.delegate.getOriginatingProvider().createReaderInstance();
        }
        return this.thumbnailReader;
    }

    @Override
    public int getNumThumbnails(int imageIndex) throws IOException {
        this.readThumbnailMetadata(imageIndex);
        return this.thumbnails.size();
    }

    private void checkThumbnailBounds(int imageIndex, int thumbnailIndex) throws IOException {
        Validate.isTrue(thumbnailIndex >= 0, thumbnailIndex, "thumbnailIndex < 0; %d");
        Validate.isTrue(this.getNumThumbnails(imageIndex) > thumbnailIndex, thumbnailIndex, "thumbnailIndex >= numThumbnails; %d");
    }

    @Override
    public int getThumbnailWidth(int imageIndex, int thumbnailIndex) throws IOException {
        this.checkThumbnailBounds(imageIndex, thumbnailIndex);
        return this.thumbnails.get(thumbnailIndex).getWidth();
    }

    @Override
    public int getThumbnailHeight(int imageIndex, int thumbnailIndex) throws IOException {
        this.checkThumbnailBounds(imageIndex, thumbnailIndex);
        return this.thumbnails.get(thumbnailIndex).getHeight();
    }

    @Override
    public BufferedImage readThumbnail(int imageIndex, int thumbnailIndex) throws IOException {
        this.checkThumbnailBounds(imageIndex, thumbnailIndex);
        return this.thumbnails.get(thumbnailIndex).read();
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        IIOMetadata imageMetadata = this.delegate.getImageMetadata(imageIndex);
        if (imageMetadata != null && Arrays.asList(imageMetadata.getMetadataFormatNames()).contains("javax_imageio_jpeg_image_1.0")) {
            if (this.metadataCleaner == null) {
                this.metadataCleaner = new JPEGImage10MetadataCleaner(this);
            }
            return this.metadataCleaner.cleanMetadata(imageMetadata);
        }
        return imageMetadata;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return this.delegate.getStreamMetadata();
    }

    @Override
    protected void processWarningOccurred(String warning) {
        super.processWarningOccurred(warning);
    }

    private static void invertCMYK(Raster raster) {
        byte[] data = ((DataBufferByte)raster.getDataBuffer()).getData();
        int dataLength = data.length;
        for (int i = 0; i < dataLength; ++i) {
            data[i] = (byte)(255 - data[i] & 0xFF);
        }
    }

    protected static void showIt(BufferedImage pImage, String pTitle) {
        ImageReaderBase.showIt(pImage, pTitle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        for (final String arg : args) {
            File file = new File(arg);
            ImageInputStream input = ImageIO.createImageInputStream(file);
            if (input == null) {
                System.err.println("Could not read file: " + file);
                continue;
            }
            Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
            if (!readers.hasNext()) {
                System.err.println("No reader for: " + file);
                continue;
            }
            ImageReader reader = readers.next();
            reader.addIIOReadWarningListener(new IIOReadWarningListener(){

                @Override
                public void warningOccurred(ImageReader source, String warning) {
                    System.err.println("Warning: " + arg + ": " + warning);
                }
            });
            reader.addIIOReadProgressListener(new ProgressListenerBase(){
                private static final int MAX_W = 78;
                int lastProgress = 0;

                @Override
                public void imageStarted(ImageReader source, int imageIndex) {
                    System.out.print("[");
                }

                @Override
                public void imageProgress(ImageReader source, float percentageDone) {
                    int steps = (int)(percentageDone * 78.0f) / 100;
                    for (int i = this.lastProgress; i < steps; ++i) {
                        System.out.print(".");
                    }
                    System.out.flush();
                    this.lastProgress = steps;
                }

                @Override
                public void imageComplete(ImageReader source) {
                    for (int i = this.lastProgress; i < 78; ++i) {
                        System.out.print(".");
                    }
                    System.out.println("]");
                }
            });
            reader.setInput(input);
            try {
                ImageReadParam param = reader.getDefaultReadParam();
                BufferedImage image = reader.read(0, param);
                int maxW = 1280;
                int maxH = 800;
                if (image.getWidth() > maxW || image.getHeight() > maxH) {
                    float aspect = reader.getAspectRatio(0);
                    image = aspect >= 1.0f ? ImageUtil.createResampled(image, maxW, Math.round((float)maxW / aspect), 4) : ImageUtil.createResampled(image, Math.round((float)maxH * aspect), maxH, 4);
                }
                JPEGImageReader.showIt(image, String.format("Image: %s [%d x %d]", file.getName(), reader.getWidth(0), reader.getHeight(0)));
                try {
                    IIOMetadata imageMetadata = reader.getImageMetadata(0);
                    System.out.println("Metadata for File: " + file.getName());
                    System.out.println("Native:");
                    new XMLSerializer(System.out, System.getProperty("file.encoding")).serialize(imageMetadata.getAsTree(imageMetadata.getNativeMetadataFormatName()), false);
                    System.out.println("Standard:");
                    new XMLSerializer(System.out, System.getProperty("file.encoding")).serialize(imageMetadata.getAsTree("javax_imageio_1.0"), false);
                    System.out.println();
                    int numThumbnails = reader.getNumThumbnails(0);
                    for (int i = 0; i < numThumbnails; ++i) {
                        BufferedImage thumbnail = reader.readThumbnail(0, i);
                        JPEGImageReader.showIt(thumbnail, String.format("Thumbnail: %s [%d x %d]", file.getName(), thumbnail.getWidth(), thumbnail.getHeight()));
                    }
                }
                catch (IIOException e) {
                    System.err.println("Could not read thumbnails: " + arg + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
            catch (Throwable t) {
                System.err.println(file);
                t.printStackTrace();
            }
            finally {
                input.close();
            }
        }
    }

    private class ThumbnailProgressDelegate
    implements ThumbnailReadProgressListener {
        private ThumbnailProgressDelegate() {
        }

        @Override
        public void processThumbnailStarted(int imageIndex, int thumbnailIndex) {
            JPEGImageReader.this.processThumbnailStarted(imageIndex, thumbnailIndex);
        }

        @Override
        public void processThumbnailProgress(float percentageDone) {
            JPEGImageReader.this.processThumbnailProgress(percentageDone);
        }

        @Override
        public void processThumbnailComplete() {
            JPEGImageReader.this.processThumbnailComplete();
        }
    }

    private class ProgressDelegator
    extends ProgressListenerBase
    implements IIOReadUpdateListener,
    IIOReadWarningListener {
        float readProgressStart = -1.0f;
        float readProgressStop = -1.0f;

        private ProgressDelegator() {
        }

        void resetProgressRange() {
            this.readProgressStart = -1.0f;
            this.readProgressStop = -1.0f;
        }

        private boolean isProgressRangeCorrected() {
            return this.readProgressStart == -1.0f && this.readProgressStop == -1.0f;
        }

        void updateProgressRange(float limit) {
            Validate.isTrue(limit >= 0.0f, Float.valueOf(limit), "Negative range limit");
            this.readProgressStart = this.readProgressStop != -1.0f ? this.readProgressStop : 0.0f;
            this.readProgressStop = limit;
        }

        @Override
        public void imageComplete(ImageReader source) {
            if (this.isProgressRangeCorrected()) {
                JPEGImageReader.this.processImageComplete();
            }
        }

        @Override
        public void imageProgress(ImageReader source, float percentageDone) {
            if (this.isProgressRangeCorrected()) {
                JPEGImageReader.this.processImageProgress(percentageDone);
            } else {
                JPEGImageReader.this.processImageProgress(this.readProgressStart + percentageDone * (this.readProgressStop - this.readProgressStart) / 100.0f);
            }
        }

        @Override
        public void imageStarted(ImageReader source, int imageIndex) {
            if (this.isProgressRangeCorrected()) {
                JPEGImageReader.this.processImageStarted(imageIndex);
            }
        }

        @Override
        public void readAborted(ImageReader source) {
            if (this.isProgressRangeCorrected()) {
                JPEGImageReader.this.processReadAborted();
            }
        }

        @Override
        public void sequenceComplete(ImageReader source) {
            JPEGImageReader.this.processSequenceComplete();
        }

        @Override
        public void sequenceStarted(ImageReader source, int minIndex) {
            JPEGImageReader.this.processSequenceStarted(minIndex);
        }

        @Override
        public void thumbnailComplete(ImageReader source) {
            JPEGImageReader.this.processThumbnailComplete();
        }

        @Override
        public void thumbnailProgress(ImageReader source, float percentageDone) {
            JPEGImageReader.this.processThumbnailProgress(percentageDone);
        }

        @Override
        public void thumbnailStarted(ImageReader source, int imageIndex, int thumbnailIndex) {
            JPEGImageReader.this.processThumbnailStarted(imageIndex, thumbnailIndex);
        }

        @Override
        public void passStarted(ImageReader source, BufferedImage theImage, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
            JPEGImageReader.this.processPassStarted(theImage, pass, minPass, maxPass, minX, minY, periodX, periodY, bands);
        }

        @Override
        public void imageUpdate(ImageReader source, BufferedImage theImage, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
            JPEGImageReader.this.processImageUpdate(theImage, minX, minY, width, height, periodX, periodY, bands);
        }

        @Override
        public void passComplete(ImageReader source, BufferedImage theImage) {
            JPEGImageReader.this.processPassComplete(theImage);
        }

        @Override
        public void thumbnailPassStarted(ImageReader source, BufferedImage theThumbnail, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
            JPEGImageReader.this.processThumbnailPassStarted(theThumbnail, pass, minPass, maxPass, minX, minY, periodX, periodY, bands);
        }

        @Override
        public void thumbnailUpdate(ImageReader source, BufferedImage theThumbnail, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
            JPEGImageReader.this.processThumbnailUpdate(theThumbnail, minX, minY, width, height, periodX, periodY, bands);
        }

        @Override
        public void thumbnailPassComplete(ImageReader source, BufferedImage theThumbnail) {
            JPEGImageReader.this.processThumbnailPassComplete(theThumbnail);
        }

        @Override
        public void warningOccurred(ImageReader source, String warning) {
            JPEGImageReader.this.processWarningOccurred(warning);
        }
    }

    static final class YCbCrConverter {
        private static final int SCALEBITS = 16;
        private static final int MAXJSAMPLE = 255;
        private static final int CENTERJSAMPLE = 128;
        private static final int ONE_HALF = 32768;
        private static final int[] Cr_R_LUT = new int[256];
        private static final int[] Cb_B_LUT = new int[256];
        private static final int[] Cr_G_LUT = new int[256];
        private static final int[] Cb_G_LUT = new int[256];

        YCbCrConverter() {
        }

        private static void buildYCCtoRGBtable() {
            if (DEBUG) {
                System.err.println("Building YCC conversion table");
            }
            int i = 0;
            int x = -128;
            while (i <= 255) {
                YCbCrConverter.Cr_R_LUT[i] = (int)(91881.972 * (double)x + 32768.0) >> 16;
                YCbCrConverter.Cb_B_LUT[i] = (int)(116130.292 * (double)x + 32768.0) >> 16;
                YCbCrConverter.Cr_G_LUT[i] = -46802 * x;
                YCbCrConverter.Cb_G_LUT[i] = -22554 * x + 32768;
                ++i;
                ++x;
            }
        }

        static void convertYCbCr2RGB(Raster raster) {
            int height = raster.getHeight();
            int width = raster.getWidth();
            byte[] data = ((DataBufferByte)raster.getDataBuffer()).getData();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    YCbCrConverter.convertYCbCr2RGB(data, data, (x + y * width) * 3);
                }
            }
        }

        static void convertYCbCr2RGB(byte[] yCbCr, byte[] rgb, int offset) {
            int y = yCbCr[offset] & 0xFF;
            int cr = yCbCr[offset + 2] & 0xFF;
            int cb = yCbCr[offset + 1] & 0xFF;
            rgb[offset] = YCbCrConverter.clamp(y + Cr_R_LUT[cr]);
            rgb[offset + 1] = YCbCrConverter.clamp(y + (Cb_G_LUT[cb] + Cr_G_LUT[cr] >> 16));
            rgb[offset + 2] = YCbCrConverter.clamp(y + Cb_B_LUT[cb]);
        }

        static void convertYCCK2CMYK(Raster raster) {
            int height = raster.getHeight();
            int width = raster.getWidth();
            byte[] data = ((DataBufferByte)raster.getDataBuffer()).getData();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    YCbCrConverter.convertYCCK2CMYK(data, data, (x + y * width) * 4);
                }
            }
        }

        private static void convertYCCK2CMYK(byte[] ycck, byte[] cmyk, int offset) {
            int y = 255 - ycck[offset] & 0xFF;
            int cb = 255 - ycck[offset + 1] & 0xFF;
            int cr = 255 - ycck[offset + 2] & 0xFF;
            int k = 255 - ycck[offset + 3] & 0xFF;
            int cmykC = 255 - (y + Cr_R_LUT[cr]);
            int cmykM = 255 - (y + (Cb_G_LUT[cb] + Cr_G_LUT[cr] >> 16));
            int cmykY = 255 - (y + Cb_B_LUT[cb]);
            cmyk[offset] = YCbCrConverter.clamp(cmykC);
            cmyk[offset + 1] = YCbCrConverter.clamp(cmykM);
            cmyk[offset + 2] = YCbCrConverter.clamp(cmykY);
            cmyk[offset + 3] = (byte)k;
        }

        private static byte clamp(int val) {
            return (byte)Math.max(0, Math.min(255, val));
        }

        static {
            YCbCrConverter.buildYCCtoRGBtable();
        }
    }
}

