/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.AdobeDCTSegment;
import com.alkacon.simapi.CmykJpegReader.JFIFSegment;
import com.alkacon.simapi.CmykJpegReader.JFXXSegment;
import com.alkacon.simapi.CmykJpegReader.JFXXThumbnailReader;
import com.alkacon.simapi.CmykJpegReader.JPEGImageReader;
import com.alkacon.simapi.CmykJpegReader.JPEGSegment;
import com.alkacon.simapi.CmykJpegReader.SOFSegment;
import com.alkacon.simapi.CmykJpegReader.XMLSerializer;
import java.awt.color.ICC_Profile;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class JPEGImage10MetadataCleaner {
    static final String JAVAX_IMAGEIO_JPEG_IMAGE_1_0 = "javax_imageio_jpeg_image_1.0";
    private final JPEGImageReader reader;

    JPEGImage10MetadataCleaner(JPEGImageReader reader) {
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IIOMetadata cleanMetadata(IIOMetadata imageMetadata) throws IOException {
        List<JPEGSegment> appSegments = this.reader.getAppSegments(-1, null);
        IIOMetadataNode tree = (IIOMetadataNode)imageMetadata.getAsTree(JAVAX_IMAGEIO_JPEG_IMAGE_1_0);
        IIOMetadataNode jpegVariety = (IIOMetadataNode)tree.getElementsByTagName("JPEGvariety").item(0);
        IIOMetadataNode markerSequence = (IIOMetadataNode)tree.getElementsByTagName("markerSequence").item(0);
        JFIFSegment jfifSegment = this.reader.getJFIF();
        JFXXSegment jfxxSegment = this.reader.getJFXX();
        AdobeDCTSegment adobeDCT = this.reader.getAdobeDCT();
        ICC_Profile embeddedICCProfile = this.reader.getEmbeddedICCProfile(true);
        SOFSegment sof = this.reader.getSOF();
        boolean hasRealJFIF = false;
        boolean hasRealJFXX = false;
        boolean hasRealICC = false;
        if (jfifSegment != null) {
            if (sof.componentsInFrame() == 1 || sof.componentsInFrame() == 3) {
                IIOMetadataNode jfif = new IIOMetadataNode("app0JFIF");
                jfif.setAttribute("majorVersion", String.valueOf(jfifSegment.majorVersion));
                jfif.setAttribute("minorVersion", String.valueOf(jfifSegment.minorVersion));
                jfif.setAttribute("resUnits", String.valueOf(jfifSegment.units));
                jfif.setAttribute("Xdensity", String.valueOf(Math.max(1, jfifSegment.xDensity)));
                jfif.setAttribute("Ydensity", String.valueOf(Math.max(1, jfifSegment.yDensity)));
                jfif.setAttribute("thumbWidth", String.valueOf(jfifSegment.xThumbnail));
                jfif.setAttribute("thumbHeight", String.valueOf(jfifSegment.yThumbnail));
                jpegVariety.appendChild(jfif);
                hasRealJFIF = true;
                if (embeddedICCProfile != null) {
                    IIOMetadataNode app2ICC = new IIOMetadataNode("app2ICC");
                    app2ICC.setUserObject(embeddedICCProfile);
                    jfif.appendChild(app2ICC);
                    hasRealICC = true;
                }
                if (jfxxSegment != null) {
                    IIOMetadataNode JFXX = new IIOMetadataNode("JFXX");
                    jfif.appendChild(JFXX);
                    IIOMetadataNode app0JFXX = new IIOMetadataNode("app0JFXX");
                    app0JFXX.setAttribute("extensionCode", String.valueOf(jfxxSegment.extensionCode));
                    JFXXThumbnailReader thumbnailReader = new JFXXThumbnailReader(null, this.reader.getThumbnailReader(), 0, 0, jfxxSegment);
                    switch (jfxxSegment.extensionCode) {
                        case 16: {
                            IIOMetadataNode jfifThumb = new IIOMetadataNode("JFIFthumbJPEG");
                            IIOMetadata thumbMeta = thumbnailReader.readMetadata();
                            Node thumbTree = thumbMeta.getAsTree(JAVAX_IMAGEIO_JPEG_IMAGE_1_0);
                            jfifThumb.appendChild(thumbTree.getLastChild());
                            app0JFXX.appendChild(jfifThumb);
                            break;
                        }
                        case 17: {
                            IIOMetadataNode jfifThumb = new IIOMetadataNode("JFIFthumbPalette");
                            jfifThumb.setAttribute("thumbWidth", String.valueOf(thumbnailReader.getWidth()));
                            jfifThumb.setAttribute("thumbHeight", String.valueOf(thumbnailReader.getHeight()));
                            app0JFXX.appendChild(jfifThumb);
                            break;
                        }
                        case 19: {
                            IIOMetadataNode jfifThumb = new IIOMetadataNode("JFIFthumbRGB");
                            jfifThumb.setAttribute("thumbWidth", String.valueOf(thumbnailReader.getWidth()));
                            jfifThumb.setAttribute("thumbHeight", String.valueOf(thumbnailReader.getHeight()));
                            app0JFXX.appendChild(jfifThumb);
                            break;
                        }
                        default: {
                            this.reader.processWarningOccurred(String.format("Unknown JFXX extension code: %d", jfxxSegment.extensionCode));
                        }
                    }
                    JFXX.appendChild(app0JFXX);
                    hasRealJFXX = true;
                }
            } else {
                this.reader.processWarningOccurred(String.format("Incompatible JFIF marker segment in stream. SOF%d has %d color components, JFIF allows only 1 or 3 components. Ignoring JFIF marker.", sof.marker & 0xF, sof.componentsInFrame()));
            }
        }
        if (adobeDCT != null && adobeDCT.getTransform() == 2 && sof.componentsInFrame() < 4) {
            this.reader.processWarningOccurred(String.format("Invalid Adobe App14 marker. Indicates YCCK/CMYK data, but SOF%d has %d color components. Ignoring Adobe App14 marker.", sof.marker & 0xF, sof.componentsInFrame()));
            NodeList app14Adobe = tree.getElementsByTagName("app14Adobe");
            for (int i = app14Adobe.getLength() - 1; i >= 0; --i) {
                Node item = app14Adobe.item(i);
                item.getParentNode().removeChild(item);
            }
        }
        Node next = null;
        for (JPEGSegment segment : appSegments) {
            if (segment.marker() == 65504 && "JFIF".equals(segment.identifier()) && hasRealJFIF || segment.marker() == 65504 && "JFXX".equals(segment.identifier()) && hasRealJFXX || segment.marker() == 65505 && "Exif".equals(segment.identifier()) || segment.marker() == 65506 && "ICC_PROFILE".equals(segment.identifier()) && hasRealICC || segment.marker() == 65518 && "Adobe".equals(segment.identifier())) continue;
            IIOMetadataNode unknown = new IIOMetadataNode("unknown");
            unknown.setAttribute("MarkerTag", Integer.toString(segment.marker() & 0xFF));
            try (DataInputStream stream = new DataInputStream(segment.data());){
                String identifier = segment.identifier();
                int off = identifier != null ? identifier.length() + 1 : 0;
                byte[] data = new byte[off + segment.length()];
                if (identifier != null) {
                    System.arraycopy(identifier.getBytes(Charset.forName("ASCII")), 0, data, 0, identifier.length());
                }
                stream.readFully(data, off, segment.length());
                unknown.setUserObject(data);
            }
            if (next == null) {
                NodeList unknowns = markerSequence.getElementsByTagName("unknown");
                next = unknowns.getLength() > 0 ? unknowns.item(unknowns.getLength() - 1).getNextSibling() : markerSequence.getFirstChild();
            }
            markerSequence.insertBefore(unknown, next);
        }
        NodeList dhts = markerSequence.getElementsByTagName("dht");
        for (int j = 0; j < dhts.getLength(); ++j) {
            Node dht = dhts.item(j);
            NodeList dhtables = dht.getChildNodes();
            if (dhtables.getLength() <= 4) continue;
            IIOMetadataNode acTables = new IIOMetadataNode("dht");
            dht.getParentNode().insertBefore(acTables, dht.getNextSibling());
            for (int i = 0; i < dhtables.getLength(); ++i) {
                Element dhtable = (Element)dhtables.item(i);
                String tableClass = dhtable.getAttribute("class");
                if (!"1".equals(tableClass)) continue;
                dht.removeChild(dhtable);
                acTables.appendChild(dhtable);
            }
        }
        try {
            imageMetadata.setFromTree(JAVAX_IMAGEIO_JPEG_IMAGE_1_0, tree);
        }
        catch (IIOInvalidTreeException e) {
            if (JPEGImageReader.DEBUG) {
                new XMLSerializer(System.out, System.getProperty("file.encoding")).serialize(tree, false);
            }
            throw e;
        }
        return imageMetadata;
    }
}

