/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.ByteArrayImageInputStream;
import com.alkacon.simapi.CmykJpegReader.InverseColorMapIndexColorModel;
import com.alkacon.simapi.CmykJpegReader.JFXXSegment;
import com.alkacon.simapi.CmykJpegReader.ThumbnailReadProgressListener;
import com.alkacon.simapi.CmykJpegReader.ThumbnailReader;
import com.alkacon.simapi.CmykJpegReader.Validate;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.lang.ref.SoftReference;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;

final class JFXXThumbnailReader
extends ThumbnailReader {
    private final ImageReader reader;
    private final JFXXSegment segment;
    private transient SoftReference<BufferedImage> cachedThumbnail;

    protected JFXXThumbnailReader(ThumbnailReadProgressListener progressListener, ImageReader jpegReader, int imageIndex, int thumbnailIndex, JFXXSegment segment) {
        super(progressListener, imageIndex, thumbnailIndex);
        this.reader = Validate.notNull(jpegReader);
        this.segment = segment;
    }

    @Override
    public BufferedImage read() throws IOException {
        BufferedImage thumbnail;
        this.processThumbnailStarted();
        switch (this.segment.extensionCode) {
            case 16: {
                thumbnail = this.readJPEGCached(true);
                break;
            }
            case 17: {
                thumbnail = this.readIndexed();
                break;
            }
            case 19: {
                thumbnail = this.readRGB();
                break;
            }
            default: {
                throw new IIOException(String.format("Unsupported JFXX extension code: %d", this.segment.extensionCode));
            }
        }
        this.processThumbnailProgress(100.0f);
        this.processThumbnailComplete();
        return thumbnail;
    }

    public IIOMetadata readMetadata() throws IOException {
        try (ByteArrayImageInputStream input = new ByteArrayImageInputStream(this.segment.thumbnail);){
            this.reader.setInput(input);
            IIOMetadata iIOMetadata = this.reader.getImageMetadata(0);
            return iIOMetadata;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readJPEGCached(boolean pixelsExposed) throws IOException {
        BufferedImage thumbnail;
        BufferedImage bufferedImage = thumbnail = this.cachedThumbnail != null ? this.cachedThumbnail.get() : null;
        if (thumbnail == null) {
            try (ByteArrayImageInputStream stream = new ByteArrayImageInputStream(this.segment.thumbnail);){
                thumbnail = JFXXThumbnailReader.readJPEGThumbnail(this.reader, stream);
            }
        }
        this.cachedThumbnail = pixelsExposed ? null : new SoftReference<BufferedImage>(thumbnail);
        return thumbnail;
    }

    @Override
    public int getWidth() throws IOException {
        switch (this.segment.extensionCode) {
            case 17: 
            case 19: {
                return this.segment.thumbnail[0] & 0xFF;
            }
            case 16: {
                return this.readJPEGCached(false).getWidth();
            }
        }
        throw new IIOException(String.format("Unsupported JFXX extension code: %d", this.segment.extensionCode));
    }

    @Override
    public int getHeight() throws IOException {
        switch (this.segment.extensionCode) {
            case 17: 
            case 19: {
                return this.segment.thumbnail[1] & 0xFF;
            }
            case 16: {
                return this.readJPEGCached(false).getHeight();
            }
        }
        throw new IIOException(String.format("Unsupported JFXX extension code: %d", this.segment.extensionCode));
    }

    private BufferedImage readIndexed() {
        int w = this.segment.thumbnail[0] & 0xFF;
        int h = this.segment.thumbnail[1] & 0xFF;
        int[] rgbs = new int[256];
        for (int i = 0; i < rgbs.length; ++i) {
            rgbs[i] = (this.segment.thumbnail[3 * i + 2] & 0xFF) << 16 | (this.segment.thumbnail[3 * i + 3] & 0xFF) << 8 | this.segment.thumbnail[3 * i + 4] & 0xFF;
        }
        InverseColorMapIndexColorModel icm = new InverseColorMapIndexColorModel(8, rgbs.length, rgbs, 0, false, -1, 0);
        DataBufferByte buffer = new DataBufferByte(this.segment.thumbnail, this.segment.thumbnail.length - 770, 770);
        WritableRaster raster = Raster.createPackedRaster(buffer, w, h, 8, null);
        return new BufferedImage(icm, raster, icm.isAlphaPremultiplied(), null);
    }

    private BufferedImage readRGB() {
        int w = this.segment.thumbnail[0] & 0xFF;
        int h = this.segment.thumbnail[1] & 0xFF;
        return ThumbnailReader.readRawThumbnail(this.segment.thumbnail, this.segment.thumbnail.length - 2, 2, w, h);
    }
}

