/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.JPEGImageReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

class JFXXSegment {
    public static final int JPEG = 16;
    public static final int INDEXED = 17;
    public static final int RGB = 19;
    final int extensionCode;
    final byte[] thumbnail;

    private JFXXSegment(int extensionCode, byte[] thumbnail) {
        this.extensionCode = extensionCode;
        this.thumbnail = thumbnail;
    }

    public String toString() {
        return String.format("JFXX extension (%s thumb size: %d)", this.extensionAsString(), this.thumbnail.length);
    }

    private String extensionAsString() {
        switch (this.extensionCode) {
            case 16: {
                return "JPEG";
            }
            case 17: {
                return "Indexed";
            }
            case 19: {
                return "RGB";
            }
        }
        return String.valueOf(this.extensionCode);
    }

    public static JFXXSegment read(InputStream data, int length) throws IOException {
        DataInputStream stream = new DataInputStream(data);
        return new JFXXSegment(stream.readUnsignedByte(), JPEGImageReader.readFully(stream, length - 1));
    }
}

