/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.Validate;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;

class IIOInputStreamAdapter
extends InputStream {
    private ImageInputStream input;
    private final boolean hasLength;
    private long left;
    private long markPosition;

    public IIOInputStreamAdapter(ImageInputStream pInput) {
        this(pInput, -1L, false);
    }

    public IIOInputStreamAdapter(ImageInputStream pInput, long pLength) {
        this(pInput, pLength, true);
    }

    private IIOInputStreamAdapter(ImageInputStream pInput, long pLength, boolean pHasLength) {
        Validate.notNull(pInput, "stream");
        Validate.isTrue(!pHasLength || pLength >= 0L, pLength, "length < 0: %f");
        this.input = pInput;
        this.left = pLength;
        this.hasLength = pHasLength;
    }

    @Override
    public void close() throws IOException {
        if (this.hasLength) {
            this.input.seek(this.input.getStreamPosition() + this.left);
        }
        this.left = 0L;
        this.input = null;
    }

    @Override
    public int available() throws IOException {
        if (this.hasLength) {
            return this.left > 0L ? (int)Math.min(Integer.MAX_VALUE, this.left) : 0;
        }
        return 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int pReadLimit) {
        try {
            this.markPosition = this.input.getStreamPosition();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read stream position: " + e.getMessage(), e);
        }
    }

    @Override
    public void reset() throws IOException {
        long diff = this.input.getStreamPosition() - this.markPosition;
        this.input.seek(this.markPosition);
        this.left += diff;
    }

    @Override
    public int read() throws IOException {
        if (this.hasLength && this.left-- <= 0L) {
            this.left = 0L;
            return -1;
        }
        return this.input.read();
    }

    @Override
    public final int read(byte[] pBytes) throws IOException {
        return this.read(pBytes, 0, pBytes.length);
    }

    @Override
    public int read(byte[] pBytes, int pOffset, int pLength) throws IOException {
        if (this.hasLength && this.left <= 0L) {
            return -1;
        }
        int read = this.input.read(pBytes, pOffset, (int)this.findMaxLen(pLength));
        if (this.hasLength) {
            this.left = read < 0 ? 0L : this.left - (long)read;
        }
        return read;
    }

    private long findMaxLen(long pLength) {
        if (this.hasLength && this.left < pLength) {
            return Math.max(this.left, 0L);
        }
        return Math.max(pLength, 0L);
    }

    @Override
    public long skip(long pLength) throws IOException {
        long skipped = this.input.skipBytes(this.findMaxLen(pLength));
        this.left -= skipped;
        return skipped;
    }
}

