/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import java.awt.image.RGBImageFilter;

public class GrayFilter
extends RGBImageFilter {
    private int low;
    private float range;

    public GrayFilter() {
        this.canFilterIndexColorModel = true;
        this.low = 0;
        this.range = 1.0f;
    }

    public GrayFilter(float pLow, float pHigh) {
        this.canFilterIndexColorModel = true;
        this.low = 0;
        this.range = 1.0f;
        if (pLow > pHigh) {
            pLow = 0.0f;
        }
        if (pLow < 0.0f) {
            pLow = 0.0f;
        } else if (pLow > 1.0f) {
            pLow = 1.0f;
        }
        if (pHigh < 0.0f) {
            pHigh = 0.0f;
        } else if (pHigh > 1.0f) {
            pHigh = 1.0f;
        }
        this.low = (int)(pLow * 255.0f);
        this.range = pHigh - pLow;
    }

    public GrayFilter(int pLow, int pHigh) {
        this((float)pLow / 255.0f, (float)pHigh / 255.0f);
    }

    @Override
    public int filterRGB(int pX, int pY, int pARGB) {
        int r = pARGB >> 16 & 0xFF;
        int g = pARGB >> 8 & 0xFF;
        int b = pARGB & 0xFF;
        int gray = (222 * r + 707 * g + 71 * b) / 1000;
        if (this.range != 1.0f) {
            gray = this.low + (int)((float)gray * this.range);
        }
        return pARGB & 0xFF000000 | gray << 16 | gray << 8 | gray;
    }
}

