/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.Validate;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

class FastCMYKToRGB
implements RasterOp {
    @Override
    public WritableRaster filter(Raster src, WritableRaster dest) {
        Validate.notNull(src, "src may not be null");
        Validate.isTrue(src != dest, "src and dest raster may not be same");
        Validate.isTrue(src.getTransferType() == 0, src, "only TYPE_BYTE rasters supported as src: %s");
        Validate.isTrue(src.getNumDataElements() >= 4, src.getNumDataElements(), "CMYK raster must have at least 4 data elements: %s");
        if (dest == null) {
            dest = this.createCompatibleDestRaster(src);
        } else {
            Validate.isTrue(dest.getTransferType() == 0 && dest.getNumDataElements() >= 3 || dest.getTransferType() == 3 && dest.getNumDataElements() == 1, src, "only 3 or 4 byte TYPE_BYTE or 1 int TYPE_INT rasters supported as dest: %s");
        }
        int height = src.getHeight();
        int width = src.getWidth();
        byte[] in = new byte[src.getNumDataElements()];
        if (dest.getTransferType() == 0) {
            byte[] out = new byte[dest.getNumDataElements()];
            if (out.length > 3) {
                out[3] = -1;
            }
            for (int y = dest.getMinY(); y < height; ++y) {
                for (int x = dest.getMinX(); x < width; ++x) {
                    src.getDataElements(x, y, in);
                    this.convertCMYKToRGB(in, out);
                    dest.setDataElements(x, y, out);
                }
            }
        } else if (dest.getTransferType() == 3) {
            int[] out = new int[dest.getNumDataElements()];
            byte[] temp = new byte[3];
            SampleModel sm = dest.getSampleModel();
            int[] bitOffsets = sm instanceof SinglePixelPackedSampleModel ? ((SinglePixelPackedSampleModel)sm).getBitOffsets() : new int[]{0, 8, 16};
            int alpha = bitOffsets.length > 3 ? 255 : 0;
            for (int y = dest.getMinY(); y < height; ++y) {
                for (int x = dest.getMinX(); x < width; ++x) {
                    src.getDataElements(x, y, in);
                    this.convertCMYKToRGB(in, temp);
                    out[0] = alpha << 24 | (temp[0] & 0xFF) << bitOffsets[0] | (temp[1] & 0xFF) << bitOffsets[1] | (temp[2] & 0xFF) << bitOffsets[2];
                    dest.setDataElements(x, y, out);
                }
            }
        } else {
            throw new AssertionError();
        }
        return dest;
    }

    private void convertCMYKToRGB(byte[] cmyk, byte[] rgb) {
        int k = cmyk[3] & 0xFF;
        rgb[0] = (byte)(255 - ((cmyk[0] & 0xFF) * (255 - k) / 255 + k));
        rgb[1] = (byte)(255 - ((cmyk[1] & 0xFF) * (255 - k) / 255 + k));
        rgb[2] = (byte)(255 - ((cmyk[2] & 0xFF) * (255 - k) / 255 + k));
    }

    @Override
    public Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster src) {
        WritableRaster raster = src.createCompatibleWritableRaster();
        return raster.createWritableChild(0, 0, src.getWidth(), src.getHeight(), 0, 0, new int[]{0, 1, 2});
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Double(srcPt.getX(), srcPt.getY());
        } else {
            dstPt.setLocation(srcPt);
        }
        return dstPt;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }
}

