/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import java.awt.color.ColorSpace;

final class CMYKColorSpace
extends ColorSpace {
    static final ColorSpace INSTANCE = new CMYKColorSpace();
    final ColorSpace sRGB = CMYKColorSpace.getInstance(1000);

    private CMYKColorSpace() {
        super(9, 4);
    }

    public static ColorSpace getInstance() {
        return INSTANCE;
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        return new float[]{(1.0f - colorvalue[0]) * (1.0f - colorvalue[3]), (1.0f - colorvalue[1]) * (1.0f - colorvalue[3]), (1.0f - colorvalue[2]) * (1.0f - colorvalue[3])};
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        float c = 1.0f - rgbvalue[0];
        float m = 1.0f - rgbvalue[1];
        float y = 1.0f - rgbvalue[2];
        float k = Math.min(c, Math.min(m, y));
        return new float[]{c - k, m - k, y - k, k};
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        return this.sRGB.toCIEXYZ(this.toRGB(colorvalue));
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        return this.sRGB.fromCIEXYZ(this.fromRGB(colorvalue));
    }
}

