/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.crypto;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.StringUtils;
import com.aliyun.oss.crypto.ContentCryptoMaterialRW;
import com.aliyun.oss.crypto.CryptoRuntime;
import com.aliyun.oss.crypto.EncryptionMaterials;
import java.lang.reflect.Field;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class SimpleRSAEncryptionMaterials
implements EncryptionMaterials {
    public static final String KEY_WRAP_ALGORITHM = "RSA/NONE/PKCS1Padding";
    private KeyPair keyPair;
    private Map<String, String> desc;
    private final LinkedHashMap<KeyPair, Map<String, String>> keyPairDescMaterials = new LinkedHashMap();

    public SimpleRSAEncryptionMaterials(KeyPair keyPair) {
        this.assertParameterNotNull(keyPair, "KeyPair");
        this.keyPair = keyPair;
        this.desc = new HashMap<String, String>();
        this.keyPairDescMaterials.put(keyPair, this.desc);
    }

    public SimpleRSAEncryptionMaterials(KeyPair keyPair, Map<String, String> desc) {
        this.assertParameterNotNull(keyPair, "KeyPair");
        this.keyPair = keyPair;
        this.desc = desc == null ? new HashMap<String, String>() : new HashMap<String, String>(desc);
        this.keyPairDescMaterials.put(keyPair, desc);
    }

    public synchronized void addKeyPairDescMaterial(KeyPair keyPair, Map<String, String> description) {
        this.assertParameterNotNull(keyPair, "keyPair");
        if (description != null) {
            this.keyPairDescMaterials.put(keyPair, new HashMap<String, String>(description));
        } else {
            this.keyPairDescMaterials.put(keyPair, new HashMap());
        }
    }

    private KeyPair findKeyPairByDescription(Map<String, String> desc) {
        if (desc == null) {
            return null;
        }
        for (Map.Entry<KeyPair, Map<String, String>> entry : this.keyPairDescMaterials.entrySet()) {
            if (!desc.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private <K, V> Map.Entry<K, V> getTailByReflection(LinkedHashMap<K, V> map) throws NoSuchFieldException, IllegalAccessException {
        Field tail = map.getClass().getDeclaredField("tail");
        tail.setAccessible(true);
        return (Map.Entry)tail.get(map);
    }

    @Override
    public void encryptCEK(ContentCryptoMaterialRW contentMaterialRW) {
        this.assertParameterNotNull(contentMaterialRW, "ContentCryptoMaterialRW");
        this.assertParameterNotNull(contentMaterialRW.getCEK(), "ContentCryptoMaterialRW#getCEK()");
        this.assertParameterNotNull(contentMaterialRW.getIV(), "ContentCryptoMaterialRW#getIV()");
        try {
            PublicKey key = this.keyPair.getPublic();
            Cipher cipher = Cipher.getInstance(KEY_WRAP_ALGORITHM);
            cipher.init(1, (Key)key, new SecureRandom());
            byte[] encryptedCEK = cipher.doFinal(contentMaterialRW.getCEK().getEncoded());
            byte[] encryptedIV = cipher.doFinal(contentMaterialRW.getIV());
            contentMaterialRW.setEncryptedCEK(encryptedCEK);
            contentMaterialRW.setEncryptedIV(encryptedIV);
            contentMaterialRW.setKeyWrapAlgorithm(KEY_WRAP_ALGORITHM);
            contentMaterialRW.setMaterialsDescription(this.desc);
        }
        catch (Exception e) {
            throw new ClientException("Unable to encrypt content encryption key or iv." + e.getMessage(), e);
        }
    }

    @Override
    public void decryptCEK(ContentCryptoMaterialRW contentMaterialRW) {
        this.assertParameterNotNull(contentMaterialRW, "ContentCryptoMaterialRW");
        this.assertParameterNotNull(contentMaterialRW.getEncryptedCEK(), "ContentCryptoMaterialRW#getEncryptedCEK");
        this.assertParameterNotNull(contentMaterialRW.getEncryptedIV(), "ContentCryptoMaterialRW#getEncryptedIV");
        this.assertParameterNotNull(contentMaterialRW.getKeyWrapAlgorithm(), "ContentCryptoMaterialRW#getKeyWrapAlgorithm");
        if (!contentMaterialRW.getKeyWrapAlgorithm().toLowerCase().equals(KEY_WRAP_ALGORITHM.toLowerCase())) {
            throw new ClientException("Unrecognize your object key wrap algorithm: " + contentMaterialRW.getKeyWrapAlgorithm());
        }
        try {
            KeyPair keyPair = this.findKeyPairByDescription(contentMaterialRW.getMaterialsDescription());
            if (keyPair == null) {
                Map.Entry<KeyPair, Map<String, String>> entry = this.getTailByReflection(this.keyPairDescMaterials);
                keyPair = entry.getKey();
            }
            PrivateKey key = keyPair.getPrivate();
            Cipher cipher = Cipher.getInstance(KEY_WRAP_ALGORITHM);
            cipher.init(2, key);
            byte[] cekBytes = cipher.doFinal(contentMaterialRW.getEncryptedCEK());
            byte[] iv = cipher.doFinal(contentMaterialRW.getEncryptedIV());
            SecretKeySpec cek = new SecretKeySpec(cekBytes, "");
            contentMaterialRW.setCEK(cek);
            contentMaterialRW.setIV(iv);
        }
        catch (Exception e) {
            throw new ClientException("Unable to decrypt the secured content key and iv. " + e.getMessage(), e);
        }
    }

    public static RSAPrivateKey getPrivateKeyFromPemPKCS1(String privateKeyStr) {
        try {
            String adjustStr = StringUtils.replace(privateKeyStr, "-----BEGIN PRIVATE KEY-----", "");
            adjustStr = StringUtils.replace(adjustStr, "-----BEGIN RSA PRIVATE KEY-----", "");
            adjustStr = StringUtils.replace(adjustStr, "-----END PRIVATE KEY-----", "");
            adjustStr = StringUtils.replace(adjustStr, "-----END RSA PRIVATE KEY-----", "");
            adjustStr = adjustStr.replace("\n", "");
            CryptoRuntime.enableBouncyCastle();
            byte[] buffer = BinaryUtil.fromBase64String(adjustStr);
            RSAPrivateKeySpec keySpec = CryptoRuntime.convertPemPKCS1ToPrivateKey(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new ClientException("get private key from PKCS1 pem String error." + e.getMessage(), e);
        }
    }

    public static RSAPrivateKey getPrivateKeyFromPemPKCS8(String privateKeyStr) {
        try {
            String adjustStr = StringUtils.replace(privateKeyStr, "-----BEGIN PRIVATE KEY-----", "");
            adjustStr = StringUtils.replace(adjustStr, "-----BEGIN RSA PRIVATE KEY-----", "");
            adjustStr = StringUtils.replace(adjustStr, "-----END PRIVATE KEY-----", "");
            adjustStr = StringUtils.replace(adjustStr, "-----END RSA PRIVATE KEY-----", "");
            adjustStr = adjustStr.replace("\n", "");
            byte[] buffer = BinaryUtil.fromBase64String(adjustStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new ClientException("Get private key from PKCS8 pem String error: " + e.getMessage(), e);
        }
    }

    public static RSAPublicKey getPublicKeyFromPemX509(String publicKeyStr) {
        try {
            String adjustStr = StringUtils.replace(publicKeyStr, "-----BEGIN PUBLIC KEY-----", "");
            adjustStr = StringUtils.replace(adjustStr, "-----BEGIN RSA PUBLIC KEY-----", "");
            adjustStr = StringUtils.replace(adjustStr, "-----END PUBLIC KEY-----", "");
            adjustStr = StringUtils.replace(adjustStr, "-----END RSA PUBLIC KEY-----", "");
            adjustStr = adjustStr.replace("\n", "");
            byte[] buffer = BinaryUtil.fromBase64String(adjustStr);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new ClientException("Get public key from X509 pem String error." + e.getMessage(), e);
        }
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    static {
        CryptoRuntime.enableBouncyCastle();
    }
}

