/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ProcessHandle;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ThreadFactoryImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.ChannelEventListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.InvokeCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RemotingServer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.Pair;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.TlsMode;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingSendRequestException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.FileRegionEncoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.MqDefaultMessageSizeEstimator;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyDecoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyEncoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyEvent;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyEventType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingAbstract;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRequestProcessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyServerConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.TlsHelper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.TlsSystemConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.TrafficCodeDistributionCollectionHandler;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.protocol.ProtocolNegotiationHandler;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.protocol.http2proxy.Http2ProtocolProxyHandler;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.protocol.remoting.RemotingProtocolHandler;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommandType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.vtoa.VpcTunnelUtils;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.vtoa.Vtoa;
import com.aliyun.openservices.shade.io.netty.bootstrap.ServerBootstrap;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.PooledByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelDuplexHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelInitializer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPipeline;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.channel.SimpleChannelInboundHandler;
import com.aliyun.openservices.shade.io.netty.channel.WriteBufferWaterMark;
import com.aliyun.openservices.shade.io.netty.channel.epoll.Epoll;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollEventLoopGroup;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollServerSocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.nio.NioEventLoopGroup;
import com.aliyun.openservices.shade.io.netty.channel.socket.SocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.NioServerSocketChannel;
import com.aliyun.openservices.shade.io.netty.handler.timeout.IdleState;
import com.aliyun.openservices.shade.io.netty.handler.timeout.IdleStateEvent;
import com.aliyun.openservices.shade.io.netty.handler.timeout.IdleStateHandler;
import com.aliyun.openservices.shade.io.netty.util.concurrent.DefaultEventExecutorGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NettyRemotingServer
extends NettyRemotingAbstract
implements RemotingServer {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private static final InternalLogger TRAFFIC_LOGGER = InternalLoggerFactory.getLogger("RocketmqTraffic");
    private final ServerBootstrap serverBootstrap;
    private final EventLoopGroup eventLoopGroupSelector;
    private final EventLoopGroup eventLoopGroupBoss;
    private final NettyServerConfig nettyServerConfig;
    private final ExecutorService publicExecutor;
    private final ChannelEventListener channelEventListener;
    private final Timer timer = new Timer("ServerHouseKeepingService", true);
    private DefaultEventExecutorGroup defaultEventExecutorGroup;
    private final List<RPCHook> rpcHookList = new CopyOnWriteArrayList<RPCHook>();
    private final ConcurrentHashMap<Channel, Vtoa> tunnelTable = new ConcurrentHashMap(16);
    private int port = 0;
    private static final String HANDSHAKE_HANDLER_NAME = "handshakeHandler";
    private static final String TLS_HANDLER_NAME = "sslHandler";
    private static final String FILE_REGION_ENCODER_NAME = "fileRegionEncoder";
    private final ScheduledExecutorService scheduledExecutorService;
    private final TrafficCodeDistributionCollectionHandler trafficCodeDistributionCollectionHandler;
    private int pid;

    public NettyRemotingServer(NettyServerConfig nettyServerConfig) {
        this(nettyServerConfig, null);
    }

    public NettyRemotingServer(NettyServerConfig nettyServerConfig, ChannelEventListener channelEventListener) {
        super(nettyServerConfig.getServerOnewaySemaphoreValue(), nettyServerConfig.getServerAsyncSemaphoreValue());
        this.serverBootstrap = new ServerBootstrap();
        this.nettyServerConfig = nettyServerConfig;
        this.channelEventListener = channelEventListener;
        int publicThreadNums = nettyServerConfig.getServerCallbackExecutorThreads();
        if (publicThreadNums <= 0) {
            publicThreadNums = 4;
        }
        this.publicExecutor = new ThreadPoolExecutor(publicThreadNums, publicThreadNums, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(), new ThreadFactoryImpl("NettyServerPublicExecutor_"), new ThreadPoolExecutor.CallerRunsPolicy());
        this.eventLoopGroupBoss = new NioEventLoopGroup(1, new ThreadFactoryImpl("NettyBoss_"));
        this.eventLoopGroupSelector = this.useEpoll() ? new EpollEventLoopGroup(nettyServerConfig.getServerSelectorThreads(), new ThreadFactoryImpl("NettyServerEPOLLSelector_")) : new NioEventLoopGroup(nettyServerConfig.getServerSelectorThreads(), new ThreadFactoryImpl("NettyServerNIOSelector_"));
        this.loadSslContext();
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactoryImpl("NettyServerScheduler_"), new ThreadPoolExecutor.DiscardOldestPolicy());
        this.trafficCodeDistributionCollectionHandler = new TrafficCodeDistributionCollectionHandler();
        this.pid = -1;
    }

    public void loadSslContext() {
        TlsMode tlsMode = TlsSystemConfig.tlsMode;
        log.info("Server is running in TLS {} mode", (Object)tlsMode.getName());
        if (tlsMode != TlsMode.DISABLED) {
            try {
                this.sslContext = TlsHelper.buildSslContext(false);
                log.info("SSLContext created for server");
            }
            catch (CertificateException e) {
                log.error("Failed to create SSLContext for server", e);
            }
            catch (IOException e) {
                log.error("Failed to create SSLContext for server", e);
            }
        }
    }

    private boolean useEpoll() {
        return RemotingUtil.isLinuxPlatform() && this.nettyServerConfig.isUseEpollNativeSelector() && Epoll.isAvailable();
    }

    private void logTrafficCodeDistribution() {
        this.logDistribution("RequestCode Distribution", this.trafficCodeDistributionCollectionHandler.inboundDistribution());
        this.logDistribution("ResponseCode Distribution", this.trafficCodeDistributionCollectionHandler.outboundDistribution());
    }

    private void logDistribution(String title, Map<Integer, Long> distribution) {
        if (null != distribution && !distribution.isEmpty()) {
            StringBuilder sb = new StringBuilder(title);
            sb.append(": [");
            boolean first = true;
            for (Map.Entry<Integer, Long> entry : distribution.entrySet()) {
                if (0L == entry.getValue()) continue;
                if (!first) {
                    sb.append(", ");
                }
                sb.append(entry.getKey()).append(":").append(entry.getValue());
                first = false;
            }
            if (first) {
                return;
            }
            sb.append("]");
            if (this.pid < 0) {
                this.pid = ProcessHandle.pid();
            }
            TRAFFIC_LOGGER.info("ProcessID={}, {}", (Object)this.pid, (Object)sb.toString());
        }
    }

    @Override
    public void start() {
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyServerConfig.getServerWorkerThreads(), new ThreadFactoryImpl("NettyServerCodecThread_"));
        WriteBufferWaterMark writeBufferWaterMark = new WriteBufferWaterMark(this.nettyServerConfig.getWriteBufferLowWaterMark(), this.nettyServerConfig.getWriteBufferHighWaterMark());
        ServerBootstrap childHandler = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.eventLoopGroupBoss, this.eventLoopGroupSelector).channel(this.useEpoll() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, 1024)).option(ChannelOption.SO_REUSEADDR, true)).childOption(ChannelOption.SO_KEEPALIVE, false).childOption(ChannelOption.TCP_NODELAY, true).childOption(ChannelOption.SO_SNDBUF, this.nettyServerConfig.getServerSocketSndBufSize()).childOption(ChannelOption.SO_RCVBUF, this.nettyServerConfig.getServerSocketRcvBufSize()).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, writeBufferWaterMark).childOption(ChannelOption.MESSAGE_SIZE_ESTIMATOR, MqDefaultMessageSizeEstimator.DEFAULT).localAddress(new InetSocketAddress(this.nettyServerConfig.getListenPort()))).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) {
                ChannelPipeline channelPipelineWithTls = ch.pipeline().addLast((EventExecutorGroup)NettyRemotingServer.this.defaultEventExecutorGroup, NettyRemotingServer.HANDSHAKE_HANDLER_NAME, (ChannelHandler)new HandshakeHandler(TlsSystemConfig.tlsMode));
                if (NettyRemotingServer.this.nettyServerConfig.isEnableProtocolNegotiation()) {
                    channelPipelineWithTls.addLast((EventExecutorGroup)NettyRemotingServer.this.defaultEventExecutorGroup, new IdleStateHandler(0, 0, NettyRemotingServer.this.nettyServerConfig.getServerChannelMaxIdleTimeSeconds()), new ProtocolNegotiationHandler(new RemotingProtocolHandler(NettyRemotingServer.this)).addProtocolHandler(new Http2ProtocolProxyHandler(NettyRemotingServer.this.nettyServerConfig)));
                } else {
                    channelPipelineWithTls.addLast((EventExecutorGroup)NettyRemotingServer.this.defaultEventExecutorGroup, new NettyEncoder(), new NettyDecoder(), NettyRemotingServer.this.trafficCodeDistributionCollectionHandler, new IdleStateHandler(0, 0, NettyRemotingServer.this.nettyServerConfig.getServerChannelMaxIdleTimeSeconds()), new NettyConnectManageHandler(), new NettyServerHandler());
                }
            }
        });
        if (this.nettyServerConfig.isServerPooledByteBufAllocatorEnable()) {
            childHandler.childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        }
        try {
            ChannelFuture sync = this.serverBootstrap.bind().sync();
            InetSocketAddress addr = (InetSocketAddress)sync.channel().localAddress();
            this.port = addr.getPort();
        }
        catch (InterruptedException e1) {
            throw new RuntimeException("this.serverBootstrap.bind().sync() InterruptedException", e1);
        }
        if (this.channelEventListener != null) {
            this.nettyEventExecutor.start();
        }
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    NettyRemotingServer.this.scanResponseTable();
                }
                catch (Throwable e) {
                    log.error("scanResponseTable exception", e);
                }
            }
        }, 3000L, 1000L);
        this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    NettyRemotingServer.this.logTrafficCodeDistribution();
                }
                catch (Throwable e) {
                    log.error("Unexpected exception raised while log response code distribution", e);
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void shutdown() {
        try {
            this.timer.cancel();
            this.eventLoopGroupBoss.shutdownGracefully();
            this.eventLoopGroupSelector.shutdownGracefully();
            this.nettyEventExecutor.shutdown();
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.error("NettyRemotingServer shutdown exception, ", e);
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
            }
            catch (Exception e) {
                log.error("NettyRemotingServer shutdown exception, ", e);
            }
        }
    }

    @Override
    public void registerRPCHook(RPCHook rpcHook) {
        this.rpcHookList.add(rpcHook);
    }

    @Override
    public void registerProcessor(int requestCode, NettyRequestProcessor processor, ExecutorService executor) {
        ExecutorService executorThis = executor;
        if (null == executor) {
            executorThis = this.publicExecutor;
        }
        Pair<NettyRequestProcessor, ExecutorService> pair = new Pair<NettyRequestProcessor, ExecutorService>(processor, executorThis);
        this.processorTable.put(requestCode, pair);
    }

    @Override
    public void registerDefaultProcessor(NettyRequestProcessor processor, ExecutorService executor) {
        this.defaultRequestProcessor = new Pair<NettyRequestProcessor, ExecutorService>(processor, executor);
    }

    @Override
    public int localListenPort() {
        return this.port;
    }

    @Override
    public Pair<NettyRequestProcessor, ExecutorService> getProcessorPair(int requestCode) {
        return (Pair)this.processorTable.get(requestCode);
    }

    @Override
    public Pair<NettyRequestProcessor, ExecutorService> getDefaultProcessorPair() {
        return this.defaultRequestProcessor;
    }

    @Override
    public RemotingCommand invokeSync(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingSendRequestException, RemotingTimeoutException {
        return this.invokeSyncImpl(channel, request, timeoutMillis);
    }

    @Override
    public void invokeAsync(Channel channel, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        this.invokeAsyncImpl(channel, request, timeoutMillis, invokeCallback);
    }

    @Override
    public void invokeOneway(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        request.markOnewayRPC();
        this.invokeOnewayImpl(channel, request, timeoutMillis);
    }

    @Override
    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    @Override
    public List<RPCHook> getRPCHook() {
        return this.rpcHookList;
    }

    @Override
    public ExecutorService getCallbackExecutor() {
        return this.publicExecutor;
    }

    public TrafficCodeDistributionCollectionHandler getTrafficCodeDistributionCollectionHandler() {
        return this.trafficCodeDistributionCollectionHandler;
    }

    public NettyServerHandler newNettyServerHandler() {
        return new NettyServerHandler();
    }

    public NettyConnectManageHandler newNettyConnectManageHandler() {
        return new NettyConnectManageHandler();
    }

    class NettyConnectManageHandler
    extends ChannelDuplexHandler {
        NettyConnectManageHandler() {
        }

        @Override
        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("NETTY SERVER PIPELINE: channelRegistered {}", (Object)remoteAddress);
            if (NettyRemotingServer.this.nettyServerConfig.isAttachVtoaInfoEnable()) {
                NettyRemotingServer.this.tunnelTable.put(ctx.channel(), VpcTunnelUtils.getInstance().getVtoa(ctx));
            }
            super.channelRegistered(ctx);
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("NETTY SERVER PIPELINE: channelUnregistered, the channel[{}]", (Object)remoteAddress);
            if (NettyRemotingServer.this.nettyServerConfig.isAttachVtoaInfoEnable()) {
                NettyRemotingServer.this.tunnelTable.remove(ctx.channel());
            }
            super.channelUnregistered(ctx);
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("NETTY SERVER PIPELINE: channelActive, the channel[{}]", (Object)remoteAddress);
            super.channelActive(ctx);
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.CONNECT, remoteAddress, ctx.channel()));
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("NETTY SERVER PIPELINE: channelInactive, the channel[{}]", (Object)remoteAddress);
            super.channelInactive(ctx);
            if (NettyRemotingServer.this.nettyServerConfig.isAttachVtoaInfoEnable()) {
                NettyRemotingServer.this.tunnelTable.remove(ctx.channel());
            }
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress, ctx.channel()));
            }
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            IdleStateEvent event;
            if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                log.warn("NETTY SERVER PIPELINE: IDLE exception [{}]", (Object)remoteAddress);
                RemotingUtil.closeChannel(ctx.channel());
                if (NettyRemotingServer.this.nettyServerConfig.isAttachVtoaInfoEnable()) {
                    NettyRemotingServer.this.tunnelTable.remove(ctx.channel());
                }
                if (NettyRemotingServer.this.channelEventListener != null) {
                    NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.IDLE, remoteAddress, ctx.channel()));
                }
            }
            ctx.fireUserEventTriggered(evt);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.warn("NETTY SERVER PIPELINE: exceptionCaught {}", (Object)remoteAddress);
            log.warn("NETTY SERVER PIPELINE: exceptionCaught exception.", cause);
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.EXCEPTION, remoteAddress, ctx.channel()));
            }
            if (NettyRemotingServer.this.nettyServerConfig.isAttachVtoaInfoEnable()) {
                NettyRemotingServer.this.tunnelTable.remove(ctx.channel());
            }
            RemotingUtil.closeChannel(ctx.channel());
        }
    }

    class NettyServerHandler
    extends SimpleChannelInboundHandler<RemotingCommand> {
        NettyServerHandler() {
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, RemotingCommand msg) throws Exception {
            this.processTunnelId(ctx, msg);
            NettyRemotingServer.this.processMessageReceived(ctx, msg);
        }

        public void processTunnelId(ChannelHandlerContext ctx, RemotingCommand msg) {
            if (NettyRemotingServer.this.nettyServerConfig.isAttachVtoaInfoEnable() && null != msg && msg.getType() == RemotingCommandType.REQUEST_COMMAND) {
                Vtoa vtoa = (Vtoa)NettyRemotingServer.this.tunnelTable.get(ctx.channel());
                if (null == vtoa) {
                    vtoa = VpcTunnelUtils.getInstance().getVtoa(ctx);
                    NettyRemotingServer.this.tunnelTable.put(ctx.channel(), vtoa);
                }
                msg.addExtField("VTOA_TUNNEL_ID", String.valueOf(vtoa.getVid()));
                msg.addExtField("VTOA_CLIENT_ADDR", String.valueOf(vtoa.getVaddr()));
                msg.addExtField("VTOA_CLIENT_PORT", String.valueOf(vtoa.getVport()));
            }
        }

        @Override
        public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
            Channel channel = ctx.channel();
            if (channel.isWritable()) {
                if (!channel.config().isAutoRead()) {
                    channel.config().setAutoRead(true);
                    log.info("Channel[{}] turns writable, bytes to buffer before changing channel to un-writable: {}", (Object)RemotingHelper.parseChannelRemoteAddr(channel), (Object)channel.bytesBeforeUnwritable());
                }
            } else {
                channel.config().setAutoRead(false);
                log.warn("Auto-read of channel[{}] is disabled! Bytes to drain before it turns writable: {}", (Object)RemotingHelper.parseChannelRemoteAddr(channel), (Object)channel.bytesBeforeWritable());
            }
            super.channelWritabilityChanged(ctx);
        }
    }

    class HandshakeHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final TlsMode tlsMode;
        private static final byte HANDSHAKE_MAGIC_CODE = 22;

        HandshakeHandler(TlsMode tlsMode) {
            this.tlsMode = tlsMode;
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
            msg.markReaderIndex();
            byte b = msg.getByte(0);
            if (b == 22) {
                switch (this.tlsMode) {
                    case DISABLED: {
                        ctx.close();
                        log.warn("Clients intend to establish a SSL connection while this server is running in SSL disabled mode");
                        break;
                    }
                    case PERMISSIVE: 
                    case ENFORCING: {
                        if (null != NettyRemotingServer.this.sslContext) {
                            ctx.pipeline().addAfter(NettyRemotingServer.this.defaultEventExecutorGroup, NettyRemotingServer.HANDSHAKE_HANDLER_NAME, NettyRemotingServer.TLS_HANDLER_NAME, NettyRemotingServer.this.sslContext.newHandler(ctx.channel().alloc())).addAfter(NettyRemotingServer.this.defaultEventExecutorGroup, NettyRemotingServer.TLS_HANDLER_NAME, NettyRemotingServer.FILE_REGION_ENCODER_NAME, new FileRegionEncoder());
                            log.info("Handlers prepended to channel pipeline to establish SSL connection");
                            break;
                        }
                        ctx.close();
                        log.error("Trying to establish a SSL connection but sslContext is null");
                        break;
                    }
                    default: {
                        log.warn("Unknown TLS mode");
                        break;
                    }
                }
            } else if (this.tlsMode == TlsMode.ENFORCING) {
                ctx.close();
                log.warn("Clients intend to establish an insecure connection while this server is running in SSL enforcing mode");
            }
            msg.resetReaderIndex();
            try {
                ctx.pipeline().remove(this);
            }
            catch (NoSuchElementException e) {
                log.error("Error while removing HandshakeHandler", e);
            }
            ctx.fireChannelRead(msg.retain());
        }
    }
}

