/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.ordermessage;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.CommunicationMode;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.TopicPublishInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.MQFaultStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.google.common.base.Joiner;
import com.aliyun.openservices.shade.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class OrderMessageHandler {
    private MQClientInstance client;
    private String topic;
    private TopicPublishInfo info;
    private MQFaultStrategy mqFaultStrategy;
    private final InternalLogger log = ClientLogger.getLog();

    public OrderMessageHandler(MQClientInstance client, String topic, TopicPublishInfo info, MQFaultStrategy mqFaultStrategy) {
        this.client = client;
        this.topic = topic;
        Preconditions.checkNotNull(info);
        this.info = info;
        this.mqFaultStrategy = mqFaultStrategy;
    }

    public MessageQueue selectOneMessageQueue(MessageQueue mq, String lastBrokerName) {
        boolean remoteFaultTolerance = this.client.getRemoteClientConfig().getRemoteFaultTolerance();
        MessageQueue targetMQ = this.mqFaultStrategy.selectOneMessageQueue(this.info, mq.getQueueGroupId(), lastBrokerName, remoteFaultTolerance);
        if (targetMQ == null) {
            targetMQ = mq;
        }
        return targetMQ;
    }

    public List<MessageQueue> generatePublishMessageQueueList() {
        List<MessageQueue> messageQueueList = this.generateMessageQueueList();
        return this.client.getMQAdminImpl().parsePublishMessageQueues(messageQueueList);
    }

    public void writeMQOffsetToMessage(String topic, int queueGroupId, Message msg) {
        List<MessageQueue> queueList = this.info.getQueueListMap().get(queueGroupId);
        ConcurrentMap<String, Long> offsetTable = this.client.findQueueOffsetTable(topic);
        ArrayList<String> queueGroupSnapshot = new ArrayList<String>();
        if (offsetTable != null) {
            for (MessageQueue mq : queueList) {
                long offset = -1L;
                Long newOffset = (Long)offsetTable.get(mq.generateKey());
                if (newOffset != null) {
                    offset = newOffset;
                }
                MessageAccessor.putHAOrderMessageQueueOffset(msg, mq.generateKey(), String.valueOf(offset));
                queueGroupSnapshot.add(mq.generateKey());
            }
            MessageAccessor.putQueueGroupSnapshot(msg, Joiner.on(";").join(queueGroupSnapshot));
        }
    }

    public void updateFromTopicPublishInfoChange() {
        try {
            ConcurrentMap<String, Long> offsetTable = this.client.findQueueOffsetTable(this.topic);
            if (offsetTable == null) {
                this.client.fetchConsumeQueueOffsetFromBroker(this.info);
            }
        }
        catch (Exception e) {
            this.log.error("OrderMessageHandler updateFromTopicPublishInfoChange exception", e);
        }
    }

    public boolean processSendResult(SendResult result, CommunicationMode mode, MessageQueue mq) {
        boolean isRetry = false;
        switch (mode) {
            case ASYNC: 
            case ONEWAY: {
                return false;
            }
            case SYNC: {
                if (result.getSendStatus() != SendStatus.SEND_OK) {
                    if (!this.client.getDefaultMQProducer().isRetryAnotherBrokerWhenNotStoreOK()) break;
                    isRetry = true;
                    break;
                }
                long newOffset = result.getQueueOffset() + 1L;
                this.client.putQueueOffset(mq.getTopic(), mq.generateKey(), newOffset);
            }
        }
        return isRetry;
    }

    public static Map<Integer, List<MessageQueue>> generateQueueListMap(TopicPublishInfo info) {
        List queueList;
        List<MessageQueue> messageQueueList = info.getMessageQueueList();
        int queueGroupNums = info.getTopicRouteData().getOrderTopicQueueGroupNums();
        HashMap<Integer, List<MessageQueue>> queueListMap = new HashMap<Integer, List<MessageQueue>>();
        for (int i = 0; i < queueGroupNums; ++i) {
            queueListMap.put(i, new ArrayList());
        }
        for (MessageQueue queue : messageQueueList) {
            queueList = (List)queueListMap.get(queue.getQueueGroupId());
            if (!queue.isMainQueue()) continue;
            queueList.add(new MessageQueue(queue.getTopic(), queue.getBrokerName(), queue.getQueueId(), queue.getQueueGroupId(), true));
        }
        for (MessageQueue queue : messageQueueList) {
            queueList = (List)queueListMap.get(queue.getQueueGroupId());
            if (queue.isMainQueue()) continue;
            queueList.add(new MessageQueue(queue.getTopic(), queue.getBrokerName(), queue.getQueueId(), queue.getQueueGroupId(), false));
        }
        return queueListMap;
    }

    List<MessageQueue> generateMessageQueueList() {
        ArrayList<MessageQueue> messageQueueList = new ArrayList<MessageQueue>();
        for (int i = 0; i < this.info.getTopicRouteData().getWriteQueueGroupNums(); ++i) {
            messageQueueList.add(new MessageQueue(this.topic, "", -1, i, false));
        }
        return messageQueueList;
    }
}

