/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.PullConsumer;
import com.aliyun.openservices.ons.api.TopicPartition;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.impl.rocketmq.OnsClientRPCHook;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.DefaultLitePullConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.TopicMessageQueueChangeListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.MessageModel;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PullConsumerImpl
extends ONSClientAbstract
implements PullConsumer {
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    private static final int MAX_CACHED_MESSAGE_SIZE_IN_MIB = 1024;
    private static final int MIN_CACHED_MESSAGE_SIZE_IN_MIB = 16;
    private static final int MAX_CACHED_MESSAGE_AMOUNT = 50000;
    private static final int MIN_CACHED_MESSAGE_AMOUNT = 100;
    private DefaultLitePullConsumer litePullConsumer;
    private int maxCachedMessageSizeInMiB = 512;
    private int maxCachedMessageAmount = 5000;
    private long minAutoCommitIntervalMillis = 1000L;

    public PullConsumerImpl(Properties properties) {
        super(properties);
        String configuredPollTimeoutMillis;
        String configuredAutoCommitIntervalMillis;
        String autoCommit;
        String configuredCachedMessageSizeInMiB;
        String configuredCachedMessageAmount;
        String consumerGroup = properties.getProperty("GROUP_ID", properties.getProperty("GROUP_ID"));
        if (StringUtils.isEmpty(consumerGroup)) {
            throw new ONSClientException("Unable to get GROUP_ID property");
        }
        this.litePullConsumer = new DefaultLitePullConsumer(this.getNamespace(), consumerGroup, new OnsClientRPCHook(this.provider));
        String messageModel = properties.getProperty("MessageModel", "CLUSTERING");
        this.litePullConsumer.setMessageModel(MessageModel.valueOf(messageModel));
        String maxBatchMessageCount = properties.getProperty("maxBatchMessageCount");
        if (!UtilAll.isBlank(maxBatchMessageCount)) {
            this.litePullConsumer.setPullBatchSize(Integer.valueOf(StringUtils.trim(maxBatchMessageCount)));
        }
        boolean isVipChannelEnabled = Boolean.parseBoolean(properties.getProperty("isVipChannelEnabled", "false"));
        this.litePullConsumer.setVipChannelEnabled(isVipChannelEnabled);
        String instanceName = StringUtils.defaultIfEmpty(properties.getProperty("InstanceName"), this.buildIntanceName());
        this.litePullConsumer.setInstanceName(instanceName);
        this.litePullConsumer.setNamesrvAddr(this.getNameServerAddr());
        String consumeThreadNums = properties.getProperty("ConsumeThreadNums");
        if (!UtilAll.isBlank(consumeThreadNums)) {
            this.litePullConsumer.setPullThreadNums(Integer.valueOf(StringUtils.trim(consumeThreadNums)));
        }
        if (!UtilAll.isBlank(configuredCachedMessageAmount = properties.getProperty("maxCachedMessageAmount", String.valueOf(this.maxCachedMessageAmount)))) {
            this.maxCachedMessageAmount = Math.min(50000, Integer.valueOf(StringUtils.trim(configuredCachedMessageAmount)));
            this.maxCachedMessageAmount = Math.max(100, this.maxCachedMessageAmount);
            this.litePullConsumer.setPullThresholdForAll(this.maxCachedMessageAmount);
        }
        if (!UtilAll.isBlank(configuredCachedMessageSizeInMiB = properties.getProperty("maxCachedMessageSizeInMiB", String.valueOf(this.maxCachedMessageSizeInMiB)))) {
            this.maxCachedMessageSizeInMiB = Math.min(1024, Integer.valueOf(StringUtils.trim(configuredCachedMessageSizeInMiB)));
            this.maxCachedMessageSizeInMiB = Math.max(16, this.maxCachedMessageSizeInMiB);
            this.litePullConsumer.setPullThresholdSizeForQueue(this.maxCachedMessageSizeInMiB);
        }
        if (!UtilAll.isBlank(autoCommit = properties.getProperty("autoCommit"))) {
            this.litePullConsumer.setAutoCommit(Boolean.valueOf(autoCommit));
        }
        if (!StringUtils.isBlank(configuredAutoCommitIntervalMillis = properties.getProperty("autoCommitIntervalMillis"))) {
            long autoCommitIntervalMillis = Math.max(this.minAutoCommitIntervalMillis, Long.valueOf(StringUtils.trim(configuredAutoCommitIntervalMillis)));
            this.litePullConsumer.setAutoCommitIntervalMillis(autoCommitIntervalMillis);
        }
        if (!StringUtils.isBlank(configuredPollTimeoutMillis = properties.getProperty("pollTimeoutMillis"))) {
            this.litePullConsumer.setPollTimeoutMillis(Long.valueOf(StringUtils.trim(configuredPollTimeoutMillis)));
        }
    }

    @Override
    protected void updateNameServerAddr(String nameServerAddresses) {
        this.litePullConsumer.updateNameServerAddress(nameServerAddresses);
    }

    private Set<TopicPartition> convertToTopicPartitions(Collection<MessageQueue> messageQueues) {
        HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>();
        for (MessageQueue messageQueue : messageQueues) {
            TopicPartition topicPartition = this.convertToTopicPartition(messageQueue);
            topicPartitions.add(topicPartition);
        }
        return topicPartitions;
    }

    private Set<MessageQueue> convertToMessageQueues(Collection<TopicPartition> topicPartitions) {
        HashSet<MessageQueue> messageQueues = new HashSet<MessageQueue>();
        for (TopicPartition topicPartition : topicPartitions) {
            messageQueues.add(this.convertToMessageQueue(topicPartition));
        }
        return messageQueues;
    }

    private TopicPartition convertToTopicPartition(MessageQueue messageQueue) {
        String topic = messageQueue.getTopic();
        String partition = messageQueue.getBrokerName() + "#" + messageQueue.getQueueId();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        return topicPartition;
    }

    private MessageQueue convertToMessageQueue(TopicPartition topicPartition) {
        String topic = topicPartition.getTopic();
        String[] tmp = topicPartition.getPartition().split("#");
        if (tmp.length != 2) {
            LOGGER.warn("Failed to get message queue from TopicPartition: {}", (Object)topicPartition);
            throw new ONSClientException("Failed to get message queue");
        }
        String brokerName = tmp[0];
        int queueId = Integer.valueOf(tmp[1]);
        return new MessageQueue(topic, brokerName, queueId);
    }

    @Override
    public Set<TopicPartition> topicPartitions(String topic) {
        try {
            Collection<MessageQueue> messageQueues = this.litePullConsumer.fetchMessageQueues(topic);
            HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>();
            for (MessageQueue messageQueue : messageQueues) {
                topicPartitions.add(this.convertToTopicPartition(messageQueue));
            }
            return topicPartitions;
        }
        catch (MQClientException ex) {
            LOGGER.warn("Failed to fetch topic partitions", ex);
            throw new ONSClientException("Failed to fetch topic partitions", ex);
        }
    }

    @Override
    public void assign(Collection<TopicPartition> topicPartitions) {
        HashSet<MessageQueue> messageQueues = new HashSet<MessageQueue>();
        for (TopicPartition topicPartition : topicPartitions) {
            messageQueues.add(this.convertToMessageQueue(topicPartition));
        }
        this.litePullConsumer.assign(messageQueues);
    }

    @Override
    public void registerTopicPartitionChangedListener(String topic, final PullConsumer.TopicPartitionChangeListener callback) {
        TopicMessageQueueChangeListener listener = new TopicMessageQueueChangeListener(){

            @Override
            public void onChanged(String topic, Set<MessageQueue> messageQueues) {
                callback.onChanged(PullConsumerImpl.this.convertToTopicPartitions(messageQueues));
            }
        };
        try {
            this.litePullConsumer.registerTopicMessageQueueChangeListener(topic, listener);
        }
        catch (MQClientException ex) {
            LOGGER.warn("Register listener error", ex);
            throw new ONSClientException("Failed to register topic partition listener");
        }
    }

    @Override
    public List<Message> poll(long timeout) {
        List<MessageExt> rmqMsgList = this.litePullConsumer.poll(timeout);
        ArrayList<Message> msgList = new ArrayList<Message>();
        for (MessageExt rmqMsg : rmqMsgList) {
            Message msg = ONSUtil.msgConvert(rmqMsg);
            Map<String, String> propertiesMap = rmqMsg.getProperties();
            msg.setMsgID(rmqMsg.getMsgId());
            if (propertiesMap != null && propertiesMap.get("__transactionId__") != null) {
                msg.setMsgID(propertiesMap.get("__transactionId__"));
            }
            msgList.add(msg);
        }
        return msgList;
    }

    @Override
    public void seek(TopicPartition topicPartition, long offset) {
        MessageQueue messageQueue = this.convertToMessageQueue(topicPartition);
        try {
            this.litePullConsumer.seek(messageQueue, offset);
        }
        catch (MQClientException ex) {
            LOGGER.warn("Topic partition: {} seek to: {} error", topicPartition, offset, ex);
            throw new ONSClientException("Seek offset failed");
        }
    }

    @Override
    public void seekToBeginning(TopicPartition topicPartition) {
        try {
            this.litePullConsumer.seekToBegin(this.convertToMessageQueue(topicPartition));
        }
        catch (MQClientException ex) {
            LOGGER.warn("Topic partition: {} seek to beginning error", (Object)topicPartition, (Object)ex);
            throw new ONSClientException("Seek offset to beginning failed");
        }
    }

    @Override
    public void seekToEnd(TopicPartition topicPartition) {
        try {
            this.litePullConsumer.seekToEnd(this.convertToMessageQueue(topicPartition));
        }
        catch (MQClientException ex) {
            LOGGER.warn("Topic partition: {} seek to end error", (Object)topicPartition, (Object)ex);
            throw new ONSClientException("Seek offset to end failed");
        }
    }

    @Override
    public void pause(Collection<TopicPartition> topicPartitions) {
        this.litePullConsumer.pause(this.convertToMessageQueues(topicPartitions));
    }

    @Override
    public void resume(Collection<TopicPartition> topicPartitions) {
        this.litePullConsumer.resume(this.convertToMessageQueues(topicPartitions));
    }

    @Override
    public Long offsetForTimestamp(TopicPartition topicPartition, Long timestamp) {
        try {
            return this.litePullConsumer.offsetForTimestamp(this.convertToMessageQueue(topicPartition), timestamp);
        }
        catch (MQClientException ex) {
            LOGGER.warn("Get offset for topic partition:{} with timestamp:{} error", topicPartition, timestamp, ex);
            throw new ONSClientException("Failed to get offset");
        }
    }

    @Override
    public Long committed(TopicPartition topicPartition) {
        try {
            return this.litePullConsumer.committed(this.convertToMessageQueue(topicPartition));
        }
        catch (MQClientException ex) {
            LOGGER.warn("Get committed offset for topic partition: {} error", (Object)topicPartition, (Object)ex);
            throw new ONSClientException("Failed to get committed offset");
        }
    }

    @Override
    public void commitSync() {
        this.litePullConsumer.commitSync();
    }

    @Override
    public void start() {
        try {
            if (this.started.compareAndSet(false, true)) {
                this.litePullConsumer.start();
                super.start();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to start pull consumer", e);
            throw new ONSClientException(e.getMessage());
        }
    }

    @Override
    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.litePullConsumer.shutdown();
        }
        super.shutdown();
    }
}

