/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.FutureHolder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsItem;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsItemPrinter;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class StatisticsItemScheduledPrinter
extends FutureHolder {
    protected String name;
    protected StatisticsItemPrinter printer;
    protected ScheduledExecutorService executor;
    protected long interval;
    protected InitialDelay initialDelay;
    protected Enable enable;

    public StatisticsItemScheduledPrinter(String name, StatisticsItemPrinter printer, ScheduledExecutorService executor, InitialDelay initialDelay, long interval, Enable enable) {
        this.name = name;
        this.printer = printer;
        this.executor = executor;
        this.initialDelay = initialDelay;
        this.interval = interval;
        this.enable = enable;
    }

    public void schedule(final StatisticsItem statisticsItem) {
        ScheduledFuture<?> future = this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (StatisticsItemScheduledPrinter.this.enabled()) {
                    StatisticsItemScheduledPrinter.this.printer.print(StatisticsItemScheduledPrinter.this.name, statisticsItem, new String[0]);
                }
            }
        }, this.getInitialDelay(), this.interval, TimeUnit.MILLISECONDS);
        this.addFuture(statisticsItem, future);
    }

    public void remove(StatisticsItem statisticsItem) {
        this.removeAllFuture(statisticsItem);
    }

    protected long getInitialDelay() {
        return this.initialDelay != null ? this.initialDelay.get() : 0L;
    }

    protected boolean enabled() {
        return this.enable != null ? this.enable.get() : false;
    }

    public static interface Enable {
        public boolean get();
    }

    public static interface InitialDelay {
        public long get();
    }
}

