/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validators {
    public static final String VALID_PATTERN_STR = "^[%|a-zA-Z0-9_-]+$";
    public static final Pattern PATTERN = Pattern.compile("^[%|a-zA-Z0-9_-]+$");
    public static final int CHARACTER_MAX_LENGTH = 255;

    public static String getGroupWithRegularExpression(String origin, String patternStr) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(origin);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    public static void checkGroup(String group) throws MQClientException {
        if (UtilAll.isBlank(group)) {
            throw new MQClientException("the specified group is blank", null);
        }
        if (!Validators.regularExpressionMatcher(group, PATTERN)) {
            throw new MQClientException(String.format("the specified group[%s] contains illegal characters, allowing only %s", group, VALID_PATTERN_STR), null);
        }
        if (group.length() > 255) {
            throw new MQClientException("the specified group is longer than group max length 255.", null);
        }
    }

    public static boolean regularExpressionMatcher(String origin, Pattern pattern) {
        if (pattern == null) {
            return true;
        }
        Matcher matcher = pattern.matcher(origin);
        return matcher.matches();
    }

    public static void checkMessage(Message msg, DefaultMQProducer defaultMQProducer) throws MQClientException {
        if (null == msg) {
            throw new MQClientException(13, "the message is null");
        }
        Validators.checkTopic(msg.getTopic());
        if (null == msg.getBody()) {
            throw new MQClientException(13, "the message body is null");
        }
        if (0 == msg.getBody().length) {
            throw new MQClientException(13, "the message body length is zero");
        }
        if (msg.getBody().length > defaultMQProducer.getMaxMessageSize()) {
            throw new MQClientException(13, "the message body size over max value, MAX: " + defaultMQProducer.getMaxMessageSize());
        }
    }

    public static void checkTopic(String topic) throws MQClientException {
        if (UtilAll.isBlank(topic)) {
            throw new MQClientException("The specified topic is blank", null);
        }
        if (!Validators.regularExpressionMatcher(topic, PATTERN)) {
            throw new MQClientException(String.format("The specified topic[%s] contains illegal characters, allowing only %s", topic, VALID_PATTERN_STR), null);
        }
        if (topic.length() > 255) {
            throw new MQClientException("The specified topic is longer than topic max length 255.", null);
        }
        if (topic.equals("TBW102")) {
            throw new MQClientException(String.format("The topic[%s] is conflict with default topic.", topic), null);
        }
    }
}

