/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.ons.open.trace.core.common.OnsTraceConstants;
import com.alibaba.ons.open.trace.core.dispatch.AsyncDispatcher;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncArrayDispatcher;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.batch.BatchConsumer;
import com.aliyun.openservices.ons.api.batch.BatchMessageListener;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.ClientRPCHook;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.impl.tracehook.OnsConsumeMessageHookImpl;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.DefaultMQPushConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.MessageModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class BatchConsumerImpl
extends ONSClientAbstract
implements BatchConsumer {
    private static final Logger log = ClientLoggerUtil.getClientLogger();
    private final DefaultMQPushConsumer defaultMQPushConsumer;
    private final ConcurrentHashMap<String, BatchMessageListener> subscribeTable = new ConcurrentHashMap();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private AsyncDispatcher traceDispatcher = null;
    private static final int MAX_BATCH_SIZE = 32;
    private static final int MIN_BATCH_SIZE = 1;

    public BatchConsumerImpl(Properties properties) {
        super(properties);
        String consumeBatchSize;
        String consumeTimeout;
        this.defaultMQPushConsumer = new DefaultMQPushConsumer(new ClientRPCHook(this.sessionCredentials));
        String consumerGroup = properties.getProperty("ConsumerId");
        if (null == consumerGroup) {
            throw new ONSClientException("'ConsumerId' property is null");
        }
        String maxReconsumeTimes = properties.getProperty("maxReconsumeTimes");
        if (!UtilAll.isBlank(maxReconsumeTimes)) {
            try {
                this.defaultMQPushConsumer.setMaxReconsumeTimes(Integer.parseInt(maxReconsumeTimes));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (!UtilAll.isBlank(consumeTimeout = properties.getProperty("consumeTimeout"))) {
            try {
                this.defaultMQPushConsumer.setConsumeTimeout(Integer.parseInt(consumeTimeout));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        boolean isVipChannelEnabled = Boolean.parseBoolean(properties.getProperty("isVipChannelEnabled", "false"));
        this.defaultMQPushConsumer.setVipChannelEnabled(isVipChannelEnabled);
        boolean postSubscriptionWhenPull = Boolean.parseBoolean(properties.getProperty("PostSubscriptionWhenPull", "false"));
        this.defaultMQPushConsumer.setPostSubscriptionWhenPull(postSubscriptionWhenPull);
        String messageModel = properties.getProperty("MessageModel", "CLUSTERING");
        this.defaultMQPushConsumer.setMessageModel(MessageModel.valueOf(messageModel));
        this.defaultMQPushConsumer.setConsumerGroup(consumerGroup);
        this.defaultMQPushConsumer.setInstanceName(this.buildIntanceName());
        this.defaultMQPushConsumer.setNamesrvAddr(this.getNameServerAddr());
        String consumeThreadNums = properties.getProperty("ConsumeThreadNums");
        if (!UtilAll.isBlank(consumeThreadNums)) {
            this.defaultMQPushConsumer.setConsumeThreadMin(Integer.valueOf(consumeThreadNums));
            this.defaultMQPushConsumer.setConsumeThreadMax(Integer.valueOf(consumeThreadNums));
        }
        if (!UtilAll.isBlank(consumeBatchSize = properties.getProperty("ConsumeMessageBatchMaxSize"))) {
            int batchSize = Math.min(32, Integer.valueOf(consumeBatchSize));
            batchSize = Math.max(1, batchSize);
            this.defaultMQPushConsumer.setConsumeMessageBatchMaxSize(batchSize);
        }
        try {
            Properties tempProperties = new Properties();
            tempProperties.put("AccessKey", this.sessionCredentials.getAccessKey());
            tempProperties.put("SecretKey", this.sessionCredentials.getSecretKey());
            tempProperties.put("MaxMsgSize", "128000");
            tempProperties.put("AsyncBufferSize", "2048");
            tempProperties.put("MaxBatchNum", "100");
            tempProperties.put(OnsTraceConstants.NAMESRV_ADDR, this.getNameServerAddr());
            tempProperties.put("InstanceName", this.buildIntanceName());
            this.traceDispatcher = new AsyncArrayDispatcher(tempProperties);
            this.traceDispatcher.start(null, this.defaultMQPushConsumer.getInstanceName());
            this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().registerConsumeMessageHook(new OnsConsumeMessageHookImpl(this.traceDispatcher));
        }
        catch (Throwable e) {
            log.error("system mqtrace hook init failed ,maybe can't send msg trace data");
        }
    }

    @Override
    public void start() {
        this.defaultMQPushConsumer.registerMessageListener(new BatchMessageListenerImpl());
        try {
            if (this.started.compareAndSet(false, true)) {
                this.defaultMQPushConsumer.start();
            }
        }
        catch (Exception e) {
            throw new ONSClientException(e.getMessage());
        }
        if (this.traceDispatcher != null) {
            this.traceDispatcher.registerShutDownHook();
        }
    }

    @Override
    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.defaultMQPushConsumer.shutdown();
        }
    }

    @Override
    public void subscribe(String topic, String subExpression, BatchMessageListener listener) {
        if (null == topic) {
            throw new ONSClientException("topic is null");
        }
        if (null == listener) {
            throw new ONSClientException("listener is null");
        }
        try {
            this.subscribeTable.put(topic, listener);
            this.defaultMQPushConsumer.subscribe(topic, subExpression);
        }
        catch (MQClientException e) {
            throw new ONSClientException("defaultMQPushConsumer subscribe exception", e);
        }
    }

    @Override
    public void unsubscribe(String topic) {
        if (null != topic) {
            this.defaultMQPushConsumer.unsubscribe(topic);
            this.subscribeTable.remove(topic);
        }
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public boolean isClosed() {
        return !this.isStarted();
    }

    class BatchMessageListenerImpl
    implements MessageListenerConcurrently {
        BatchMessageListenerImpl() {
        }

        @Override
        public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> rmqMsgList, ConsumeConcurrentlyContext contextRMQ) {
            ArrayList<Message> msgList = new ArrayList<Message>();
            for (MessageExt rmqMsg : rmqMsgList) {
                Message msg = ONSUtil.msgConvert(rmqMsg);
                Map<String, String> propertiesMap = rmqMsg.getProperties();
                msg.setMsgID(rmqMsg.getMsgId());
                if (propertiesMap != null && propertiesMap.get("__transactionId__") != null) {
                    msg.setMsgID(propertiesMap.get("__transactionId__"));
                }
                msgList.add(msg);
            }
            BatchMessageListener listener = (BatchMessageListener)BatchConsumerImpl.this.subscribeTable.get(((Message)msgList.get(0)).getTopic());
            if (null == listener) {
                throw new ONSClientException("BatchMessageListener is null");
            }
            ConsumeContext context = new ConsumeContext();
            Action action = listener.consume(msgList, context);
            if (action != null) {
                switch (action) {
                    case CommitMessage: {
                        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                    }
                    case ReconsumeLater: {
                        return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                    }
                }
            }
            return null;
        }
    }
}

