/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sls.android.producer.utils;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.SystemClock;
import com.aliyun.sls.android.producer.Log;
import com.aliyun.sls.android.producer.LogProducerHttpTool;
import com.aliyun.sls.android.producer.utils.ThreadUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class TimeUtils {
    private static long serverTime;
    private static long elapsedRealTime;

    private TimeUtils() {
    }

    public static void startUpdateServerTime(Context context, String endpoint, String project) {
        PackageManager pManager;
        if (null != context && (pManager = context.getPackageManager()).checkPermission("android.permission.INTERNET", context.getPackageName()) != 0) {
            return;
        }
        String host = endpoint.contains("http") ? endpoint.substring(endpoint.indexOf("://") + 3) : endpoint;
        final String url = "https://" + project + "." + host + "/servertime";
        final String[] headers = new String[]{"x-log-apiversion", "0.6.0"};
        ThreadUtils.exec(new Runnable(){

            @Override
            public void run() {
                LogProducerHttpTool.android_http_post(url, "GET", headers, new byte[0]);
            }
        });
    }

    public static void updateServerTime(long timeInMillis) {
        serverTime = timeInMillis;
        elapsedRealTime = SystemClock.elapsedRealtime();
    }

    public static long getTimeInMillis() {
        if (0L == elapsedRealTime) {
            return System.currentTimeMillis() / 1000L;
        }
        long delta = SystemClock.elapsedRealtime() - elapsedRealTime;
        return serverTime + delta / 1000L;
    }

    public static void fixTime(Log log) {
        if (null == log) {
            return;
        }
        Map<String, String> contents = log.getContent();
        if (null == contents || contents.size() == 0) {
            return;
        }
        if (!contents.containsKey("local_timestamp")) {
            return;
        }
        Date date = new Date();
        String localTimestamp = contents.get("local_timestamp");
        localTimestamp = localTimestamp.length() < 10 ? String.valueOf(System.currentTimeMillis()) : localTimestamp.substring(0, 10) + String.valueOf(date.getTime()).substring(10);
        date.setTime(TimeUtils.safe2Long(localTimestamp));
        String localTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS", Locale.getDefault()).format(date);
        contents.put("local_time_fixed", localTime);
        contents.put("local_timestamp_fixed", localTimestamp);
    }

    private static long safe2Long(String time) {
        try {
            return Long.parseLong(time);
        }
        catch (Throwable e) {
            return System.currentTimeMillis();
        }
    }
}

