/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sls.android.producer;

import android.content.Context;
import android.text.TextUtils;
import com.aliyun.sls.android.producer.LogProducerException;
import com.aliyun.sls.android.producer.LogProducerTimeUnixFunc;
import com.aliyun.sls.android.producer.utils.SoLoader;
import com.aliyun.sls.android.producer.utils.TimeUtils;

public class LogProducerConfig {
    private static boolean hasSoLoaded = false;
    private final long config;
    private final Context context;
    private String endpoint;
    private String project;
    private String logstore;
    private boolean enableTrack = false;

    @Deprecated
    public LogProducerConfig(String endpoint, String project, String logstore, String accessKeyId, String accessKeySecret) throws LogProducerException {
        this(endpoint, project, logstore, accessKeyId, accessKeySecret, null);
    }

    @Deprecated
    public LogProducerConfig(String endpoint, String project, String logstore, String accessKeyId, String accessKeySecret, String securityToken) throws LogProducerException {
        this(null, endpoint, project, logstore, accessKeyId, accessKeySecret, securityToken);
    }

    public LogProducerConfig(Context context, String endpoint, String project, String logstore) throws LogProducerException {
        this(context, endpoint, project, logstore, null, null);
    }

    public LogProducerConfig(Context context, String endpoint, String project, String logstore, String accessKeyId, String accessKeySecret) throws LogProducerException {
        this(context, endpoint, project, logstore, accessKeyId, accessKeySecret, null);
    }

    public LogProducerConfig(Context context, String endpoint, String project, String logstore, String accessKeyId, String accessKeySecret, String securityToken) throws LogProducerException {
        if (!hasSoLoaded) {
            SoLoader.instance().loadLibrary(context, "sls_producer");
            hasSoLoaded = true;
        }
        this.context = context;
        this.config = LogProducerConfig.create_log_producer_config();
        if (this.config == 0L) {
            throw new LogProducerException("Can not create log producer config");
        }
        this.setSource("Android");
        this.setPacketTimeout(3000);
        this.setPacketLogCount(1024);
        this.setPacketLogBytes(0x100000);
        this.setSendThreadCount(1);
        this.setDropUnauthorizedLog(0);
        this.setDropDelayLog(0);
        this.setGetTimeUnixFunc(new LogProducerTimeUnixFunc(){

            @Override
            public long getTimeUnix() {
                return TimeUtils.getTimeInMillis();
            }
        });
        this.setEndpoint(endpoint);
        this.setProject(project);
        this.setLogstore(logstore);
        this.setAccessKeyId(accessKeyId);
        this.setAccessKeySecret(accessKeySecret);
        if (!TextUtils.isEmpty((CharSequence)securityToken)) {
            this.resetSecurityToken(accessKeyId, accessKeySecret, securityToken);
        }
    }

    private static native long create_log_producer_config();

    private static native void log_producer_debug();

    private static native void log_producer_config_set_endpoint(long var0, String var2);

    private static native void log_producer_config_set_project(long var0, String var2);

    private static native void log_producer_config_set_logstore(long var0, String var2);

    private static native void log_producer_config_set_access_id(long var0, String var2);

    private static native void log_producer_config_set_access_key(long var0, String var2);

    private static native void log_producer_config_reset_security_token(long var0, String var2, String var3, String var4);

    private static native void log_producer_config_set_topic(long var0, String var2);

    private static native void log_producer_config_add_tag(long var0, String var2, String var3);

    private static native void log_producer_config_set_packet_log_bytes(long var0, int var2);

    private static native void log_producer_config_set_packet_log_count(long var0, int var2);

    private static native void log_producer_config_set_packet_timeout(long var0, int var2);

    private static native void log_producer_config_set_max_buffer_limit(long var0, int var2);

    private static native void log_producer_config_set_send_thread_count(long var0, int var2);

    private static native void log_producer_config_set_persistent(long var0, int var2);

    private static native void log_producer_config_set_persistent_file_path(long var0, String var2);

    private static native void log_producer_config_set_persistent_force_flush(long var0, int var2);

    private static native void log_producer_config_set_persistent_max_file_count(long var0, int var2);

    private static native void log_producer_config_set_persistent_max_file_size(long var0, int var2);

    private static native void log_producer_config_set_persistent_max_log_count(long var0, int var2);

    private static native void log_producer_config_set_using_http(long var0, int var2);

    private static native void log_producer_config_set_net_interface(long var0, String var2);

    private static native void log_producer_config_set_connect_timeout_sec(long var0, int var2);

    private static native void log_producer_config_set_send_timeout_sec(long var0, int var2);

    private static native void log_producer_config_set_destroy_flusher_wait_sec(long var0, int var2);

    private static native void log_producer_config_set_destroy_sender_wait_sec(long var0, int var2);

    private static native void log_producer_config_set_compress_type(long var0, int var2);

    private static native void log_producer_config_set_ntp_time_offset(long var0, int var2);

    private static native void log_producer_config_set_max_log_delay_time(long var0, int var2);

    private static native void log_producer_config_set_drop_delay_log(long var0, int var2);

    private static native void log_producer_config_set_get_time_unix_func(LogProducerTimeUnixFunc var0);

    private static native void log_producer_config_set_drop_unauthorized_log(long var0, int var2);

    private static native void log_producer_config_set_source(long var0, String var2);

    private static native int log_producer_config_is_valid(long var0);

    private static native int log_producer_persistent_config_is_enabled(long var0);

    public Context getContext() {
        return this.context;
    }

    public void setEndpoint(String endpoint) {
        if (TextUtils.isEmpty((CharSequence)endpoint)) {
            endpoint = "please_set_endpoint";
        }
        this.endpoint = endpoint;
        LogProducerConfig.log_producer_config_set_endpoint(this.config, endpoint);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setProject(String project) {
        if (TextUtils.isEmpty((CharSequence)project)) {
            project = "please_set_project";
        }
        this.project = project;
        LogProducerConfig.log_producer_config_set_project(this.config, project);
    }

    public String getProject() {
        return this.project;
    }

    public void setLogstore(String logstore) {
        if (TextUtils.isEmpty((CharSequence)logstore)) {
            logstore = "please_set_logstore";
        }
        this.logstore = logstore;
        LogProducerConfig.log_producer_config_set_logstore(this.config, logstore);
    }

    public String getLogstore() {
        return this.logstore;
    }

    public void setTopic(String topic) {
        LogProducerConfig.log_producer_config_set_topic(this.config, topic);
    }

    public void addTag(String key, String value) {
        LogProducerConfig.log_producer_config_add_tag(this.config, key, value);
    }

    public void setAccessKeyId(String accessId) {
        LogProducerConfig.log_producer_config_set_access_id(this.config, accessId);
    }

    public void setAccessKeySecret(String accessKeySecret) {
        LogProducerConfig.log_producer_config_set_access_key(this.config, accessKeySecret);
    }

    public void setPacketLogBytes(int num) {
        LogProducerConfig.log_producer_config_set_packet_log_bytes(this.config, num);
    }

    public void setPacketLogCount(int num) {
        LogProducerConfig.log_producer_config_set_packet_log_count(this.config, num);
    }

    public void setPacketTimeout(int num) {
        LogProducerConfig.log_producer_config_set_packet_timeout(this.config, num);
    }

    public void setMaxBufferLimit(int num) {
        LogProducerConfig.log_producer_config_set_max_buffer_limit(this.config, num);
    }

    public void setSendThreadCount(int num) {
        LogProducerConfig.log_producer_config_set_send_thread_count(this.config, num);
    }

    public void setPersistent(int num) {
        LogProducerConfig.log_producer_config_set_persistent(this.config, num);
    }

    public void setPersistentFilePath(String path) {
        LogProducerConfig.log_producer_config_set_persistent_file_path(this.config, path);
    }

    public void setPersistentForceFlush(int num) {
        LogProducerConfig.log_producer_config_set_persistent_force_flush(this.config, num);
    }

    public void setPersistentMaxFileCount(int num) {
        LogProducerConfig.log_producer_config_set_persistent_max_file_count(this.config, num);
    }

    public void setPersistentMaxFileSize(int num) {
        LogProducerConfig.log_producer_config_set_persistent_max_file_size(this.config, num);
    }

    public void setPersistentMaxLogCount(int num) {
        LogProducerConfig.log_producer_config_set_persistent_max_log_count(this.config, num);
    }

    public void setUsingHttp(int num) {
        LogProducerConfig.log_producer_config_set_using_http(this.config, num);
    }

    public void setNetInterface(String netInterface) {
        LogProducerConfig.log_producer_config_set_net_interface(this.config, netInterface);
    }

    public void setConnectTimeoutSec(int num) {
        LogProducerConfig.log_producer_config_set_connect_timeout_sec(this.config, num);
    }

    public void setSendTimeoutSec(int num) {
        LogProducerConfig.log_producer_config_set_send_timeout_sec(this.config, num);
    }

    public void setDestroyFlusherWaitSec(int num) {
        LogProducerConfig.log_producer_config_set_destroy_flusher_wait_sec(this.config, num);
    }

    public void setDestroySenderWaitSec(int num) {
        LogProducerConfig.log_producer_config_set_destroy_sender_wait_sec(this.config, num);
    }

    public void setCompressType(int num) {
        LogProducerConfig.log_producer_config_set_compress_type(this.config, num);
    }

    public void setNtpTimeOffset(int num) {
        LogProducerConfig.log_producer_config_set_ntp_time_offset(this.config, num);
    }

    public void setMaxLogDelayTime(int num) {
        LogProducerConfig.log_producer_config_set_max_log_delay_time(this.config, num);
    }

    public void setDropDelayLog(int num) {
        LogProducerConfig.log_producer_config_set_drop_delay_log(this.config, num);
    }

    public void setDropUnauthorizedLog(int num) {
        LogProducerConfig.log_producer_config_set_drop_unauthorized_log(this.config, num);
    }

    public void setGetTimeUnixFunc(LogProducerTimeUnixFunc func) {
        LogProducerConfig.log_producer_config_set_get_time_unix_func(func);
    }

    public void setSource(String source) {
        LogProducerConfig.log_producer_config_set_source(this.config, source);
    }

    public void resetSecurityToken(String accessKeyID, String accessKeySecret, String securityToken) {
        LogProducerConfig.log_producer_config_reset_security_token(this.config, accessKeyID, accessKeySecret, securityToken);
    }

    public void logProducerDebug() {
        LogProducerConfig.log_producer_debug();
    }

    long getConfig() {
        return this.config;
    }

    public int isValid() {
        return LogProducerConfig.log_producer_config_is_valid(this.config);
    }

    public int isEnabled() {
        return LogProducerConfig.log_producer_persistent_config_is_enabled(this.config);
    }

    public void setEnableTrack(boolean enableTrack) {
        this.enableTrack = enableTrack;
    }

    public boolean isEnableTrack() {
        return this.enableTrack;
    }
}

