/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sls.android;

import com.aliyun.sls.android.SLSConfig;
import com.aliyun.sls.android.SLSLog;
import com.aliyun.sls.android.plugin.IPlugin;
import com.aliyun.sls.android.producer.HttpConfigProxy;
import java.util.ArrayList;
import java.util.List;

public class SLSAdapter {
    private static final String TAG = "SLSAdapter";
    private String channel;
    private String channelName;
    private String userNick;
    private String longLoginNick;
    private String loginType;
    private List<IPlugin> plugins = new ArrayList<IPlugin>();

    private SLSAdapter() {
    }

    public static SLSAdapter getInstance() {
        return Holder.INSTANCE;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public void setUserNick(String userNick) {
        this.userNick = userNick;
    }

    public void setLongLoginNick(String longLoginNick) {
        this.longLoginNick = longLoginNick;
    }

    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    public void init(SLSConfig config) {
        if (config.debuggable) {
            SLSLog.v(TAG, "init, start.");
        }
        if (!this.checkConfig(config)) {
            return;
        }
        for (IPlugin plugin : this.plugins) {
            if (config.debuggable) {
                SLSLog.v(TAG, SLSLog.format("init plugin %s start. plugin: ", new Object[]{plugin.name()}));
            }
            plugin.init(config);
            HttpConfigProxy.addPluginUserAgent(plugin.name(), plugin.version());
            if (!config.debuggable) continue;
            SLSLog.v(TAG, SLSLog.format("init plugin %s end. plugin: ", new Object[]{plugin.name()}));
        }
        if (config.debuggable) {
            SLSLog.v(TAG, "init, end.");
        }
    }

    public void updateConfig(SLSConfig config) {
        for (IPlugin plugin : this.plugins) {
            plugin.updateConfig(config);
        }
    }

    public void resetSecurityToken(String accessKeyId, String accessKeySecret, String securityToken) {
        for (IPlugin plugin : this.plugins) {
            plugin.resetSecurityToken(accessKeyId, accessKeySecret, securityToken);
        }
    }

    public void resetProject(String endpoint, String project, String logstore) {
        for (IPlugin plugin : this.plugins) {
            plugin.resetProject(endpoint, project, logstore);
        }
    }

    public SLSAdapter addPlugin(IPlugin plugin) {
        if (null == plugin) {
            throw new IllegalArgumentException("plugin must not be null");
        }
        this.plugins.add(plugin);
        return this;
    }

    private boolean checkConfig(SLSConfig config) {
        if (null == config) {
            throw new IllegalArgumentException("SLSConfig must not be null.");
        }
        if (null == config.context) {
            throw new IllegalArgumentException("SLSConfig.context must not be null.");
        }
        return true;
    }

    private static class Holder {
        private static final SLSAdapter INSTANCE = new SLSAdapter();

        private Holder() {
        }
    }
}

