/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.network;

import com.alibaba.sdk.android.oss.callback.OSSProgressCallback;
import com.alibaba.sdk.android.oss.model.OSSRequest;
import com.alibaba.sdk.android.oss.network.ExecutionContext;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class ProgressTouchableRequestBody<T extends OSSRequest>
extends RequestBody {
    private static final int SEGMENT_SIZE = 2048;
    private InputStream inputStream;
    private String contentType;
    private long contentLength;
    private OSSProgressCallback callback;
    private T request;

    public ProgressTouchableRequestBody(InputStream input, long contentLength, String contentType, ExecutionContext context) {
        this.inputStream = input;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.callback = context.getProgressCallback();
        this.request = context.getRequest();
    }

    public MediaType contentType() {
        return MediaType.parse((String)this.contentType);
    }

    public long contentLength() throws IOException {
        return this.contentLength;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        Source source = Okio.source((InputStream)this.inputStream);
        long total = 0L;
        while (total < this.contentLength) {
            long remain = this.contentLength - total;
            long toRead = Math.min(remain, 2048L);
            long read = source.read(sink.buffer(), toRead);
            if (read == -1L) break;
            sink.flush();
            if (this.callback == null || (total += read) == 0L) continue;
            this.callback.onProgress(this.request, total, this.contentLength);
        }
        if (source != null) {
            source.close();
        }
    }
}

