/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.utils.CaseInsensitiveHashMap;
import com.alibaba.sdk.android.oss.internal.ResponseMessage;
import com.alibaba.sdk.android.oss.internal.ResponseParser;
import com.alibaba.sdk.android.oss.model.OSSResult;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.zip.CheckedInputStream;
import okhttp3.Headers;
import okhttp3.Response;

public abstract class AbstractResponseParser<T extends OSSResult>
implements ResponseParser {
    public static void safeCloseResponse(ResponseMessage response) {
        try {
            response.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    abstract T parseData(ResponseMessage var1, T var2) throws Exception;

    public boolean needCloseResponse() {
        return true;
    }

    @Override
    public T parse(ResponseMessage response) throws IOException {
        try {
            Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            Class classType = (Class)type;
            OSSResult result = (OSSResult)classType.newInstance();
            if (result != null) {
                result.setRequestId((String)response.getHeaders().get("x-oss-request-id"));
                result.setStatusCode(response.getStatusCode());
                result.setResponseHeader(this.parseResponseHeader(response.getResponse()));
                this.setCRC(result, response);
                result = this.parseData(response, result);
            }
            OSSResult oSSResult = result;
            return (T)oSSResult;
        }
        catch (Exception e) {
            IOException ioException = new IOException(e.getMessage(), e);
            e.printStackTrace();
            OSSLog.logThrowable2Local(e);
            throw ioException;
        }
        finally {
            if (this.needCloseResponse()) {
                AbstractResponseParser.safeCloseResponse(response);
            }
        }
    }

    private CaseInsensitiveHashMap<String, String> parseResponseHeader(Response response) {
        CaseInsensitiveHashMap<String, String> result = new CaseInsensitiveHashMap<String, String>();
        Headers headers = response.headers();
        for (int i = 0; i < headers.size(); ++i) {
            result.put(headers.name(i), headers.value(i));
        }
        return result;
    }

    public <Result extends OSSResult> void setCRC(Result result, ResponseMessage response) {
        String strSrvCrc;
        InputStream inputStream = response.getRequest().getContent();
        if (inputStream != null && inputStream instanceof CheckedInputStream) {
            CheckedInputStream checkedInputStream = (CheckedInputStream)inputStream;
            result.setClientCRC(checkedInputStream.getChecksum().getValue());
        }
        if ((strSrvCrc = (String)response.getHeaders().get("x-oss-hash-crc64ecma")) != null) {
            BigInteger bi = new BigInteger(strSrvCrc);
            result.setServerCRC(bi.longValue());
        }
    }
}

