/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.utils.BinaryUtil;
import com.alibaba.sdk.android.oss.common.utils.OSSSharedPreferences;
import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import com.alibaba.sdk.android.oss.internal.BaseMultipartUploadTask;
import com.alibaba.sdk.android.oss.internal.InternalRequestOperation;
import com.alibaba.sdk.android.oss.internal.OSSAsyncTask;
import com.alibaba.sdk.android.oss.model.AbortMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.ListPartsRequest;
import com.alibaba.sdk.android.oss.model.ListPartsResult;
import com.alibaba.sdk.android.oss.model.PartETag;
import com.alibaba.sdk.android.oss.model.PartSummary;
import com.alibaba.sdk.android.oss.model.ResumableUploadRequest;
import com.alibaba.sdk.android.oss.model.ResumableUploadResult;
import com.alibaba.sdk.android.oss.network.ExecutionContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class ResumableUploadTask
extends BaseMultipartUploadTask<ResumableUploadRequest, ResumableUploadResult>
implements Callable<ResumableUploadResult> {
    private File mRecordFile;
    private List<Integer> mAlreadyUploadIndex = new ArrayList<Integer>();
    private OSSSharedPreferences mSp = OSSSharedPreferences.instance(this.mContext.getApplicationContext());
    private File mCRC64RecordFile;
    private ResumableUploadRequest.ExceptionTerminationMode exceptionTerminationMode;

    public ResumableUploadTask(ResumableUploadRequest request, OSSCompletedCallback<ResumableUploadRequest, ResumableUploadResult> completedCallback, ExecutionContext context, InternalRequestOperation apiOperation) {
        super(apiOperation, request, completedCallback, context);
        this.exceptionTerminationMode = request.getExceptionTerminationMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initMultipartUploadId() throws IOException, ClientException, ServiceException {
        Map recordCrc64 = null;
        if (!OSSUtils.isEmptyString(((ResumableUploadRequest)this.mRequest).getRecordDirectory())) {
            String fileMd5 = null;
            if (this.mUploadUri != null) {
                OSSLog.logDebug("[initUploadId] - mUploadFilePath : " + this.mUploadUri.getPath());
                ParcelFileDescriptor parcelFileDescriptor = this.mContext.getApplicationContext().getContentResolver().openFileDescriptor(this.mUploadUri, "r");
                try {
                    fileMd5 = BinaryUtil.calculateMd5Str(parcelFileDescriptor.getFileDescriptor());
                }
                finally {
                    if (parcelFileDescriptor != null) {
                        parcelFileDescriptor.close();
                    }
                }
            } else {
                OSSLog.logDebug("[initUploadId] - mUploadFilePath : " + this.mUploadFilePath);
                fileMd5 = BinaryUtil.calculateMd5Str(this.mUploadFilePath);
            }
            OSSLog.logDebug("[initUploadId] - mRequest.getPartSize() : " + ((ResumableUploadRequest)this.mRequest).getPartSize());
            String recordFileName = BinaryUtil.calculateMd5Str((fileMd5 + ((ResumableUploadRequest)this.mRequest).getBucketName() + ((ResumableUploadRequest)this.mRequest).getObjectKey() + String.valueOf(((ResumableUploadRequest)this.mRequest).getPartSize()) + (this.mCheckCRC64 ? "-crc64" : "")).getBytes());
            String recordPath = ((ResumableUploadRequest)this.mRequest).getRecordDirectory() + File.separator + recordFileName;
            this.mRecordFile = new File(recordPath);
            if (this.mRecordFile.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(this.mRecordFile));
                this.mUploadId = br.readLine();
                br.close();
            }
            OSSLog.logDebug("[initUploadId] - mUploadId : " + this.mUploadId);
            if (!OSSUtils.isEmptyString(this.mUploadId)) {
                String filePath;
                File crc64Record;
                if (this.mCheckCRC64 && (crc64Record = new File(filePath = ((ResumableUploadRequest)this.mRequest).getRecordDirectory() + File.separator + this.mUploadId)).exists()) {
                    FileInputStream fs = new FileInputStream(crc64Record);
                    ObjectInputStream ois = new ObjectInputStream(fs);
                    try {
                        recordCrc64 = (Map)ois.readObject();
                        crc64Record.delete();
                    }
                    catch (ClassNotFoundException e) {
                        OSSLog.logThrowable2Local(e);
                    }
                    finally {
                        if (ois != null) {
                            ois.close();
                        }
                        crc64Record.delete();
                    }
                }
                boolean isTruncated = false;
                int nextPartNumberMarker = 0;
                do {
                    ListPartsRequest listParts = new ListPartsRequest(((ResumableUploadRequest)this.mRequest).getBucketName(), ((ResumableUploadRequest)this.mRequest).getObjectKey(), this.mUploadId);
                    if (nextPartNumberMarker > 0) {
                        listParts.setPartNumberMarker(nextPartNumberMarker);
                    }
                    OSSAsyncTask<ListPartsResult> task = this.mApiOperation.listParts(listParts, null);
                    try {
                        ListPartsResult result = task.getResult();
                        isTruncated = result.isTruncated();
                        nextPartNumberMarker = result.getNextPartNumberMarker();
                        List<PartSummary> parts = result.getParts();
                        int partSize = this.mPartAttr[0];
                        int partTotalNumber = this.mPartAttr[1];
                        for (int i = 0; i < parts.size(); ++i) {
                            boolean isTotal;
                            PartSummary part = parts.get(i);
                            PartETag partETag = new PartETag(part.getPartNumber(), part.getETag());
                            partETag.setPartSize(part.getSize());
                            if (recordCrc64 != null && recordCrc64.size() > 0 && recordCrc64.containsKey(partETag.getPartNumber())) {
                                partETag.setCRC64((Long)recordCrc64.get(partETag.getPartNumber()));
                            }
                            OSSLog.logDebug("[initUploadId] -  " + i + " part.getPartNumber() : " + part.getPartNumber());
                            OSSLog.logDebug("[initUploadId] -  " + i + " part.getSize() : " + part.getSize());
                            boolean bl = isTotal = part.getPartNumber() == partTotalNumber;
                            if (isTotal && part.getSize() != this.mLastPartSize) {
                                throw new ClientException("current part size " + part.getSize() + " setting is inconsistent with PartSize : " + partSize + " or lastPartSize : " + this.mLastPartSize);
                            }
                            if (!isTotal && part.getSize() != (long)partSize) {
                                throw new ClientException("current part size " + part.getSize() + " setting is inconsistent with PartSize : " + partSize + " or lastPartSize : " + this.mLastPartSize);
                            }
                            this.mPartETags.add(partETag);
                            this.mUploadedLength += part.getSize();
                            this.mAlreadyUploadIndex.add(part.getPartNumber());
                        }
                    }
                    catch (ServiceException e) {
                        isTruncated = false;
                        if (e.getStatusCode() == 404) {
                            this.mUploadId = null;
                        }
                        throw e;
                    }
                    catch (ClientException e) {
                        isTruncated = false;
                        throw e;
                    }
                    task.waitUntilFinished();
                } while (isTruncated);
            }
            if (!this.mRecordFile.exists() && !this.mRecordFile.createNewFile()) {
                throw new ClientException("Can't create file at path: " + this.mRecordFile.getAbsolutePath() + "\nPlease make sure the directory exist!");
            }
        }
        if (OSSUtils.isEmptyString(this.mUploadId)) {
            InitiateMultipartUploadRequest init = new InitiateMultipartUploadRequest(((ResumableUploadRequest)this.mRequest).getBucketName(), ((ResumableUploadRequest)this.mRequest).getObjectKey(), ((ResumableUploadRequest)this.mRequest).getMetadata());
            InitiateMultipartUploadResult initResult = this.mApiOperation.initMultipartUpload(init, null).getResult();
            this.mUploadId = initResult.getUploadId();
            if (this.mRecordFile != null) {
                BufferedWriter bw = new BufferedWriter(new FileWriter(this.mRecordFile));
                bw.write(this.mUploadId);
                bw.close();
            }
        }
        ((ResumableUploadRequest)this.mRequest).setUploadId(this.mUploadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResumableUploadResult doMultipartUpload() throws IOException, ClientException, ServiceException, InterruptedException {
        long tempUploadedLength = this.mUploadedLength;
        this.checkCancel();
        int readByte = this.mPartAttr[0];
        final int partNumber = this.mPartAttr[1];
        if (this.mPartETags.size() > 0 && this.mAlreadyUploadIndex.size() > 0) {
            if (this.mUploadedLength > this.mFileLength) {
                throw new ClientException("The uploading file is inconsistent with before");
            }
            long revertUploadedLength = this.mUploadedLength;
            if (!TextUtils.isEmpty((CharSequence)this.mSp.getStringValue(this.mUploadId))) {
                revertUploadedLength = Long.valueOf(this.mSp.getStringValue(this.mUploadId));
            }
            if (this.mProgressCallback != null) {
                this.mProgressCallback.onProgress(this.mRequest, revertUploadedLength, this.mFileLength);
            }
            this.mSp.removeKey(this.mUploadId);
        }
        this.mRunPartTaskCount = this.mPartETags.size();
        for (int i = 0; i < partNumber; ++i) {
            if (this.exceptionTerminationMode == ResumableUploadRequest.ExceptionTerminationMode.EXCEPTION) {
                this.checkException();
            }
            if (this.mAlreadyUploadIndex.size() != 0 && this.mAlreadyUploadIndex.contains(i + 1) || this.mPoolExecutor == null) continue;
            if (i == partNumber - 1) {
                readByte = (int)(this.mFileLength - tempUploadedLength);
            }
            final int byteCount = readByte;
            final int readIndex = i;
            tempUploadedLength += (long)byteCount;
            this.mPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ResumableUploadTask.this.uploadPart(readIndex, byteCount, partNumber);
                }
            });
        }
        if (this.checkWaitCondition(partNumber)) {
            Object i = this.mLock;
            synchronized (i) {
                this.mLock.wait();
            }
        }
        this.checkException();
        CompleteMultipartUploadResult completeResult = this.completeMultipartUploadResult();
        ResumableUploadResult result = null;
        if (completeResult != null) {
            result = new ResumableUploadResult(completeResult);
        }
        if (this.mRecordFile != null) {
            this.mRecordFile.delete();
        }
        if (this.mCRC64RecordFile != null) {
            this.mCRC64RecordFile.delete();
        }
        this.releasePool();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkException() throws IOException, ServiceException, ClientException {
        if (this.mContext.getCancellationHandler().isCancelled()) {
            if (((ResumableUploadRequest)this.mRequest).deleteUploadOnCancelling().booleanValue()) {
                this.abortThisUpload();
                if (this.mRecordFile != null) {
                    this.mRecordFile.delete();
                }
            } else if (this.mPartETags != null && this.mPartETags.size() > 0 && this.mCheckCRC64 && ((ResumableUploadRequest)this.mRequest).getRecordDirectory() != null) {
                HashMap<Integer, Long> maps = new HashMap<Integer, Long>();
                for (PartETag eTag : this.mPartETags) {
                    maps.put(eTag.getPartNumber(), eTag.getCRC64());
                }
                ObjectOutputStream oot = null;
                try {
                    String filePath = ((ResumableUploadRequest)this.mRequest).getRecordDirectory() + File.separator + this.mUploadId;
                    this.mCRC64RecordFile = new File(filePath);
                    if (!this.mCRC64RecordFile.exists()) {
                        this.mCRC64RecordFile.createNewFile();
                    }
                    oot = new ObjectOutputStream(new FileOutputStream(this.mCRC64RecordFile));
                    oot.writeObject(maps);
                }
                catch (IOException e) {
                    OSSLog.logThrowable2Local(e);
                }
                finally {
                    if (oot != null) {
                        oot.close();
                    }
                }
            }
        }
        super.checkException();
    }

    @Override
    protected void abortThisUpload() {
        if (this.mUploadId != null) {
            AbortMultipartUploadRequest abort = new AbortMultipartUploadRequest(((ResumableUploadRequest)this.mRequest).getBucketName(), ((ResumableUploadRequest)this.mRequest).getObjectKey(), this.mUploadId);
            this.mApiOperation.abortMultipartUpload(abort, null).waitUntilFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processException(Exception e) {
        Object object = this.mLock;
        synchronized (object) {
            ++this.mPartExceptionCount;
            this.mUploadException = e;
            OSSLog.logThrowable2Local(e);
            if (this.mContext.getCancellationHandler().isCancelled() && !this.mIsCancel) {
                this.mIsCancel = true;
                this.mLock.notify();
            }
            if (this.exceptionTerminationMode == ResumableUploadRequest.ExceptionTerminationMode.EXCEPTION || this.mPartETags.size() == this.mRunPartTaskCount - this.mPartExceptionCount) {
                this.notifyMultipartThread();
            }
        }
    }

    @Override
    protected void uploadPartFinish(PartETag partETag) throws Exception {
        if (this.mContext.getCancellationHandler().isCancelled() && !this.mSp.contains(this.mUploadId)) {
            this.mSp.setStringValue(this.mUploadId, String.valueOf(this.mUploadedLength));
            this.onProgressCallback(this.mRequest, this.mUploadedLength, this.mFileLength);
        }
    }
}

