/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import android.text.TextUtils;
import com.alibaba.sdk.android.oss.ClientConfiguration;
import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.common.HttpMethod;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.common.utils.HttpUtil;
import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import com.alibaba.sdk.android.oss.internal.RequestMessage;
import com.alibaba.sdk.android.oss.model.GeneratePresignedUrlRequest;
import com.alibaba.sdk.android.oss.signer.OSSSignerBase;
import com.alibaba.sdk.android.oss.signer.OSSSignerParams;
import com.alibaba.sdk.android.oss.signer.RequestPresigner;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;

public class ObjectURLPresigner {
    private URI endpoint;
    private OSSCredentialProvider credentialProvider;
    private ClientConfiguration conf;
    private String product;
    private String region;
    private String cloudBoxId;

    public ObjectURLPresigner(URI endpoint, OSSCredentialProvider credentialProvider, ClientConfiguration conf) {
        this.endpoint = endpoint;
        this.credentialProvider = credentialProvider;
        this.conf = conf;
        this.product = "oss";
    }

    public String presignConstrainedURL(GeneratePresignedUrlRequest request) throws ClientException {
        String bucketName = request.getBucketName();
        String objectKey = request.getKey();
        HttpMethod method = request.getMethod() != null ? request.getMethod() : HttpMethod.GET;
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(method);
        requestMessage.setBucketName(bucketName);
        requestMessage.setObjectKey(objectKey);
        requestMessage.setHeaders((Map)request.getHeaders());
        if (request.getContentType() != null && !request.getContentType().trim().equals("")) {
            requestMessage.getHeaders().put("Content-Type", request.getContentType());
        }
        if (request.getContentMD5() != null && !request.getContentMD5().trim().equals("")) {
            requestMessage.getHeaders().put("Content-MD5", request.getContentMD5());
        }
        if (request.getQueryParameter() != null && request.getQueryParameter().size() > 0) {
            for (Map.Entry<String, String> entry : request.getQueryParameter().entrySet()) {
                requestMessage.getParameters().put(entry.getKey(), entry.getValue());
            }
        }
        if (request.getProcess() != null && !request.getProcess().trim().equals("")) {
            requestMessage.getParameters().put("x-oss-process", request.getProcess());
        }
        requestMessage.setUseUrlSignature(true);
        RequestPresigner signer = this.createSigner(bucketName, objectKey, this.credentialProvider, this.conf, request);
        try {
            signer.presign(requestMessage);
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), e);
        }
        String host = this.buildCanonicalHost(this.endpoint, bucketName, this.conf);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.putAll(requestMessage.getParameters());
        String queryString = HttpUtil.paramToQueryString(params, "utf-8");
        String url = this.endpoint.getScheme() + "://" + host + "/" + HttpUtil.urlEncode(objectKey, "utf-8") + "?" + queryString;
        return url;
    }

    private RequestPresigner createSigner(String bucketName, String key, OSSCredentialProvider credentialProvider, ClientConfiguration config, GeneratePresignedUrlRequest request) {
        String resourcePath = "/" + (bucketName != null ? bucketName + "/" : "") + (key != null ? key : "");
        OSSSignerParams params = new OSSSignerParams(resourcePath, credentialProvider);
        params.setProduct(this.product);
        params.setRegion(this.region);
        params.setCloudBoxId(this.cloudBoxId);
        params.setExpiration(request.getExpiration());
        params.setAdditionalHeaderNames(request.getAdditionalHeaderNames());
        return OSSSignerBase.createRequestPresigner(config.getSignVersion(), params);
    }

    public String presignConstrainedURL(String bucketName, String objectKey, long expiredTimeInSeconds) throws ClientException {
        GeneratePresignedUrlRequest presignedUrlRequest = new GeneratePresignedUrlRequest(bucketName, objectKey);
        presignedUrlRequest.setExpiration(expiredTimeInSeconds);
        return this.presignConstrainedURL(presignedUrlRequest);
    }

    public String presignPublicURL(String bucketName, String objectKey) {
        String host = this.buildCanonicalHost(this.endpoint, bucketName, this.conf);
        return this.endpoint.getScheme() + "://" + host + "/" + HttpUtil.urlEncode(objectKey, "utf-8");
    }

    private String buildCanonicalHost(URI endpoint, String bucketName, ClientConfiguration config) {
        String originHost = endpoint.getHost();
        String portString = null;
        String path = endpoint.getPath();
        int port = endpoint.getPort();
        if (port != -1) {
            portString = String.valueOf(port);
        }
        boolean isPathStyle = false;
        String host = originHost;
        if (!TextUtils.isEmpty((CharSequence)portString)) {
            host = host + ":" + portString;
        }
        if (!TextUtils.isEmpty((CharSequence)bucketName)) {
            if (OSSUtils.isOssOriginHost(originHost)) {
                host = bucketName + "." + originHost;
            } else if (OSSUtils.isInCustomCnameExcludeList(originHost, config.getCustomCnameExcludeList())) {
                if (config.isPathStyleAccessEnable()) {
                    isPathStyle = true;
                } else {
                    host = bucketName + "." + originHost;
                }
            } else {
                try {
                    if (OSSUtils.isValidateIP(originHost)) {
                        isPathStyle = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (config.isCustomPathPrefixEnable() && path != null) {
            host = host + path;
        }
        if (isPathStyle) {
            host = host + "/" + bucketName;
        }
        return host;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getCloudBoxId() {
        return this.cloudBoxId;
    }

    public void setCloudBoxId(String cloudBoxId) {
        this.cloudBoxId = cloudBoxId;
    }
}

