/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.policy.retry;

import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.http.HttpResponse;

public final class RetryPolicyContext {
    private final HttpRequest httpRequest;
    private final HttpResponse httpResponse;
    private final Throwable exception;
    private final int retriesAttempted;
    private final Integer httpStatusCode;

    private RetryPolicyContext(Builder builder) {
        this.httpRequest = builder.httpRequest;
        this.httpResponse = builder.httpResponse;
        this.exception = builder.exception;
        this.retriesAttempted = builder.retriesAttempted;
        this.httpStatusCode = this.httpResponse != null ? Integer.valueOf(this.httpResponse.getStatusCode()) : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HttpRequest httpRequest() {
        return this.httpRequest;
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    public Throwable exception() {
        return this.exception;
    }

    public int retriesAttempted() {
        return this.retriesAttempted;
    }

    public int totalRequests() {
        return this.retriesAttempted + 1;
    }

    public Integer httpStatusCode() {
        return this.httpStatusCode;
    }

    public static final class Builder {
        private HttpRequest httpRequest;
        private HttpResponse httpResponse;
        private Throwable exception;
        private int retriesAttempted;

        private Builder() {
        }

        private Builder(RetryPolicyContext copy) {
            this.httpRequest = copy.httpRequest;
            this.httpResponse = copy.httpResponse;
            this.exception = copy.exception;
            this.retriesAttempted = copy.retriesAttempted;
        }

        public Builder httpRequest(HttpRequest httpRequest) {
            this.httpRequest = httpRequest;
            return this;
        }

        public Builder httpResponse(HttpResponse httpResponse) {
            this.httpResponse = httpResponse;
            return this;
        }

        public Builder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public Builder retriesAttempted(int retriesAttempted) {
            this.retriesAttempted = retriesAttempted;
            return this;
        }

        public RetryPolicyContext build() {
            return new RetryPolicyContext(this);
        }
    }
}

