/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core;

import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpMethod;
import com.aliyun.core.utils.Copyable;
import darabonba.core.RequestConfiguration;
import darabonba.core.ServiceConfiguration;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.utils.CommonUtil;
import java.time.Duration;
import java.util.Optional;

public final class TeaConfiguration
implements Copyable {
    private final ClientConfiguration clientConfiguration;
    private final RequestConfiguration requestConfiguration;

    public TeaConfiguration(ClientConfiguration clientConfiguration, RequestConfiguration requestConfiguration) {
        this.clientConfiguration = clientConfiguration;
        this.requestConfiguration = requestConfiguration;
    }

    public static TeaConfiguration create() {
        return new TeaConfiguration(ClientConfiguration.create(), RequestConfiguration.create());
    }

    public String serviceName() {
        return this.clientConfiguration.option(ClientOption.SERVICE_NAME);
    }

    public String region() {
        return this.clientConfiguration.option(ClientOption.REGION);
    }

    public String endpoint() {
        return this.clientConfiguration.option(ClientOption.ENDPOINT);
    }

    public TeaConfiguration setEndpoint(String endpoint) {
        this.clientConfiguration.setOption(ClientOption.ENDPOINT, endpoint);
        return this;
    }

    public String endpointType() {
        return this.clientConfiguration.option(ClientOption.ENDPOINT_TYPE);
    }

    public ServiceConfiguration serviceConfiguration() {
        return this.clientConfiguration.option(ClientOption.SERVICE_CONFIGURATION);
    }

    public Duration connectTimeout() {
        if (CommonUtil.isUnset(this.requestConfiguration)) {
            return this.clientConfiguration.option(ClientOption.CONNECT_TIMEOUT);
        }
        return Optional.ofNullable(this.requestConfiguration.connectTimeout()).orElseGet(() -> this.clientConfiguration.option(ClientOption.CONNECT_TIMEOUT));
    }

    public Duration responseTimeout() {
        if (CommonUtil.isUnset(this.requestConfiguration)) {
            return this.clientConfiguration.option(ClientOption.RESPONSE_TIMEOUT);
        }
        return Optional.ofNullable(this.requestConfiguration.responseTimeout()).orElseGet(() -> this.clientConfiguration.option(ClientOption.RESPONSE_TIMEOUT));
    }

    public String protocol() {
        return Optional.ofNullable(this.clientConfiguration.option(ClientOption.HTTP_PROTOCOL)).orElseGet(() -> "https");
    }

    public HttpMethod method() {
        if (CommonUtil.isUnset(this.requestConfiguration)) {
            return this.clientConfiguration.option(ClientOption.HTTP_METHOD);
        }
        return Optional.ofNullable(this.requestConfiguration.httpMethod()).orElseGet(() -> this.clientConfiguration.option(ClientOption.HTTP_METHOD));
    }

    public HttpHeaders httpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        if (!CommonUtil.isUnset(this.clientConfiguration.option(ClientOption.ADDITIONAL_HTTP_HEADERS))) {
            headers.putAll(this.clientConfiguration.option(ClientOption.ADDITIONAL_HTTP_HEADERS));
        }
        if (!CommonUtil.isUnset(this.requestConfiguration) && !CommonUtil.isUnset(this.requestConfiguration.httpHeaders())) {
            headers.putAll(this.requestConfiguration.httpHeaders());
        }
        return headers;
    }

    public ICredentialProvider credentialProvider() {
        return this.clientConfiguration.option(ClientOption.CREDENTIALS_PROVIDER);
    }

    public ClientConfiguration clientConfiguration() {
        return this.clientConfiguration;
    }

    public RequestConfiguration requestConfiguration() {
        return this.requestConfiguration;
    }

    public TeaConfiguration copy() {
        return new TeaConfiguration(this.clientConfiguration.copy(), this.requestConfiguration.copy());
    }
}

