/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.internal.async;

import darabonba.core.async.AsyncRequestBody;
import darabonba.core.internal.async.NoopSubscription;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FileAsyncRequestBody
implements AsyncRequestBody {
    private static final int DEFAULT_CHUNK_SIZE = 16384;
    private final Path path;
    private final int chunkSizeInBytes;

    public FileAsyncRequestBody(Path path) {
        this(path, 16384);
    }

    public FileAsyncRequestBody(Path path, int chunkSizeInBytes) {
        this.path = path;
        this.chunkSizeInBytes = chunkSizeInBytes;
    }

    @Override
    public Optional<Long> contentLength() {
        try {
            return Optional.of(Files.size(this.path));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Optional<String> contentType() {
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Subscriber<? super ByteBuffer> s) {
        try {
            FileSubscription subscription;
            AsynchronousFileChannel channel = FileAsyncRequestBody.openInputChannel(this.path);
            FileSubscription fileSubscription = subscription = new FileSubscription(channel, s, this.chunkSizeInBytes);
            synchronized (fileSubscription) {
                s.onSubscribe((Subscription)subscription);
            }
        }
        catch (IOException e) {
            s.onSubscribe((Subscription)new NoopSubscription(s));
            s.onError((Throwable)e);
        }
    }

    private static AsynchronousFileChannel openInputChannel(Path path) throws IOException {
        return AsynchronousFileChannel.open(path, StandardOpenOption.READ);
    }

    private static final class FileSubscription
    implements Subscription {
        private final AsynchronousFileChannel inputChannel;
        private final Subscriber<? super ByteBuffer> subscriber;
        private final int chunkSize;
        private long position = 0L;
        private AtomicLong outstandingDemand = new AtomicLong(0L);
        private boolean writeInProgress = false;
        private volatile boolean done = false;

        private FileSubscription(AsynchronousFileChannel inputChannel, Subscriber<? super ByteBuffer> subscriber, int chunkSize) {
            this.inputChannel = inputChannel;
            this.subscriber = subscriber;
            this.chunkSize = chunkSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request(long n) {
            if (this.done) {
                return;
            }
            if (n < 1L) {
                IllegalArgumentException ex = new IllegalArgumentException(this.subscriber + " violated the Reactive Streams rule 3.9 by requesting a non-positive number of elements.");
                this.signalOnError(ex);
            } else {
                try {
                    this.outstandingDemand.getAndUpdate(initialDemand -> {
                        if (Long.MAX_VALUE - initialDemand < n) {
                            return Long.MAX_VALUE;
                        }
                        return initialDemand + n;
                    });
                    FileSubscription ex = this;
                    synchronized (ex) {
                        if (!this.writeInProgress) {
                            this.writeInProgress = true;
                            this.readData();
                        }
                    }
                }
                catch (Exception e) {
                    this.signalOnError(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            FileSubscription fileSubscription = this;
            synchronized (fileSubscription) {
                if (!this.done) {
                    this.done = true;
                    this.closeFile();
                }
            }
        }

        private void readData() {
            if (!this.inputChannel.isOpen()) {
                return;
            }
            ByteBuffer buffer = ByteBuffer.allocate(this.chunkSize);
            this.inputChannel.read(buffer, this.position, buffer, new CompletionHandler<Integer, ByteBuffer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void completed(Integer result, ByteBuffer attachment) {
                    if (result > 0) {
                        attachment.flip();
                        position = position + (long)attachment.remaining();
                        this.signalOnNext(attachment);
                        if (outstandingDemand.decrementAndGet() > 0L) {
                            this.readData();
                            return;
                        }
                    } else {
                        this.signalOnComplete();
                        this.closeFile();
                    }
                    FileSubscription fileSubscription = this;
                    synchronized (fileSubscription) {
                        writeInProgress = false;
                    }
                }

                @Override
                public void failed(Throwable exc, ByteBuffer attachment) {
                    this.signalOnError(exc);
                    this.closeFile();
                }
            });
        }

        private void closeFile() {
            try {
                this.inputChannel.close();
            }
            catch (IOException e) {
                this.signalOnError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void signalOnNext(ByteBuffer bb) {
            FileSubscription fileSubscription = this;
            synchronized (fileSubscription) {
                if (!this.done) {
                    this.subscriber.onNext((Object)bb);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void signalOnComplete() {
            FileSubscription fileSubscription = this;
            synchronized (fileSubscription) {
                if (!this.done) {
                    this.subscriber.onComplete();
                    this.done = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void signalOnError(Throwable t) {
            FileSubscription fileSubscription = this;
            synchronized (fileSubscription) {
                if (!this.done) {
                    this.subscriber.onError(t);
                    this.done = true;
                }
            }
        }
    }
}

