/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.core.logging;

import com.aliyun.core.logging.LogLevel;
import com.aliyun.core.utils.Configuration;
import com.aliyun.core.utils.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public final class DefaultLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = -144261058636441630L;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String WHITESPACE = " ";
    private static final String HYPHEN = " - ";
    private static final String OPEN_BRACKET = " [";
    private static final String CLOSE_BRACKET = "]";
    public static final String WARN = "WARN";
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String ERROR = "ERROR";
    public static final String TRACE = "TRACE";
    private final String classPath;
    private final boolean isTraceEnabled;
    private final boolean isDebugEnabled;
    private final boolean isInfoEnabled;
    private final boolean isWarnEnabled;
    private final boolean isErrorEnabled;

    public DefaultLogger(Class<?> clazz) {
        this(clazz.getName());
    }

    public DefaultLogger(String className) {
        String classPath;
        try {
            classPath = Class.forName(className).getCanonicalName();
        }
        catch (ClassNotFoundException e) {
            classPath = className;
        }
        this.classPath = classPath;
        int configuredLogLevel = LogLevel.fromString(!StringUtils.isEmpty(Configuration.getGlobalConfiguration().get("ALIBABA_CLOUD_SDK_LOG_LEVEL")) ? Configuration.getGlobalConfiguration().get("ALIBABA_CLOUD_SDK_LOG_LEVEL") : WARN).getLogLevel();
        this.isTraceEnabled = LogLevel.VERBOSE.getLogLevel() > configuredLogLevel;
        this.isDebugEnabled = LogLevel.VERBOSE.getLogLevel() >= configuredLogLevel;
        this.isInfoEnabled = LogLevel.INFORMATIONAL.getLogLevel() >= configuredLogLevel;
        this.isWarnEnabled = LogLevel.WARNING.getLogLevel() >= configuredLogLevel;
        this.isErrorEnabled = LogLevel.ERROR.getLogLevel() >= configuredLogLevel;
    }

    public String getName() {
        return this.classPath;
    }

    public boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    public void trace(String msg) {
        this.logMessageWithFormat(TRACE, msg, new Object[0]);
    }

    public void trace(String format, Object arg1) {
        this.logMessageWithFormat(TRACE, format, arg1);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(TRACE, format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.logMessageWithFormat(TRACE, format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.log(TRACE, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public void debug(String msg) {
        this.logMessageWithFormat(DEBUG, msg, new Object[0]);
    }

    public void debug(String format, Object arg) {
        this.logMessageWithFormat(DEBUG, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(DEBUG, format, arg1, arg2);
    }

    public void debug(String format, Object ... args) {
        this.logMessageWithFormat(DEBUG, format, args);
    }

    public void debug(String msg, Throwable t) {
        this.log(DEBUG, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isInfoEnabled;
    }

    public void info(String msg) {
        this.logMessageWithFormat(INFO, msg, new Object[0]);
    }

    public void info(String format, Object arg) {
        this.logMessageWithFormat(INFO, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(INFO, format, arg1, arg2);
    }

    public void info(String format, Object ... args) {
        this.logMessageWithFormat(INFO, format, args);
    }

    public void info(String msg, Throwable t) {
        this.log(INFO, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isWarnEnabled;
    }

    public void warn(String msg) {
        this.logMessageWithFormat(WARN, msg, new Object[0]);
    }

    public void warn(String format, Object arg) {
        this.logMessageWithFormat(WARN, format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(WARN, format, arg1, arg2);
    }

    public void warn(String format, Object ... args) {
        this.logMessageWithFormat(WARN, format, args);
    }

    public void warn(String msg, Throwable t) {
        this.log(WARN, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isErrorEnabled;
    }

    public void error(String format, Object arg) {
        this.logMessageWithFormat(ERROR, format, arg);
    }

    public void error(String msg) {
        this.logMessageWithFormat(ERROR, msg, new Object[0]);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(ERROR, format, arg1, arg2);
    }

    public void error(String format, Object ... args) {
        this.logMessageWithFormat(ERROR, format, args);
    }

    public void error(String msg, Throwable t) {
        this.log(ERROR, msg, t);
    }

    private void logMessageWithFormat(String levelName, String format, Object ... arguments) {
        FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.log(levelName, tp.getMessage(), tp.getThrowable());
    }

    private void log(String levelName, String message, Throwable t) {
        String dateTime = this.getFormattedDate();
        String threadName = Thread.currentThread().getName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(dateTime).append(OPEN_BRACKET).append(threadName).append(CLOSE_BRACKET).append(OPEN_BRACKET).append(levelName).append(CLOSE_BRACKET).append(WHITESPACE).append(this.classPath).append(HYPHEN).append(message).append(System.lineSeparator());
        this.writeWithThrowable(stringBuilder, t);
    }

    private String getFormattedDate() {
        LocalDateTime now = LocalDateTime.now();
        return DATE_FORMAT.format(now);
    }

    void writeWithThrowable(StringBuilder stringBuilder, Throwable t) {
        if (t != null) {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                t.printStackTrace(pw);
                stringBuilder.append(sw.toString());
            }
        }
    }
}

