/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dkms.gcs.openapi.util;

import com.aliyun.dkms.gcs.openapi.util.JsonUtils;
import com.aliyun.dkms.gcs.openapi.util.protobuf.ApiModels;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.utils.StringUtils;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Utils {
    public static final String SEPARATOR = "&";
    public static final String URL_ENCODING = "UTF-8";
    public static final String HASH_SHA256 = "SHA-256";
    private static final String HEXES_ARRAY = "0123456789ABCDEF";
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT = "-----END CERTIFICATE-----";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static String getHost(String regionId, String endpoint) {
        if (!StringUtils.isEmpty((CharSequence)endpoint)) {
            return endpoint;
        }
        if (StringUtils.isEmpty((CharSequence)regionId)) {
            regionId = "cn-hangzhou";
        }
        return "kms-instance." + regionId + ".aliyuncs.com";
    }

    public static Map<String, Object> getErrMessage(byte[] msg) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.Error response = ApiModels.Error.parseFrom(msg);
        result.put("Code", response.getErrorCode());
        result.put("Message", response.getErrorMessage());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static String getStringToSign(TeaRequest request) throws Exception {
        if (request == null) {
            return "";
        }
        String method = request.method;
        String pathname = request.pathname;
        Map headers = request.headers;
        Map query = request.query;
        String contentSHA256 = headers.get("content-sha256") == null ? "" : (String)headers.get("content-sha256");
        String contentType = headers.get("content-type") == null ? "" : (String)headers.get("content-type");
        String date = headers.get("date") == null ? "" : (String)headers.get("date");
        String header = method + "\n" + contentSHA256 + "\n" + contentType + "\n" + date + "\n";
        String canonicalizedHeaders = Utils.getCanonicalizedHeaders(headers);
        String canonicalizedResource = Utils.getCanonicalizedResource(pathname, query);
        return header + canonicalizedHeaders + canonicalizedResource;
    }

    protected static String getCanonicalizedHeaders(Map<String, String> headers) {
        if (headers == null) {
            return "";
        }
        String prefix = "x-kms-";
        Set<String> keys = headers.keySet();
        ArrayList<String> canonicalizedKeys = new ArrayList<String>();
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            canonicalizedKeys.add(key);
        }
        Object[] canonicalizedKeysArray = canonicalizedKeys.toArray(new String[canonicalizedKeys.size()]);
        Arrays.sort(canonicalizedKeysArray);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < canonicalizedKeysArray.length; ++i) {
            Object key = canonicalizedKeysArray[i];
            result.append((String)key);
            result.append(":");
            result.append(headers.get(key).trim());
            result.append("\n");
        }
        return result.toString();
    }

    protected static String getCanonicalizedResource(String pathname, Map<String, String> query) throws Exception {
        if (pathname == null) {
            return "/";
        }
        if (query == null || query.size() == 0) {
            return pathname;
        }
        String[] keys = query.keySet().toArray(new String[query.size()]);
        StringBuilder result = new StringBuilder(pathname);
        result.append("?");
        return Utils.getCanonicalizedQueryString(result, query, keys);
    }

    protected static String getCanonicalizedQueryString(StringBuilder sb, Map<String, String> query, String[] keys) throws Exception {
        if (query == null || query.size() == 0) {
            return "";
        }
        if (keys == null || keys.length == 0) {
            return "";
        }
        if (sb == null) {
            sb = new StringBuilder();
        }
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            sb.append(key);
            String value = query.get(key);
            if (!StringUtils.isEmpty((CharSequence)value)) {
                sb.append("=");
                sb.append(value);
            }
            sb.append(SEPARATOR);
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public static String getContentLength(byte[] reqBody) {
        return String.valueOf(reqBody.length);
    }

    public static String getContentSHA256(byte[] reqBody) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(HASH_SHA256);
        byte[] messageDigest = digest.digest(reqBody);
        return Utils.toHexString(messageDigest);
    }

    public static String toHexString(byte[] byteArray) {
        StringBuilder hex = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            hex.append(HEXES_ARRAY.charAt((b & 0xF0) >> 4)).append(HEXES_ARRAY.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static String getCaCertFromFile(String caFilePath) throws Exception {
        File file = JsonUtils.getFileByPath(caFilePath);
        if (!file.exists()) {
            throw new RuntimeException(String.format("ca certificate file[%s] not found", caFilePath));
        }
        try (FileInputStream is = new FileInputStream(file);){
            String string = Utils.readCaCertificate(is);
            return string;
        }
    }

    public static String getCaCertFromContent(byte[] caContent) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(caContent);
        return Utils.readCaCertificate(in);
    }

    public static String readCaCertificate(InputStream inStream) throws Exception {
        X509Certificate[] certificateChain;
        for (X509Certificate certificate : certificateChain = Utils.readCertificateChain(inStream)) {
            if (certificate.getIssuerDN().equals(certificate.getSubjectDN())) continue;
            return Utils.convertToPEM(certificate);
        }
        throw new RuntimeException("not found second CA certificate, expect sub CA certificate or CA certificate chain");
    }

    public static X509Certificate[] readCertificateChain(InputStream inStream) throws Exception {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certList = certFactory.generateCertificates(inStream);
        X509Certificate[] certs = new X509Certificate[certList.size()];
        return certList.toArray(certs);
    }

    public static String convertToPEM(X509Certificate cert) throws CertificateEncodingException {
        return BEGIN_CERT + LINE_SEPARATOR + Base64.getMimeEncoder(64, LINE_SEPARATOR.getBytes(StandardCharsets.UTF_8)).encodeToString(cert.getEncoded()) + LINE_SEPARATOR + END_CERT;
    }

    public static byte[] getSerializedEncryptRequest(Map<String, Object> reqBody) throws Exception {
        Object paddingMode;
        Object aad;
        Object iv;
        Object algorithm;
        Object plaintext;
        ApiModels.EncryptRequest.Builder builder = ApiModels.EncryptRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((plaintext = reqBody.get("Plaintext")) != null) {
            builder.setPlaintext(ByteString.copyFrom((byte[])((byte[])plaintext)));
        }
        if ((algorithm = reqBody.get("Algorithm")) != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((iv = reqBody.get("Iv")) != null) {
            builder.setIv(ByteString.copyFrom((byte[])((byte[])iv)));
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        if ((paddingMode = reqBody.get("PaddingMode")) != null) {
            builder.setPaddingMode((String)paddingMode);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseEncryptResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.EncryptResponse response = ApiModels.EncryptResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("CiphertextBlob", response.getCiphertextBlob().toByteArray());
        result.put("Iv", response.getIv().toByteArray());
        result.put("Algorithm", response.getAlgorithm());
        result.put("PaddingMode", response.getPaddingMode());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static byte[] getSerializedDecryptRequest(Map<String, Object> reqBody) throws Exception {
        Object paddingMode;
        Object iv;
        Object aad;
        Object algorithm;
        Object ciphertextBlob;
        ApiModels.DecryptRequest.Builder builder = ApiModels.DecryptRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((ciphertextBlob = reqBody.get("CiphertextBlob")) != null) {
            builder.setCiphertextBlob(ByteString.copyFrom((byte[])((byte[])ciphertextBlob)));
        }
        if ((algorithm = reqBody.get("Algorithm")) != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        if ((iv = reqBody.get("Iv")) != null) {
            builder.setIv(ByteString.copyFrom((byte[])((byte[])iv)));
        }
        if ((paddingMode = reqBody.get("PaddingMode")) != null) {
            builder.setPaddingMode((String)paddingMode);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseDecryptResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.DecryptResponse response = ApiModels.DecryptResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Plaintext", response.getPlaintext().toByteArray());
        result.put("Algorithm", response.getAlgorithm());
        result.put("PaddingMode", response.getPaddingMode());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static byte[] getSerializedHmacRequest(Map<String, Object> reqBody) throws Exception {
        Object message;
        ApiModels.HmacRequest.Builder builder = ApiModels.HmacRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((message = reqBody.get("Message")) != null) {
            builder.setMessage(ByteString.copyFrom((byte[])((byte[])message)));
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseHmacResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.HmacResponse response = ApiModels.HmacResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Signature", response.getSignature().toByteArray());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static byte[] getSerializedSignRequest(Map<String, Object> reqBody) throws Exception {
        Object messageType;
        Object message;
        Object algorithm;
        ApiModels.SignRequest.Builder builder = ApiModels.SignRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((algorithm = reqBody.get("Algorithm")) != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((message = reqBody.get("Message")) != null) {
            builder.setMessage(ByteString.copyFrom((byte[])((byte[])message)));
        }
        if ((messageType = reqBody.get("MessageType")) != null) {
            builder.setMessageType((String)messageType);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseSignResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.SignResponse response = ApiModels.SignResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Signature", response.getSignature().toByteArray());
        result.put("Algorithm", response.getAlgorithm());
        result.put("MessageType", response.getMessageType());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static byte[] getSerializedVerifyRequest(Map<String, Object> reqBody) throws Exception {
        Object messageType;
        Object message;
        Object signature;
        Object algorithm;
        ApiModels.VerifyRequest.Builder builder = ApiModels.VerifyRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((algorithm = reqBody.get("Algorithm")) != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((signature = reqBody.get("Signature")) != null) {
            builder.setSignature(ByteString.copyFrom((byte[])((byte[])signature)));
        }
        if ((message = reqBody.get("Message")) != null) {
            builder.setMessage(ByteString.copyFrom((byte[])((byte[])message)));
        }
        if ((messageType = reqBody.get("MessageType")) != null) {
            builder.setMessageType((String)messageType);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseVerifyResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.VerifyResponse response = ApiModels.VerifyResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Value", response.getValue());
        result.put("Algorithm", response.getAlgorithm());
        result.put("MessageType", response.getMessageType());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static byte[] getSerializedGenerateRandomRequest(Map<String, Object> reqBody) throws Exception {
        ApiModels.GenerateRandomRequest.Builder builder = ApiModels.GenerateRandomRequest.newBuilder();
        Object length = reqBody.get("Length");
        if (length != null) {
            builder.setLength((Integer)length);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseGenerateRandomResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.GenerateRandomResponse response = ApiModels.GenerateRandomResponse.parseFrom(resBody);
        result.put("Random", response.getRandom().toByteArray());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static byte[] getSerializedGenerateDataKeyRequest(Map<String, Object> reqBody) throws Exception {
        Object aad;
        Object numberOfBytes;
        Object algorithm;
        ApiModels.GenerateDataKeyRequest.Builder builder = ApiModels.GenerateDataKeyRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((algorithm = reqBody.get("Algorithm")) != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((numberOfBytes = reqBody.get("NumberOfBytes")) != null) {
            builder.setNumberOfBytes((Integer)numberOfBytes);
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseGenerateDataKeyResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.GenerateDataKeyResponse response = ApiModels.GenerateDataKeyResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Iv", response.getIv().toByteArray());
        result.put("Plaintext", response.getPlaintext().toByteArray());
        result.put("CiphertextBlob", response.getCiphertextBlob().toByteArray());
        result.put("Algorithm", response.getAlgorithm());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static byte[] getSerializedHashRequest(Map<String, Object> reqBody) throws Exception {
        Object message;
        ApiModels.HashRequest.Builder builder = ApiModels.HashRequest.newBuilder();
        Object algorithm = reqBody.get("Algorithm");
        if (algorithm != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((message = reqBody.get("Message")) != null) {
            builder.setMessage(ByteString.copyFrom((byte[])((byte[])message)));
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseHashResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.HashResponse response = ApiModels.HashResponse.parseFrom(resBody);
        result.put("Digest", response.getDigest().toByteArray());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static byte[] getSerializedKmsEncryptRequest(Map<String, Object> reqBody) throws Exception {
        Object aad;
        Object keyId;
        ApiModels.KmsEncryptRequest.Builder builder = ApiModels.KmsEncryptRequest.newBuilder();
        Object plaintext = reqBody.get("Plaintext");
        if (plaintext != null) {
            builder.setPlaintext(ByteString.copyFrom((byte[])((byte[])plaintext)));
        }
        if ((keyId = reqBody.get("KeyId")) != null) {
            builder.setKeyId((String)keyId);
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseKmsEncryptResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.KmsEncryptResponse response = ApiModels.KmsEncryptResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("CiphertextBlob", response.getCiphertextBlob().toByteArray());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static byte[] getSerializedKmsDecryptRequest(Map<String, Object> reqBody) throws Exception {
        Object aad;
        ApiModels.KmsDecryptRequest.Builder builder = ApiModels.KmsDecryptRequest.newBuilder();
        Object ciphertextBlob = reqBody.get("CiphertextBlob");
        if (ciphertextBlob != null) {
            builder.setCiphertextBlob(ByteString.copyFrom((byte[])((byte[])ciphertextBlob)));
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseKmsDecryptResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.KmsDecryptResponse response = ApiModels.KmsDecryptResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Plaintext", response.getPlaintext().toByteArray());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static byte[] getSerializedGetPublicKeyRequest(Map<String, Object> reqBody) throws Exception {
        ApiModels.GetPublicKeyRequest.Builder builder = ApiModels.GetPublicKeyRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseGetPublicKeyResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.GetPublicKeyResponse response = ApiModels.GetPublicKeyResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("PublicKey", response.getPublicKey());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static byte[] getSerializedGetSecretValueRequest(Map<String, Object> reqBody) throws Exception {
        Object fetchExtendedConfig;
        Object versionId;
        Object versionStage;
        ApiModels.GetSecretValueRequest.Builder builder = ApiModels.GetSecretValueRequest.newBuilder();
        Object secretName = reqBody.get("SecretName");
        if (secretName != null) {
            builder.setSecretName((String)secretName);
        }
        if ((versionStage = reqBody.get("VersionStage")) != null) {
            builder.setVersionStage((String)versionStage);
        }
        if ((versionId = reqBody.get("VersionId")) != null) {
            builder.setVersionId((String)versionId);
        }
        if ((fetchExtendedConfig = reqBody.get("FetchExtendedConfig")) != null) {
            builder.setFetchExtendedConfig((Boolean)fetchExtendedConfig);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseGetSecretValueResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.GetSecretValueResponse response = ApiModels.GetSecretValueResponse.parseFrom(resBody);
        result.put("SecretName", response.getSecretName());
        result.put("SecretType", response.getSecretType());
        result.put("SecretData", response.getSecretData());
        result.put("SecretDataType", response.getSecretDataType());
        result.put("VersionStages", response.getVersionStagesList());
        result.put("VersionId", response.getVersionId());
        result.put("CreateTime", response.getCreateTime());
        result.put("LastRotationDate", response.getLastRotationDate());
        result.put("NextRotationDate", response.getNextRotationDate());
        result.put("ExtendedConfig", response.getExtendedConfig());
        result.put("AutomaticRotation", response.getAutomaticRotation());
        result.put("RotationInterval", response.getRotationInterval());
        result.put("RequestId", response.getRequestId());
        return result;
    }
}

