/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.support.runner;

import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.support.common.DelegateArkContainer;
import com.alipay.sofa.ark.support.runner.JUnitExecutionListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

public class ArkJUnit4EmbedRunner
extends BlockJUnit4ClassRunner {
    public ArkJUnit4EmbedRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected TestClass createTestClass(Class<?> testClass) {
        try {
            if (!DelegateArkContainer.isStarted()) {
                System.setProperty("sofa.ark.embed.enable", "true");
                System.setProperty("com.alipay.sofa.ark.master.biz", "test master biz");
                DelegateArkContainer.launch(testClass);
                System.clearProperty("sofa.ark.embed.enable");
                System.clearProperty("com.alipay.sofa.ark.master.biz");
            }
            ClassLoader testClassLoader = DelegateArkContainer.getTestClassLoader();
            TestClass testKlazz = super.createTestClass(testClassLoader.loadClass(testClass.getName()));
            ClassLoaderUtils.pushContextClassLoader((ClassLoader)ClassLoader.getSystemClassLoader());
            return testKlazz;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void run(RunNotifier notifier) {
        notifier.addListener(JUnitExecutionListener.getRunListener());
        super.run(notifier);
    }
}

