/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.support.common;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.api.ArkConfigs;
import com.alipay.sofa.ark.common.util.FileUtils;
import com.alipay.sofa.ark.loader.JarBizArchive;
import com.alipay.sofa.ark.loader.archive.JarFileArchive;
import com.alipay.sofa.ark.spi.archive.Archive;
import com.alipay.sofa.ark.spi.archive.BizArchive;
import com.alipay.sofa.ark.spi.service.biz.AddBizToStaticDeployHook;
import com.alipay.sofa.ark.spi.service.extension.Extension;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

@Extension(value="add-biz-in-resources-to-deploy")
public class AddBizInResourcesHook
implements AddBizToStaticDeployHook {
    public List<BizArchive> getStaticBizToAdd() throws Exception {
        ArrayList<BizArchive> archives = new ArrayList<BizArchive>();
        if (ArkConfigs.isEmbedEnable() && this.isEmbedStaticBizInResourceEnable()) {
            archives.addAll(this.getBizArchiveFromResources());
        }
        return archives;
    }

    private boolean isEmbedStaticBizInResourceEnable() {
        return ArkConfigs.getBooleanValue((String)"sofa.ark.embed.static.biz.in.resource.enable", (boolean)Boolean.TRUE);
    }

    protected List<BizArchive> getBizArchiveFromResources() throws Exception {
        ArrayList<BizArchive> archives = new ArrayList<BizArchive>();
        URL bizDirURL = ArkClient.getMasterBiz().getBizClassLoader().getResource("SOFA-ARK/biz/");
        if (null == bizDirURL) {
            return archives;
        }
        if (bizDirURL.getProtocol().equals("file")) {
            return this.getBizArchiveForFile(bizDirURL);
        }
        if (bizDirURL.getProtocol().equals("jar")) {
            return this.getBizArchiveForJar(bizDirURL);
        }
        return archives;
    }

    private List<BizArchive> getBizArchiveForFile(URL bizDirURL) throws Exception {
        ArrayList<BizArchive> archives = new ArrayList<BizArchive>();
        File bizDir = org.apache.commons.io.FileUtils.toFile((URL)bizDirURL);
        if (!bizDir.exists() || !bizDir.isDirectory() || null == bizDir.listFiles()) {
            return archives;
        }
        for (File bizFile : bizDir.listFiles()) {
            archives.add((BizArchive)new JarBizArchive((Archive)new JarFileArchive(bizFile)));
        }
        return archives;
    }

    private List<BizArchive> getBizArchiveForJar(URL bizDirURL) throws Exception {
        ArrayList<BizArchive> archives = new ArrayList<BizArchive>();
        JarFileArchive jarFileArchive = this.getJarFileArchiveFromUrl(bizDirURL);
        String prefix = this.getEntryName(bizDirURL);
        List archivesFromJar = jarFileArchive.getNestedArchives(entry -> !entry.isDirectory() && entry.getName().startsWith(prefix) && !entry.getName().equals(prefix));
        for (Archive archiveFromJarEntry : archivesFromJar) {
            archives.add((BizArchive)new JarBizArchive(archiveFromJarEntry));
        }
        return archives;
    }

    private JarFileArchive getJarFileArchiveFromUrl(URL url) throws Exception {
        String jarPath = AddBizInResourcesHook.substringBefore(((JarURLConnection)url.openConnection()).getJarFile().getName(), "!");
        return new JarFileArchive(FileUtils.file((String)jarPath));
    }

    private String getEntryName(URL url) throws IOException {
        String classPathEntryName = AddBizInResourcesHook.substringAfter(((JarURLConnection)url.openConnection()).getJarFile().getName(), "!/");
        String urlEntryNameFromClassPath = ((JarURLConnection)url.openConnection()).getJarEntry().getName();
        return String.join((CharSequence)"/", classPathEntryName, urlEntryNameFromClassPath);
    }

    public static String substringBefore(String str, String separator) {
        if (str != null && separator != null && str.length() != 0) {
            if (separator.length() == 0) {
                return "";
            }
            int pos = str.indexOf(separator);
            return pos == -1 ? str : str.substring(0, pos);
        }
        return str;
    }

    public static String substringAfter(String str, String separator) {
        if (str != null && str.length() != 0) {
            if (separator == null) {
                return "";
            }
            int pos = str.indexOf(separator);
            return pos == -1 ? "" : str.substring(pos + separator.length());
        }
        return str;
    }
}

