/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.springboot.listener;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.api.ArkConfigs;
import com.alipay.sofa.ark.spi.event.AfterFinishDeployEvent;
import com.alipay.sofa.ark.spi.event.AfterFinishStartupEvent;
import com.alipay.sofa.ark.spi.event.ArkEvent;
import com.alipay.sofa.ark.spi.event.biz.AfterBizStartupEvent;
import com.alipay.sofa.ark.support.common.MasterBizEnvironmentHolder;
import com.alipay.sofa.ark.support.startup.EmbedSofaArkBootstrap;
import com.alipay.sofa.ark.support.startup.SofaArkBootstrap;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.SpringApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;

public class ArkApplicationStartListener
implements ApplicationListener<SpringApplicationEvent> {
    private static final String LAUNCH_CLASSLOADER_NAME = "sun.misc.Launcher$AppClassLoader";
    private static final String SPRING_BOOT_LOADER = "org.springframework.boot.loader.LaunchedURLClassLoader";
    private static final String SPRING_BOOT_NEW_LOADER = "org.springframework.boot.loader.launch.LaunchedClassLoader";
    private static final String APPLICATION_STARTED_EVENT = "org.springframework.boot.context.event.ApplicationStartedEvent";
    private static final String APPLICATION_STARTING_EVENT = "org.springframework.boot.context.event.ApplicationStartingEvent";
    private static Class<?> SPRING_BOOT_LOADER_CLASS;
    private static Class<?> SPRING_BOOT_NEW_LOADER_CLASS;

    public void onApplicationEvent(SpringApplicationEvent event) {
        try {
            if (this.isEmbedEnable()) {
                ArkConfigs.setEmbedEnable((boolean)true);
                this.startUpArkEmbed(event);
                return;
            }
            if (this.isSpringBoot2() && APPLICATION_STARTING_EVENT.equals(event.getClass().getCanonicalName())) {
                this.startUpArk(event);
            }
            if (this.isSpringBoot1() && APPLICATION_STARTED_EVENT.equals(event.getClass().getCanonicalName())) {
                this.startUpArk(event);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Meet exception when determine whether to start SOFAArk!", e);
        }
    }

    private boolean isEmbedEnable() {
        if (ArkConfigs.isEmbedEnable()) {
            return true;
        }
        if (SPRING_BOOT_LOADER_CLASS != null && SPRING_BOOT_LOADER_CLASS.isAssignableFrom(this.getClass().getClassLoader().getClass())) {
            return true;
        }
        return SPRING_BOOT_NEW_LOADER_CLASS != null && SPRING_BOOT_NEW_LOADER_CLASS.isAssignableFrom(this.getClass().getClassLoader().getClass());
    }

    public void startUpArk(SpringApplicationEvent event) {
        if (LAUNCH_CLASSLOADER_NAME.equals(this.getClass().getClassLoader().getClass().getName())) {
            SofaArkBootstrap.launch((String[])event.getArgs());
        }
    }

    public boolean isSpringBoot1() {
        String version = SpringBootVersion.getVersion();
        return null == version ? false : version.startsWith("1");
    }

    public boolean isSpringBoot2() {
        String version = SpringBootVersion.getVersion();
        return null == version ? false : version.startsWith("2");
    }

    protected void startUpArkEmbed(SpringApplicationEvent event) {
        if (this.getClass().getClassLoader() != Thread.currentThread().getContextClassLoader()) {
            return;
        }
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            ApplicationEnvironmentPreparedEvent preparedEvent = (ApplicationEnvironmentPreparedEvent)event;
            MasterBizEnvironmentHolder.setEnvironment((Environment)preparedEvent.getEnvironment());
            EmbedSofaArkBootstrap.launch((Environment)preparedEvent.getEnvironment());
        }
        if (event instanceof ApplicationReadyEvent) {
            this.sendEventAfterArkEmbedStartupFinish();
        }
    }

    protected void sendEventAfterArkEmbedStartupFinish() {
        if (ArkClient.getEventAdminService() != null && ArkClient.getMasterBiz() != null) {
            ArkClient.getEventAdminService().sendEvent((ArkEvent)new AfterBizStartupEvent(ArkClient.getMasterBiz()));
            ArkClient.getEventAdminService().sendEvent((ArkEvent)new AfterFinishDeployEvent());
            ArkClient.getEventAdminService().sendEvent((ArkEvent)new AfterFinishStartupEvent());
        }
    }

    static {
        try {
            SPRING_BOOT_LOADER_CLASS = ApplicationListener.class.getClassLoader().loadClass(SPRING_BOOT_LOADER);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            SPRING_BOOT_NEW_LOADER_CLASS = ApplicationListener.class.getClassLoader().loadClass(SPRING_BOOT_NEW_LOADER);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

