/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.session;

import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.common.util.EnvironmentUtils;
import com.alipay.sofa.ark.container.session.handler.ArkCommandHandler;
import com.alipay.sofa.ark.spi.constant.Constants;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.concurrent.Executor;

public class NettyTelnetServer {
    private int port;
    private ServerBootstrap serverBootstrap;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;

    public NettyTelnetServer(int port, Executor executor) {
        this.port = port;
        this.bossGroup = new NioEventLoopGroup(1, executor);
        this.workerGroup = new NioEventLoopGroup(1, executor);
    }

    public void open() throws InterruptedException {
        this.serverBootstrap = new ServerBootstrap();
        this.serverBootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
        ((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new NettyTelnetInitializer());
        this.channel = this.serverBootstrap.bind(this.port).sync().channel();
    }

    public void close() {
        this.channel.close();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    static class NettyTelnetHandler
    extends SimpleChannelInboundHandler<String> {
        private static ArkCommandHandler arkCommandHandler = new ArkCommandHandler();

        NettyTelnetHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            ctx.write((Object)arkCommandHandler.promptMessage());
            ctx.flush();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ArkLoggerFactory.getDefaultLogger().error("Error occurs in netty telnet server.", cause);
            super.exceptionCaught(ctx, cause);
        }

        protected void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
            if (Constants.CHANNEL_QUIT.contains(msg)) {
                ctx.channel().close();
                return;
            }
            ctx.write((Object)arkCommandHandler.responseMessage(msg));
            ctx.flush();
        }
    }

    static class NettyTelnetInitializer
    extends ChannelInitializer<SocketChannel> {
        private static StringDecoder DECODER = new StringDecoder();
        private static StringEncoder ENCODER = new StringEncoder();

        NettyTelnetInitializer() {
        }

        protected void initChannel(SocketChannel channel) throws Exception {
            if (EnvironmentUtils.isOpenSecurity() && !channel.remoteAddress().getHostName().equals("localhost")) {
                return;
            }
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(8192, Delimiters.lineDelimiter())});
            pipeline.addLast(new ChannelHandler[]{ENCODER});
            pipeline.addLast(new ChannelHandler[]{DECODER});
            pipeline.addLast(new ChannelHandler[]{new NettyTelnetHandler()});
        }
    }
}

