/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.retrieval;

import com.alipay.sofa.ark.container.service.retrieval.ClassInfoVO;
import com.alipay.sofa.ark.container.service.retrieval.ViewRender;
import java.lang.reflect.Modifier;
import java.security.CodeSource;
import java.util.ArrayList;

public class ClassInfoMethod {
    private static final String EMPTY_STRING = "";

    private static String getCodeSource(CodeSource cs) {
        if (null == cs || null == cs.getLocation() || null == cs.getLocation().getFile()) {
            return EMPTY_STRING;
        }
        return cs.getLocation().getFile();
    }

    private static String getClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            StringBuilder sb = new StringBuilder(clazz.getName());
            sb.delete(0, 2);
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ';') {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("[]");
            return sb.toString();
        }
        return clazz.getName();
    }

    private static String getModifier(int mod, char splitter) {
        StringBuilder sb = new StringBuilder();
        if (Modifier.isAbstract(mod)) {
            sb.append("abstract").append(splitter);
        }
        if (Modifier.isFinal(mod)) {
            sb.append("final").append(splitter);
        }
        if (Modifier.isInterface(mod)) {
            sb.append("interface").append(splitter);
        }
        if (Modifier.isNative(mod)) {
            sb.append("native").append(splitter);
        }
        if (Modifier.isPrivate(mod)) {
            sb.append("private").append(splitter);
        }
        if (Modifier.isProtected(mod)) {
            sb.append("protected").append(splitter);
        }
        if (Modifier.isPublic(mod)) {
            sb.append("public").append(splitter);
        }
        if (Modifier.isStatic(mod)) {
            sb.append("static").append(splitter);
        }
        if (Modifier.isStrict(mod)) {
            sb.append("strict").append(splitter);
        }
        if (Modifier.isSynchronized(mod)) {
            sb.append("synchronized").append(splitter);
        }
        if (Modifier.isTransient(mod)) {
            sb.append("transient").append(splitter);
        }
        if (Modifier.isVolatile(mod)) {
            sb.append("volatile").append(splitter);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private static String[] getSuperClass(Class clazz) {
        ArrayList<String> list = new ArrayList<String>();
        Class superClass = clazz.getSuperclass();
        if (null != superClass) {
            list.add(ClassInfoMethod.getClassName(superClass));
            while (null != (superClass = superClass.getSuperclass())) {
                list.add(ClassInfoMethod.getClassName(superClass));
            }
        }
        return list.toArray(new String[0]);
    }

    private static String[] getClassloader(Class clazz) {
        ArrayList<String> list = new ArrayList<String>();
        ClassLoader loader = clazz.getClassLoader();
        if (null != loader) {
            list.add(loader.toString());
            while (null != (loader = loader.getParent())) {
                list.add(loader.toString());
            }
        }
        return list.toArray(new String[0]);
    }

    public static String createClassInfo(Class<?> clazz, String bizName) {
        ClassInfoVO classInfo = new ClassInfoVO();
        classInfo.setClassInfo(ClassInfoMethod.getClassName(clazz));
        classInfo.setCodeSource(ClassInfoMethod.getCodeSource(clazz.getProtectionDomain().getCodeSource()));
        classInfo.setInterface(clazz.isInterface());
        classInfo.setAnnotation(clazz.isAnnotation());
        classInfo.setEnum(clazz.isEnum());
        classInfo.setContainerName(bizName);
        classInfo.setSimpleName(clazz.getSimpleName());
        classInfo.setModifier(ClassInfoMethod.getModifier(clazz.getModifiers(), ','));
        classInfo.setSuperClass(ClassInfoMethod.getSuperClass(clazz));
        classInfo.setClassloader(ClassInfoMethod.getClassloader(clazz));
        return ViewRender.renderClassInfo(classInfo);
    }
}

