/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.registry;

import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.OrderComparator;
import com.alipay.sofa.ark.container.registry.DefaultServiceFilter;
import com.alipay.sofa.ark.container.registry.ServiceMetadataImpl;
import com.alipay.sofa.ark.container.registry.ServiceReferenceImpl;
import com.alipay.sofa.ark.spi.registry.ServiceFilter;
import com.alipay.sofa.ark.spi.registry.ServiceProvider;
import com.alipay.sofa.ark.spi.registry.ServiceReference;
import com.alipay.sofa.ark.spi.service.injection.InjectionService;
import com.alipay.sofa.ark.spi.service.registry.RegistryService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;

@Singleton
public class RegistryServiceImpl
implements RegistryService {
    private CopyOnWriteArraySet<ServiceReference<?>> services = new CopyOnWriteArraySet();
    private OrderComparator orderComparator = new OrderComparator();
    @Inject
    private InjectionService injectionService;

    public <T> ServiceReference<T> publishService(Class<T> ifClass, T implObject, ServiceProvider serviceProvider) {
        return this.publishService(ifClass, implObject, "", serviceProvider);
    }

    public <T> ServiceReference<T> publishService(Class<T> ifClass, T implObject, String uniqueId, ServiceProvider serviceProvider) {
        AssertUtils.assertNotNull(ifClass, (String)"Service interface should not be null.");
        AssertUtils.assertNotNull(implObject, (String)"Service implementation should not be null.");
        AssertUtils.assertNotNull((Object)uniqueId, (String)"Service uniqueId should not be null.");
        AssertUtils.assertNotNull((Object)serviceProvider, (String)"ServiceProvider should not be null.");
        ServiceMetadataImpl serviceMetadata = new ServiceMetadataImpl(ifClass, uniqueId, serviceProvider);
        for (ServiceReference<?> serviceReference : this.services) {
            if (!((Object)serviceMetadata).equals(serviceReference.getServiceMetadata())) continue;
            ArkLoggerFactory.getDefaultLogger().warn(String.format("Service: %s publish by: %s already exist", serviceMetadata.getServiceName(), serviceProvider));
            return serviceReference;
        }
        ServiceReferenceImpl<T> serviceReference = new ServiceReferenceImpl<T>(serviceMetadata, implObject);
        this.injectionService.inject(serviceReference);
        ArkLoggerFactory.getDefaultLogger().info(String.format("Service: %s publish by: %s succeed", serviceMetadata.getServiceName(), serviceProvider));
        this.services.add(serviceReference);
        return serviceReference;
    }

    public <T> ServiceReference<T> referenceService(Class<T> ifClass) {
        return this.referenceService(ifClass, "");
    }

    public <T> ServiceReference<T> referenceService(Class<T> ifClass, String uniqueId) {
        List<ServiceReference<T>> references = this.referenceServices(ifClass, uniqueId);
        return references.isEmpty() ? null : references.get(0);
    }

    public <T> List<ServiceReference<T>> referenceServices(Class<T> ifClass) {
        return this.referenceServices(ifClass, "");
    }

    public <T> List<ServiceReference<T>> referenceServices(Class<T> ifClass, String uniqueId) {
        DefaultServiceFilter defaultServiceFilter = new DefaultServiceFilter();
        defaultServiceFilter.setServiceInterface(ifClass).setUniqueId(uniqueId);
        List references = this.referenceServices(defaultServiceFilter);
        return references;
    }

    public <T> List<ServiceReference<T>> referenceServices(ServiceFilter<T> serviceFilter) {
        ArrayList<ServiceReference<T>> serviceReferences = new ArrayList<ServiceReference<T>>();
        for (ServiceReference<?> reference : this.services) {
            if (!serviceFilter.match(reference)) continue;
            serviceReferences.add(reference);
        }
        Collections.sort(serviceReferences, this.orderComparator);
        return serviceReferences;
    }

    public int unPublishServices(ServiceFilter serviceFilter) {
        int count = 0;
        for (ServiceReference<?> reference : this.services) {
            if (!serviceFilter.match(reference)) continue;
            this.services.remove(reference);
            ++count;
        }
        return count;
    }
}

