/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.extension;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.api.ArkConfigs;
import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.container.service.ArkServiceContainerHolder;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.Plugin;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import com.alipay.sofa.ark.spi.service.extension.Extensible;
import com.alipay.sofa.ark.spi.service.extension.Extension;
import com.alipay.sofa.ark.spi.service.extension.ExtensionClass;
import com.alipay.sofa.ark.spi.service.extension.ExtensionLoaderService;
import com.alipay.sofa.ark.spi.service.plugin.PluginManagerService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;

@Singleton
public class ExtensionLoaderServiceImpl
implements ExtensionLoaderService {
    private PluginManagerService pluginManagerService = ArkServiceContainerHolder.getContainer().getService(PluginManagerService.class);
    private BizManagerService bizManagerService = ArkServiceContainerHolder.getContainer().getService(BizManagerService.class);

    public <T> T getExtensionContributorFromArkPlugin(Class<T> interfaceType, String extensionName, String pluginName) {
        AssertUtils.assertNotNull(interfaceType, (String)"interfaceType can't be null.");
        AssertUtils.assertNotNull((Object)extensionName, (String)"extensionName can't be null.");
        AssertUtils.assertNotNull((Object)pluginName, (String)"pluginName can't be null.");
        Plugin plugin = this.pluginManagerService.getPluginByName(pluginName);
        AssertUtils.assertNotNull((Object)plugin, (String)("plugin: " + pluginName + " is null"));
        return this.getExtensionContributor(interfaceType, extensionName, plugin, plugin.getPluginClassLoader());
    }

    public <T> T getExtensionContributorFromArkBiz(Class<T> interfaceType, String extensionName, String bizIdentity) {
        AssertUtils.assertNotNull(interfaceType, (String)"interfaceType can't be null.");
        AssertUtils.assertNotNull((Object)extensionName, (String)"extensionName can't be null.");
        AssertUtils.assertNotNull((Object)bizIdentity, (String)"bizIdentity can't be null.");
        Biz biz = this.bizManagerService.getBizByIdentity(bizIdentity);
        AssertUtils.assertNotNull((Object)biz, (String)("biz: " + bizIdentity + " is null"));
        return this.getExtensionContributor(interfaceType, extensionName, biz, biz.getBizClassLoader());
    }

    public <T> List<T> getExtensionContributorsFromArkBiz(Class<T> interfaceType, String bizIdentity) {
        AssertUtils.assertNotNull(interfaceType, (String)"interfaceType can't be null.");
        AssertUtils.assertNotNull((Object)bizIdentity, (String)"bizIdentity can't be null.");
        Biz biz = this.bizManagerService.getBizByIdentity(bizIdentity);
        AssertUtils.assertNotNull((Object)biz, (String)("biz: " + bizIdentity + " is null"));
        return this.getExtensionContributors(interfaceType, biz, biz.getBizClassLoader());
    }

    public <T, L> T getExtensionContributor(Class<T> interfaceType, String extensionName, L location, ClassLoader resourceLoader) {
        ExtensionClass<T, L> extensionClass = null;
        try {
            Set<ExtensionClass<T, L>> extensionClassSet = this.loadExtension(interfaceType, extensionName, location, resourceLoader);
            for (ExtensionClass<T, L> extensionClazz : extensionClassSet) {
                if (extensionClass != null && extensionClass.getPriority() <= extensionClazz.getPriority()) continue;
                extensionClass = extensionClazz;
            }
        }
        catch (Throwable throwable) {
            ArkLoggerFactory.getDefaultLogger().error("Loading extension of interfaceType: {} occurs error {}.", interfaceType, (Object)throwable);
            throw new ArkRuntimeException(throwable);
        }
        return (T)(extensionClass == null ? null : extensionClass.getObject());
    }

    public <T, L> List<T> getExtensionContributors(Class<T> interfaceType, L location, ClassLoader resourceLoader) {
        try {
            Set<ExtensionClass<T, L>> extensionClassSet = this.loadExtensions(interfaceType, location, resourceLoader);
            HashMap<String, ExtensionClass<T, L>> nameToExtensionClass = new HashMap<String, ExtensionClass<T, L>>();
            for (ExtensionClass<T, L> extensionClazz : extensionClassSet) {
                if (extensionClazz == null) continue;
                String extensionName = extensionClazz.getExtension().value();
                nameToExtensionClass.putIfAbsent(extensionName, extensionClazz);
                if (extensionClazz.getPriority() <= ((ExtensionClass)nameToExtensionClass.get(extensionName)).getPriority()) continue;
                nameToExtensionClass.put(extensionName, extensionClazz);
            }
            return nameToExtensionClass.values().stream().map(it -> it.getObject()).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            ArkLoggerFactory.getDefaultLogger().error("Loading extension of interfaceType: {} occurs error {}.", interfaceType, (Object)throwable);
            throw new ArkRuntimeException(throwable);
        }
    }

    private <I, L> Set<ExtensionClass<I, L>> loadExtension(Class<I> interfaceType, String extensionName, L location, ClassLoader resourceLoader) throws Throwable {
        Set<ExtensionClass<I, L>> extensionClassSet = this.loadExtensions(interfaceType, location, resourceLoader);
        return extensionClassSet.stream().filter(it -> extensionName.equals(it.getExtension().value())).collect(Collectors.toSet());
    }

    private <I, L> Set<ExtensionClass<I, L>> loadExtensions(Class<I> interfaceType, L location, ClassLoader resourceLoader) throws Throwable {
        try (BufferedReader reader = null;){
            HashSet<ExtensionClass<I, L>> extensionClassSet = new HashSet<ExtensionClass<I, L>>();
            Extensible extensible = interfaceType.getAnnotation(Extensible.class);
            if (extensible == null) {
                throw new ArkRuntimeException(String.format("Extensible class %s is not annotated by %s.", interfaceType, Extensible.class));
            }
            String fileName = interfaceType.getCanonicalName();
            if (!StringUtils.isEmpty((String)extensible.file())) {
                fileName = extensible.file();
            }
            Enumeration<URL> enumeration = resourceLoader.getResources("META-INF/services/sofa-ark/" + fileName);
            while (enumeration.hasMoreElements()) {
                String line;
                URL url = enumeration.nextElement();
                if (ArkLoggerFactory.getDefaultLogger().isDebugEnabled()) {
                    ArkLoggerFactory.getDefaultLogger().debug("Loading extension of extensible: {} from location: {} and file: {}", new Object[]{interfaceType, location, url});
                }
                reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    ExtensionClass extensionClass = new ExtensionClass();
                    extensionClass.setDefinedLocation(location);
                    extensionClass.setExtensible(extensible);
                    extensionClass.setInterfaceClass(interfaceType);
                    Class<?> implementClass = null;
                    String clazzName = line.trim();
                    try {
                        implementClass = resourceLoader.loadClass(clazzName);
                    }
                    catch (Exception e) {
                        if (ArkConfigs.isEmbedEnable() && resourceLoader != ArkClient.getMasterBiz().getBizClassLoader()) {
                            implementClass = ArkClient.getMasterBiz().getBizClassLoader().loadClass(clazzName);
                        }
                        throw e;
                    }
                    if (!interfaceType.isAssignableFrom(implementClass)) {
                        throw new ArkRuntimeException(String.format("Extension implementation class %s is not type of %s.", implementClass.getCanonicalName(), interfaceType.getCanonicalName()));
                    }
                    Extension extension = implementClass.getAnnotation(Extension.class);
                    if (extension == null) {
                        throw new ArkRuntimeException(String.format("Extension implementation class %s is not annotated by %s.", implementClass, Extension.class));
                    }
                    extensionClass.setExtension(extension);
                    extensionClass.setImplementClass(implementClass);
                    extensionClassSet.add(extensionClass);
                }
            }
            HashSet<ExtensionClass<I, L>> hashSet = extensionClassSet;
            return hashSet;
        }
    }
}

