/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.classloader;

import com.alipay.sofa.ark.container.service.ArkServiceContainerHolder;
import com.alipay.sofa.ark.container.service.classloader.AbstractClasspathClassLoader;
import com.alipay.sofa.ark.exception.ArkLoaderException;
import com.alipay.sofa.ark.spi.model.Plugin;
import com.alipay.sofa.ark.spi.service.classloader.ClassLoaderHook;
import com.alipay.sofa.ark.spi.service.extension.ArkServiceLoader;
import com.alipay.sofa.ark.spi.service.plugin.PluginManagerService;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;

public class PluginClassLoader
extends AbstractClasspathClassLoader {
    private String pluginName;
    private ClassLoaderHook<Plugin> pluginClassLoaderHook;
    private AtomicBoolean isHookLoaded = new AtomicBoolean(false);
    private AtomicBoolean skipLoadHook = new AtomicBoolean(false);
    private PluginManagerService pluginManagerService = ArkServiceContainerHolder.getContainer().getService(PluginManagerService.class);
    private final Object lock = new Object();

    public PluginClassLoader(String pluginName, URL[] urls) {
        super(urls);
        this.pluginName = pluginName;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    protected Class<?> loadClassInternal(String name, boolean resolve) throws ArkLoaderException {
        Class<?> clazz = null;
        if (this.classloaderService.isSunReflectClass(name)) {
            throw new ArkLoaderException(String.format("[ArkPlugin Loader] %s : can not load class: %s, this class can only be loaded by sun.reflect.DelegatingClassLoader", this.pluginName, name));
        }
        if (clazz == null) {
            clazz = this.findLoadedClass(name);
        }
        if (clazz == null) {
            clazz = this.resolveJDKClass(name);
        }
        if (clazz == null) {
            clazz = this.resolveArkClass(name);
        }
        if (clazz == null) {
            clazz = this.preLoadClass(name);
        }
        if (clazz == null) {
            clazz = this.resolveExportClass(name);
        }
        if (clazz == null) {
            clazz = this.resolveLocalClass(name);
        }
        if (clazz == null) {
            clazz = this.resolveJavaAgentClass(name);
        }
        if (clazz == null) {
            clazz = this.postLoadClass(name);
        }
        if (clazz != null) {
            if (resolve) {
                super.resolveClass(clazz);
            }
            return clazz;
        }
        throw new ArkLoaderException(String.format("[ArkPlugin Loader] %s : can not load class: %s", this.pluginName, name));
    }

    @Override
    boolean shouldFindExportedClass(String className) {
        return this.classloaderService.isClassInImport(this.pluginName, className);
    }

    @Override
    boolean shouldFindExportedResource(String resourceName) {
        return this.classloaderService.isResourceInImport(this.pluginName, resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPluginClassLoaderHook() {
        if (!this.skipLoadHook.get()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isHookLoaded.compareAndSet(false, true)) {
                    this.pluginClassLoaderHook = (ClassLoaderHook)ArkServiceLoader.loadExtensionFromArkPlugin(ClassLoaderHook.class, (String)"plugin-classloader-hook", (String)this.pluginName);
                    this.skipLoadHook.set(true);
                }
            }
        }
    }

    @Override
    protected Class<?> preLoadClass(String className) throws ArkLoaderException {
        try {
            this.loadPluginClassLoaderHook();
            return this.pluginClassLoaderHook == null ? null : this.pluginClassLoaderHook.preFindClass(className, this.classloaderService, (Object)this.pluginManagerService.getPluginByName(this.pluginName));
        }
        catch (Throwable throwable) {
            throw new ArkLoaderException(String.format("Pre find class %s occurs an error via plugin ClassLoaderHook: %s.", className, this.pluginClassLoaderHook), throwable);
        }
    }

    @Override
    protected Class<?> postLoadClass(String className) throws ArkLoaderException {
        try {
            this.loadPluginClassLoaderHook();
            return this.pluginClassLoaderHook == null ? null : this.pluginClassLoaderHook.postFindClass(className, this.classloaderService, (Object)this.pluginManagerService.getPluginByName(this.pluginName));
        }
        catch (Throwable throwable) {
            throw new ArkLoaderException(String.format("Post find class %s occurs an error via plugin ClassLoaderHook: %s.", className, this.pluginClassLoaderHook), throwable);
        }
    }

    @Override
    protected URL preFindResource(String resourceName) {
        this.loadPluginClassLoaderHook();
        return this.pluginClassLoaderHook == null ? null : this.pluginClassLoaderHook.preFindResource(resourceName, this.classloaderService, (Object)this.pluginManagerService.getPluginByName(this.pluginName));
    }

    @Override
    protected URL postFindResource(String resourceName) {
        this.loadPluginClassLoaderHook();
        return this.pluginClassLoaderHook == null ? null : this.pluginClassLoaderHook.postFindResource(resourceName, this.classloaderService, (Object)this.pluginManagerService.getPluginByName(this.pluginName));
    }

    @Override
    protected Enumeration<URL> preFindResources(String resourceName) throws IOException {
        this.loadPluginClassLoaderHook();
        return this.pluginClassLoaderHook == null ? null : this.pluginClassLoaderHook.preFindResources(resourceName, this.classloaderService, (Object)this.pluginManagerService.getPluginByName(this.pluginName));
    }

    @Override
    protected Enumeration<URL> postFindResources(String resourceName) throws IOException {
        this.loadPluginClassLoaderHook();
        return this.pluginClassLoaderHook == null ? null : this.pluginClassLoaderHook.postFindResources(resourceName, this.classloaderService, (Object)this.pluginManagerService.getPluginByName(this.pluginName));
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

